/* ===============================================																																																																																				*/
/* ADUCRF101 HEADER FILE																																																																																				*/
/* 05th May 2011																																																																																				*/
/* Rev 1.2 																																																																																				*/
/* Rev. B Silicon																																																																																				*/
/* ===============================================																																																																																				*/
#ifndef __MACROS_ADUCRF101_H__
#define __MACROS_ADUCRF101_H__

/* Masks for bitfields in TLD*/
#define TLD_VALUE_MSK                  (0xFFFF << 0)

/* Masks for bitfields in TVAL*/
#define TVAL_VALUE_MSK                 (0xFFFF << 0)

/* Masks for bitfields in TCON*/
#define TCON_PRE_MSK                   (0x3 << 0)
#define TCON_UP                        (0x1 << 2)
#define TCON_MOD                       (0x1 << 3)
#define TCON_ENABLE                    (0x1 << 4)
#define TCON_CLK_MSK                   (0x3 << 5)
#define TCON_RLD                       (0x1 << 7)
#define TCON_EVENT_MSK                 (0xF << 8)
#define TCON_EVENTEN                   (0x1 << 12)

/* Prescaler  */
#define TCON_PRE_DIV1                  (0 << 0)
#define TCON_PRE_DIV16                 (1 << 0)
#define TCON_PRE_DIV256                (2 << 0)
#define TCON_PRE_DIV32768              (3 << 0) /* If the selected clock source is UCLK then this setting results in a prescaler of 4. */
/* Mode  */
#define TCON_MOD_PERIODIC              (1 << 3)
#define TCON_MOD_FREERUN               (0 << 3)
/* Clock Select  */
#define TCON_CLK_UCLK                  (0 << 5) /* System Clock             */
#define TCON_CLK_HFOSC                 (1 << 5) /* Internal 16 Mhz Oscillator */
#define TCON_CLK_LFOSC                 (2 << 5) /* Internal 32 kHz Oscillator */
#define TCON_CLK_LFXTAL                (3 << 5) /* External 32 kHz crystal  */
/* Masks for bitfields in TCLRI*/
#define TCLRI_TMOUT                    (0x1 << 0)
#define TCLRI_CAP                      (0x1 << 1)

/* Clear timeout interrupt  */
#define TCLRI_TMOUT_CLR                (1 << 0)
/* Clear captured event interrupt  */
#define TCLRI_CAP_CLR                  (1 << 1)
/* Masks for bitfields in TCAP*/
#define TCAP_VALUE_MSK                 (0xFFFF << 0)

/* Masks for bitfields in TSTA*/
#define TSTA_TMOUT                     (0x1 << 0)
#define TSTA_CAP                       (0x1 << 1)
#define TSTA_BUSY                      (0x1 << 6)
#define TSTA_PDOK                      (0x1 << 7)


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* General Purpose Timer 0                            Base Address 0x40000000 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for T0LD*/
#define T0LD_RVAL                      0x0 

/* Masks for bitfields in T0LD*/
#define T0LD_VALUE_MSK                 TLD_VALUE_MSK

/* Reset Value for T0VAL*/
#define T0VAL_RVAL                     0x0 

/* Masks for bitfields in T0VAL*/
#define T0VAL_VALUE_MSK                TVAL_VALUE_MSK

/* Reset Value for T0CON*/
#define T0CON_RVAL                     0xA 
#define T0CON_UP_BBA                   (*(volatile unsigned long *) 0x42000108)
#define T0CON_MOD_BBA                  (*(volatile unsigned long *) 0x4200010C)
#define T0CON_ENABLE_BBA               (*(volatile unsigned long *) 0x42000110)
#define T0CON_RLD_BBA                  (*(volatile unsigned long *) 0x4200011C)
#define T0CON_EVENTEN_BBA              (*(volatile unsigned long *) 0x42000130)

/* Masks for bitfields in T0CON*/
#define T0CON_PRE_MSK                  (0x3 << 0)
#define T0CON_UP                       (0x1 << 2)
#define T0CON_MOD                      (0x1 << 3)
#define T0CON_ENABLE                   (0x1 << 4)
#define T0CON_CLK_MSK                  (0x3 << 5)
#define T0CON_RLD                      (0x1 << 7)
#define T0CON_EVENT_MSK                (0xF << 8)
#define T0CON_EVENTEN                  (0x1 << 12)

/* Prescaler  */
#define T0CON_PRE_DIV1                 (0 << 0)
#define T0CON_PRE_DIV16                (1 << 0)
#define T0CON_PRE_DIV256               (2 << 0)
#define T0CON_PRE_DIV32768             (3 << 0) /* If the selected clock source is UCLK then this setting results in a prescaler of 4. */
/* Mode  */
#define T0CON_MOD_PERIODIC             (1 << 3)
#define T0CON_MOD_FREERUN              (0 << 3)
/* Clock Select  */
#define T0CON_CLK_UCLK                 (0 << 5) /* System Clock             */
#define T0CON_CLK_HFOSC                (1 << 5) /* Internal 16 Mhz Oscillator */
#define T0CON_CLK_LFOSC                (2 << 5) /* Internal 32 kHz Oscillator */
#define T0CON_CLK_LFXTAL               (3 << 5) /* External 32 kHz crystal  */
/* Event Select, selects 1 of the available events.  */
#define T0CON_EVENT_T2                 (0 << 8) /* Wakeup Timer             */
#define T0CON_EVENT_EXT0               (1 << 8) /* External interrupt 0     */
#define T0CON_EVENT_EXT1               (2 << 8) /* External interrupt 1     */
#define T0CON_EVENT_EXT2               (3 << 8) /* External interrupt 2     */
#define T0CON_EVENT_EXT3               (4 << 8) /* External interrupt 3     */
#define T0CON_EVENT_EXT4               (5 << 8) /* External interrupt 4     */
#define T0CON_EVENT_EXT5               (6 << 8) /* External interrupt 5     */
#define T0CON_EVENT_EXT6               (7 << 8) /* External interrupt 6     */
#define T0CON_EVENT_EXT7               (8 << 8) /* External interrupt 7     */
#define T0CON_EVENT_EXT8               (9 << 8) /* External interrupt 8 connected to ADF7023 */
#define T0CON_EVENT_T3                 (10 << 8) /* Watchdog timer           */
#define T0CON_EVENT_T1                 (12 << 8) /* Timer1                   */
#define T0CON_EVENT_ADC                (13 << 8) /* ADC                      */
#define T0CON_EVENT_FEE                (14 << 8) /* Flash Controller         */
#define T0CON_EVENT_COM                (15 << 8) /* UART                     */
/* Reset Value for T0CLRI*/
#define T0CLRI_RVAL                    0x0 
#define T0CLRI_TMOUT_BBA               (*(volatile unsigned long *) 0x42000180)
#define T0CLRI_CAP_BBA                 (*(volatile unsigned long *) 0x42000184)

/* Masks for bitfields in T0CLRI*/
#define T0CLRI_TMOUT                   TCLRI_TMOUT
#define T0CLRI_CAP                     TCLRI_CAP

/* Clear timeout interrupt  */
#define T0CLRI_TMOUT_CLR               TCLRI_TMOUT_CLR
/* Clear captured event interrupt  */
#define T0CLRI_CAP_CLR                 TCLRI_CAP_CLR
/* Reset Value for T0CAP*/
#define T0CAP_RVAL                     0x0 

/* Masks for bitfields in T0CAP*/
#define T0CAP_VALUE_MSK                TCAP_VALUE_MSK

/* Reset Value for T0STA*/
#define T0STA_RVAL                     0x0 
#define T0STA_TMOUT_BBA                (*(volatile unsigned long *) 0x42000380)
#define T0STA_CAP_BBA                  (*(volatile unsigned long *) 0x42000384)
#define T0STA_BUSY_BBA                 (*(volatile unsigned long *) 0x42000398)
#define T0STA_PDOK_BBA                 (*(volatile unsigned long *) 0x4200039C)

/* Masks for bitfields in T0STA*/
#define T0STA_TMOUT                    TSTA_TMOUT
#define T0STA_CAP                      TSTA_CAP
#define T0STA_BUSY                     TSTA_BUSY
#define T0STA_PDOK                     TSTA_PDOK


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* General Purpose Timer 1                            Base Address 0x40000400 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for T1LD*/
#define T1LD_RVAL                      0x0 

/* Masks for bitfields in T1LD*/
#define T1LD_VALUE_MSK                 TLD_VALUE_MSK

/* Reset Value for T1VAL*/
#define T1VAL_RVAL                     0x0 

/* Masks for bitfields in T1VAL*/
#define T1VAL_VALUE_MSK                TVAL_VALUE_MSK

/* Reset Value for T1CON*/
#define T1CON_RVAL                     0xA 
#define T1CON_UP_BBA                   (*(volatile unsigned long *) 0x42008108)
#define T1CON_MOD_BBA                  (*(volatile unsigned long *) 0x4200810C)
#define T1CON_ENABLE_BBA               (*(volatile unsigned long *) 0x42008110)
#define T1CON_RLD_BBA                  (*(volatile unsigned long *) 0x4200811C)
#define T1CON_EVENTEN_BBA              (*(volatile unsigned long *) 0x42008130)

/* Masks for bitfields in T1CON*/
#define T1CON_PRE_MSK                  (0x3 << 0)
#define T1CON_UP                       (0x1 << 2)
#define T1CON_MOD                      (0x1 << 3)
#define T1CON_ENABLE                   (0x1 << 4)
#define T1CON_CLK_MSK                  (0x3 << 5)
#define T1CON_RLD                      (0x1 << 7)
#define T1CON_EVENT_MSK                (0xF << 8)
#define T1CON_EVENTEN                  (0x1 << 12)

/* Prescaler  */
#define T1CON_PRE_DIV1                 (0 << 0)
#define T1CON_PRE_DIV16                (1 << 0)
#define T1CON_PRE_DIV256               (2 << 0)
#define T1CON_PRE_DIV32768             (3 << 0) /* If the selected clock source is UCLK then this setting results in a prescaler of 4. */
/* Mode  */
#define T1CON_MOD_PERIODIC             (1 << 3)
#define T1CON_MOD_FREERUN              (0 << 3)
/* Clock Select  */
#define T1CON_CLK_UCLK                 (0 << 5) /* System Clock             */
#define T1CON_CLK_HFOSC                (1 << 5) /* Internal 16 Mhz Oscillator */
#define T1CON_CLK_LFOSC                (2 << 5) /* Internal 32 kHz Oscillator */
#define T1CON_CLK_LFXTAL               (3 << 5) /* External 32 kHz crystal  */
/* Event Select, selects 1 of the available events.  */
#define T1CON_EVENT_T0                 (0 << 8)
#define T1CON_EVENT_SPI0               (1 << 8)
#define T1CON_EVENT_SPI1               (2 << 8)
#define T1CON_EVENT_ISCS               (3 << 8)
#define T1CON_EVENT_ISCM               (4 << 8)
#define T1CON_EVENT_DMAERR             (6 << 8)
#define T1CON_EVENT_DMADONE            (7 << 8)
#define T1CON_EVENT_EXT1               (8 << 8)
#define T1CON_EVENT_EXT2               (9 << 8)
#define T1CON_EVENT_EXT3               (10 << 8)
#define T1CON_EVENT_PWMTRIP            (11 << 8)
#define T1CON_EVENT_PWM0               (12 << 8)
#define T1CON_EVENT_PWM1               (13 << 8)
#define T1CON_EVENT_PWM2               (14 << 8)
#define T1CON_EVENT_PWM3               (15 << 8)
/* Reset Value for T1CLRI*/
#define T1CLRI_RVAL                    0x0 
#define T1CLRI_TMOUT_BBA               (*(volatile unsigned long *) 0x42008180)
#define T1CLRI_CAP_BBA                 (*(volatile unsigned long *) 0x42008184)

/* Masks for bitfields in T1CLRI*/
#define T1CLRI_TMOUT                   TCLRI_TMOUT
#define T1CLRI_CAP                     TCLRI_CAP

/* Clear timeout interrupt  */
#define T1CLRI_TMOUT_CLR               TCLRI_TMOUT_CLR
/* Clear captured event interrupt  */
#define T1CLRI_CAP_CLR                 TCLRI_CAP_CLR
/* Reset Value for T1CAP*/
#define T1CAP_RVAL                     0x0 

/* Masks for bitfields in T1CAP*/
#define T1CAP_VALUE_MSK                TCAP_VALUE_MSK

/* Reset Value for T1STA*/
#define T1STA_RVAL                     0x0 
#define T1STA_TMOUT_BBA                (*(volatile unsigned long *) 0x42008380)
#define T1STA_CAP_BBA                  (*(volatile unsigned long *) 0x42008384)
#define T1STA_BUSY_BBA                 (*(volatile unsigned long *) 0x42008398)
#define T1STA_PDOK_BBA                 (*(volatile unsigned long *) 0x4200839C)

/* Masks for bitfields in T1STA*/
#define T1STA_TMOUT                    TSTA_TMOUT
#define T1STA_CAP                      TSTA_CAP
#define T1STA_BUSY                     TSTA_BUSY
#define T1STA_PDOK                     TSTA_PDOK


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* PWM                                                Base Address 0x40001000 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for PWMCON0*/
#define PWMCON0_RVAL                   0x12 
#define PWMCON0_PWMEN_BBA              (*(volatile unsigned long *) 0x42020000)
#define PWMCON0_HMODE_BBA              (*(volatile unsigned long *) 0x42020004)
#define PWMCON0_DIR_BBA                (*(volatile unsigned long *) 0x42020008)
#define PWMCON0_LCOMP_BBA              (*(volatile unsigned long *) 0x4202000C)
#define PWMCON0_HOFF_BBA               (*(volatile unsigned long *) 0x42020010)
#define PWMCON0_POINV_BBA              (*(volatile unsigned long *) 0x42020014)
#define PWMCON0_ENA_BBA                (*(volatile unsigned long *) 0x42020024)
#define PWMCON0_PWMIEN_BBA             (*(volatile unsigned long *) 0x42020028)
#define PWMCON0_PWM1INV_BBA            (*(volatile unsigned long *) 0x4202002C)
#define PWMCON0_PWM3INV_BBA            (*(volatile unsigned long *) 0x42020030)
#define PWMCON0_PWM5INV_BBA            (*(volatile unsigned long *) 0x42020034)
#define PWMCON0_PWM7INV_BBA            (*(volatile unsigned long *) 0x42020038)
#define PWMCON0_SYNC_BBA               (*(volatile unsigned long *) 0x4202003C)

/* Masks for bitfields in PWMCON0*/
#define PWMCON0_PWMEN                  (0x1 << 0)
#define PWMCON0_HMODE                  (0x1 << 1)
#define PWMCON0_DIR                    (0x1 << 2)
#define PWMCON0_LCOMP                  (0x1 << 3)
#define PWMCON0_HOFF                   (0x1 << 4)
#define PWMCON0_POINV                  (0x1 << 5)
#define PWMCON0_PWMCP_MSK              (0x7 << 6)
#define PWMCON0_ENA                    (0x1 << 9)
#define PWMCON0_PWMIEN                 (0x1 << 10)
#define PWMCON0_PWM1INV                (0x1 << 11)
#define PWMCON0_PWM3INV                (0x1 << 12)
#define PWMCON0_PWM5INV                (0x1 << 13)
#define PWMCON0_PWM7INV                (0x1 << 14)
#define PWMCON0_SYNC                   (0x1 << 15)

/* Reset Value for PWMCON1*/
#define PWMCON1_RVAL                   0x0 
#define PWMCON1_TRIPEN_BBA             (*(volatile unsigned long *) 0x42020098)
#define PWMCON1_CONVSTARTEN_BBA        (*(volatile unsigned long *) 0x4202009C)

/* Masks for bitfields in PWMCON1*/
#define PWMCON1_CONVSTARTDELAY_MSK     (0xF << 0)
#define PWMCON1_TRIPEN                 (0x1 << 6)
#define PWMCON1_CONVSTARTEN            (0x1 << 7)

/* Reset Value for PWMCLRI*/
#define PWMCLRI_RVAL                   0x0 
#define PWMCLRI_PWM0_BBA               (*(volatile unsigned long *) 0x42020100)
#define PWMCLRI_PWM1_BBA               (*(volatile unsigned long *) 0x42020104)
#define PWMCLRI_PWM2_BBA               (*(volatile unsigned long *) 0x42020108)
#define PWMCLRI_PWM3_BBA               (*(volatile unsigned long *) 0x4202010C)
#define PWMCLRI_TRIP_BBA               (*(volatile unsigned long *) 0x42020110)

/* Masks for bitfields in PWMCLRI*/
#define PWMCLRI_PWM0                   (0x1 << 0)
#define PWMCLRI_PWM1                   (0x1 << 1)
#define PWMCLRI_PWM2                   (0x1 << 2)
#define PWMCLRI_PWM3                   (0x1 << 3)
#define PWMCLRI_TRIP                   (0x1 << 4)

/* Reset Value for PWM0COM0*/
#define PWM0COM0_RVAL                  0x0 

/* Reset Value for PWM0COM1*/
#define PWM0COM1_RVAL                  0x0 

/* Reset Value for PWM0COM2*/
#define PWM0COM2_RVAL                  0x0 

/* Reset Value for PWM0LEN*/
#define PWM0LEN_RVAL                   0x0 

/* Reset Value for PWM1COM0*/
#define PWM1COM0_RVAL                  0x0 

/* Reset Value for PWM1COM1*/
#define PWM1COM1_RVAL                  0x0 

/* Reset Value for PWM1COM2*/
#define PWM1COM2_RVAL                  0x0 

/* Reset Value for PWM1LEN*/
#define PWM1LEN_RVAL                   0x0 

/* Reset Value for PWM2COM0*/
#define PWM2COM0_RVAL                  0x0 

/* Reset Value for PWM2COM1*/
#define PWM2COM1_RVAL                  0x0 

/* Reset Value for PWM2COM2*/
#define PWM2COM2_RVAL                  0x0 

/* Reset Value for PWM2LEN*/
#define PWM2LEN_RVAL                   0x0 

/* Reset Value for PWM3COM0*/
#define PWM3COM0_RVAL                  0x0 

/* Reset Value for PWM3COM1*/
#define PWM3COM1_RVAL                  0x0 

/* Reset Value for PWM3COM2*/
#define PWM3COM2_RVAL                  0x0 

/* Reset Value for PWM3LEN*/
#define PWM3LEN_RVAL                   0x0 


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Power Control                                      Base Address 0x40002400 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for PWRMOD*/
#define PWRMOD_RVAL                    0x40 

/* Masks for bitfields in PWRMOD*/
#define PWRMOD_MOD_MSK                 (0x7 << 0)

/* Power Mode  */
#define PWRMOD_MOD_FULLACTIVE          (0 << 0)
#define PWRMOD_MOD_MCUHALT             (1 << 0)
#define PWRMOD_MOD_PERHALT             (2 << 0)
#define PWRMOD_MOD_SYSHALT             (3 << 0)
#define PWRMOD_MOD_TOTALHALT           (4 << 0)
#define PWRMOD_MOD_HIBERNATE           (5 << 0)
#define PWRMOD_MOD_NONRETAINED         (6 << 0)
/* Reset Value for PWRKEY*/
#define PWRKEY_RVAL                    0x0 

/* Masks for bitfields in PWRKEY*/
#define PWRKEY_VALUE_MSK               (0xFFFF << 0)

/* Key value  */
#define PWRKEY_VALUE_KEY1              (18521 << 0)
#define PWRKEY_VALUE_KEY2              (62075 << 0)
/* Reset Value for PSMCON*/
#define PSMCON_RVAL                    0x1 
#define PSMCON_PD_BBA                  (*(volatile unsigned long *) 0x42048100)

/* Masks for bitfields in PSMCON*/
#define PSMCON_PD                      (0x1 << 0)

/* Reset Value for XOSCCON*/
#define XOSCCON_RVAL                   0x0 
#define XOSCCON_ENABLE_BBA             (*(volatile unsigned long *) 0x42048200)
#define XOSCCON_DIV2_BBA               (*(volatile unsigned long *) 0x42048208)

/* Masks for bitfields in XOSCCON*/
#define XOSCCON_ENABLE                 (0x1 << 0)
#define XOSCCON_DIV2                   (0x1 << 2)

/* Reset Value for EI0CFG*/
#define EI0CFG_RVAL                    0x0 
#define EI0CFG_IRQ0EN_BBA              (*(volatile unsigned long *) 0x4204840C)
#define EI0CFG_IRQ1EN_BBA              (*(volatile unsigned long *) 0x4204841C)
#define EI0CFG_IRQ2EN_BBA              (*(volatile unsigned long *) 0x4204842C)
#define EI0CFG_IRQ3EN_BBA              (*(volatile unsigned long *) 0x4204843C)

/* Masks for bitfields in EI0CFG*/
#define EI0CFG_IRQ0MDE_MSK             (0x7 << 0)
#define EI0CFG_IRQ0EN                  (0x1 << 3)
#define EI0CFG_IRQ1MDE_MSK             (0x7 << 4)
#define EI0CFG_IRQ1EN                  (0x1 << 7)
#define EI0CFG_IRQ2MDE_MSK             (0x7 << 8)
#define EI0CFG_IRQ2EN                  (0x1 << 11)
#define EI0CFG_IRQ3MDE_MSK             (0x7 << 12)
#define EI0CFG_IRQ3EN                  (0x1 << 15)

/* External Interrupt 0 Mode  */
#define EI0CFG_IRQ0MDE_RISE            (0 << 0)
#define EI0CFG_IRQ0MDE_FALL            (1 << 0)
#define EI0CFG_IRQ0MDE_RISEORFALL      (2 << 0)
#define EI0CFG_IRQ0MDE_HIGHLEVEL       (3 << 0)
#define EI0CFG_IRQ0MDE_LOWLEVEL        (4 << 0)
/* External Interrupt 1 Mode  */
#define EI0CFG_IRQ1MDE_RISE            (0 << 4)
#define EI0CFG_IRQ1MDE_FALL            (1 << 4)
#define EI0CFG_IRQ1MDE_RISEORFALL      (2 << 4)
#define EI0CFG_IRQ1MDE_HIGHLEVEL       (3 << 4)
#define EI0CFG_IRQ1MDE_LOWLEVEL        (4 << 4)
/* External Interrupt 2 Mode  */
#define EI0CFG_IRQ2MDE_RISE            (0 << 8)
#define EI0CFG_IRQ2MDE_FALL            (1 << 8)
#define EI0CFG_IRQ2MDE_RISEORFALL      (2 << 8)
#define EI0CFG_IRQ2MDE_HIGHLEVEL       (3 << 8)
#define EI0CFG_IRQ2MDE_LOWLEVEL        (4 << 8)
/* External Interrupt 0 Mode  */
#define EI0CFG_IRQ3MDE_RISE            (0 << 12)
#define EI0CFG_IRQ3MDE_FALL            (1 << 12)
#define EI0CFG_IRQ3MDE_RISEORFALL      (2 << 12)
#define EI0CFG_IRQ3MDE_HIGHLEVEL       (3 << 12)
#define EI0CFG_IRQ3MDE_LOWLEVEL        (4 << 12)
/* Reset Value for EI1CFG*/
#define EI1CFG_RVAL                    0x0 
#define EI1CFG_IRQ4EN_BBA              (*(volatile unsigned long *) 0x4204848C)
#define EI1CFG_IRQ5EN_BBA              (*(volatile unsigned long *) 0x4204849C)
#define EI1CFG_IRQ6EN_BBA              (*(volatile unsigned long *) 0x420484AC)
#define EI1CFG_IRQ7EN_BBA              (*(volatile unsigned long *) 0x420484BC)

/* Masks for bitfields in EI1CFG*/
#define EI1CFG_IRQ4MDE_MSK             (0x7 << 0)
#define EI1CFG_IRQ4EN                  (0x1 << 3)
#define EI1CFG_IRQ5MDE_MSK             (0x7 << 4)
#define EI1CFG_IRQ5EN                  (0x1 << 7)
#define EI1CFG_IRQ6MDE_MSK             (0x7 << 8)
#define EI1CFG_IRQ6EN                  (0x1 << 11)
#define EI1CFG_IRQ7MDE_MSK             (0x7 << 12)
#define EI1CFG_IRQ7EN                  (0x1 << 15)

/* External Interrupt 4 Mode  */
#define EI1CFG_IRQ4MDE_RISE            (0 << 0)
#define EI1CFG_IRQ4MDE_FALL            (1 << 0)
#define EI1CFG_IRQ4MDE_RISEORFALL      (2 << 0)
#define EI1CFG_IRQ4MDE_HIGHLEVEL       (3 << 0)
#define EI1CFG_IRQ4MDE_LOWLEVEL        (4 << 0)
/* External Interrupt 5 Mode  */
#define EI1CFG_IRQ5MDE_RISE            (0 << 4)
#define EI1CFG_IRQ5MDE_FALL            (1 << 4)
#define EI1CFG_IRQ5MDE_RISEORFALL      (2 << 4)
#define EI1CFG_IRQ5MDE_HIGHLEVEL       (3 << 4)
#define EI1CFG_IRQ5MDE_LOWLEVEL        (4 << 4)
/* External Interrupt 6 Mode  */
#define EI1CFG_IRQ6MDE_RISE            (0 << 8)
#define EI1CFG_IRQ6MDE_FALL            (1 << 8)
#define EI1CFG_IRQ6MDE_RISEORFALL      (2 << 8)
#define EI1CFG_IRQ6MDE_HIGHLEVEL       (3 << 8)
#define EI1CFG_IRQ6MDE_LOWLEVEL        (4 << 8)
/* External Interrupt 7 Mode  */
#define EI1CFG_IRQ7MDE_RISE            (0 << 12)
#define EI1CFG_IRQ7MDE_FALL            (1 << 12)
#define EI1CFG_IRQ7MDE_RISEORFALL      (2 << 12)
#define EI1CFG_IRQ7MDE_HIGHLEVEL       (3 << 12)
#define EI1CFG_IRQ7MDE_LOWLEVEL        (4 << 12)
/* Reset Value for EI2CFG*/
#define EI2CFG_RVAL                    0x0 
#define EI2CFG_IRQ8EN_BBA              (*(volatile unsigned long *) 0x4204850C)

/* Masks for bitfields in EI2CFG*/
#define EI2CFG_IRQ8MDE_MSK             (0x7 << 0)
#define EI2CFG_IRQ8EN                  (0x1 << 3)

/* External Interrupt 8 Mode  */
#define EI2CFG_IRQ8MDE_RISE            (0 << 0)
#define EI2CFG_IRQ8MDE_FALL            (1 << 0)
#define EI2CFG_IRQ8MDE_RISEORFALL      (2 << 0)
#define EI2CFG_IRQ8MDE_HIGHLEVEL       (3 << 0)
#define EI2CFG_IRQ8MDE_LOWLEVEL        (4 << 0)
/* Reset Value for EICLR*/
#define EICLR_RVAL                     0x0 
#define EICLR_IRQ0_BBA                 (*(volatile unsigned long *) 0x42048600)
#define EICLR_IRQ1_BBA                 (*(volatile unsigned long *) 0x42048604)
#define EICLR_IRQ2_BBA                 (*(volatile unsigned long *) 0x42048608)
#define EICLR_IRQ3_BBA                 (*(volatile unsigned long *) 0x4204860C)
#define EICLR_IRQ4_BBA                 (*(volatile unsigned long *) 0x42048610)
#define EICLR_IRQ5_BBA                 (*(volatile unsigned long *) 0x42048614)
#define EICLR_IRQ6_BBA                 (*(volatile unsigned long *) 0x42048618)
#define EICLR_IRQ7_BBA                 (*(volatile unsigned long *) 0x4204861C)
#define EICLR_IRQ8_BBA                 (*(volatile unsigned long *) 0x42048620)

/* Masks for bitfields in EICLR*/
#define EICLR_IRQ0                     (0x1 << 0)
#define EICLR_IRQ1                     (0x1 << 1)
#define EICLR_IRQ2                     (0x1 << 2)
#define EICLR_IRQ3                     (0x1 << 3)
#define EICLR_IRQ4                     (0x1 << 4)
#define EICLR_IRQ5                     (0x1 << 5)
#define EICLR_IRQ6                     (0x1 << 6)
#define EICLR_IRQ7                     (0x1 << 7)
#define EICLR_IRQ8                     (0x1 << 8)

/* Clears External interrupt 0 internal flag  */
#define EICLR_IRQ0_CLR                 (1 << 0)
/* Clears External interrupt 1 internal flag  */
#define EICLR_IRQ1_CLR                 (1 << 1)
/* Clears External interrupt 2 internal flag  */
#define EICLR_IRQ2_CLR                 (1 << 2)
/* Clears External interrupt 3 internal flag  */
#define EICLR_IRQ3_CLR                 (1 << 3)
/* Clears External interrupt 4 internal flag  */
#define EICLR_IRQ4_CLR                 (1 << 4)
/* Clears External interrupt 5 internal flag  */
#define EICLR_IRQ5_CLR                 (1 << 5)
/* Clears External interrupt 6 internal flag  */
#define EICLR_IRQ6_CLR                 (1 << 6)
/* Clears External interrupt 7 internal flag  */
#define EICLR_IRQ7_CLR                 (1 << 7)
/* Clears External interrupt 8 internal flag  */
#define EICLR_IRQ8_CLR                 (1 << 8)
/* Reset Value for NMICLR*/
#define NMICLR_RVAL                    0x0 
#define NMICLR_CLEAR_BBA               (*(volatile unsigned long *) 0x42048680)

/* Masks for bitfields in NMICLR*/
#define NMICLR_CLEAR                   (0x1 << 0)

/* Reset Value for RSTSTA*/
#define RSTSTA_RVAL                    0x1 
#define RSTSTA_POR_BBA                 (*(volatile unsigned long *) 0x42048800)
#define RSTSTA_EXTRST_BBA              (*(volatile unsigned long *) 0x42048804)
#define RSTSTA_WDRST_BBA               (*(volatile unsigned long *) 0x42048808)
#define RSTSTA_SWRST_BBA               (*(volatile unsigned long *) 0x4204880C)

/* Masks for bitfields in RSTSTA*/
#define RSTSTA_POR                     (0x1 << 0)
#define RSTSTA_EXTRST                  (0x1 << 1)
#define RSTSTA_WDRST                   (0x1 << 2)
#define RSTSTA_SWRST                   (0x1 << 3)

/* Reset Value for RSTCLR*/
#define RSTCLR_RVAL                    0x1 
#define RSTCLR_POR_BBA                 (*(volatile unsigned long *) 0x42048800)
#define RSTCLR_EXTRST_BBA              (*(volatile unsigned long *) 0x42048804)
#define RSTCLR_WDRST_BBA               (*(volatile unsigned long *) 0x42048808)
#define RSTCLR_SWRST_BBA               (*(volatile unsigned long *) 0x4204880C)

/* Masks for bitfields in RSTCLR*/
#define RSTCLR_POR                     (0x1 << 0)
#define RSTCLR_EXTRST                  (0x1 << 1)
#define RSTCLR_WDRST                   (0x1 << 2)
#define RSTCLR_SWRST                   (0x1 << 3)


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Watchdog Timer                                     Base Address 0x40002580 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for T3LD*/
#define T3LD_RVAL                      0x1000 

/* Masks for bitfields in T3LD*/
#define T3LD_VALUE_MSK                 (0xFFFF << 0)

/* Reset Value for T3VAL*/
#define T3VAL_RVAL                     0x1000 

/* Masks for bitfields in T3VAL*/
#define T3VAL_VALUE_MSK                (0xFFFF << 0)

/* Reset Value for T3CON*/
#define T3CON_RVAL                     0xE9 
#define T3CON_PD_BBA                   (*(volatile unsigned long *) 0x4204B100)
#define T3CON_IRQ_BBA                  (*(volatile unsigned long *) 0x4204B104)
#define T3CON_ENABLE_BBA               (*(volatile unsigned long *) 0x4204B114)
#define T3CON_MOD_BBA                  (*(volatile unsigned long *) 0x4204B118)

/* Masks for bitfields in T3CON*/
#define T3CON_PD                       (0x1 << 0)
#define T3CON_IRQ                      (0x1 << 1)
#define T3CON_PRE_MSK                  (0x3 << 2)
#define T3CON_ENABLE                   (0x1 << 5)
#define T3CON_MOD                      (0x1 << 6)

/* Prescaler  */
#define T3CON_PRE_DIV1                 (0 << 2)
#define T3CON_PRE_DIV16                (1 << 2)
#define T3CON_PRE_DIV256               (2 << 2)
#define T3CON_PRE_DIV4096              (3 << 2)
/* Mode  */
#define T3CON_MOD_PERIODIC             (1 << 6)
#define T3CON_MOD_FREERUN              (0 << 6)
/* Reset Value for T3CLRI*/
#define T3CLRI_RVAL                    0x0 

/* Masks for bitfields in T3CLRI*/
#define T3CLRI_VALUE_MSK               (0xFFFF << 0)

/* Clear Watchdog  */
#define T3CLRI_VALUE_CLR               (52428 << 0)
/* Reset Value for T3STA*/
#define T3STA_RVAL                     0x20 
#define T3STA_IRQ_BBA                  (*(volatile unsigned long *) 0x4204B300)
#define T3STA_CLRI_BBA                 (*(volatile unsigned long *) 0x4204B304)
#define T3STA_LD_BBA                   (*(volatile unsigned long *) 0x4204B308)
#define T3STA_CON_BBA                  (*(volatile unsigned long *) 0x4204B30C)
#define T3STA_LOCK_BBA                 (*(volatile unsigned long *) 0x4204B310)

/* Masks for bitfields in T3STA*/
#define T3STA_IRQ                      (0x1 << 0)
#define T3STA_CLRI                     (0x1 << 1)
#define T3STA_LD                       (0x1 << 2)
#define T3STA_CON                      (0x1 << 3)
#define T3STA_LOCK                     (0x1 << 4)


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Wake Up Timer                                      Base Address 0x40002500 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for T2VAL0*/
#define T2VAL0_RVAL                    0x0 

/* Masks for bitfields in T2VAL0*/
#define T2VAL0_VALUE_MSK               (0xFFFF << 0)

/* Reset Value for T2VAL1*/
#define T2VAL1_RVAL                    0x0 

/* Masks for bitfields in T2VAL1*/
#define T2VAL1_VALUE_MSK               (0xFFFF << 0)

/* Reset Value for T2CON*/
#define T2CON_RVAL                     0x40 
#define T2CON_FREEZE_BBA               (*(volatile unsigned long *) 0x4204A10C)
#define T2CON_MOD_BBA                  (*(volatile unsigned long *) 0x4204A118)
#define T2CON_ENABLE_BBA               (*(volatile unsigned long *) 0x4204A11C)
#define T2CON_WUEN_BBA                 (*(volatile unsigned long *) 0x4204A120)
#define T2CON_STOPINC_BBA              (*(volatile unsigned long *) 0x4204A12C)

/* Masks for bitfields in T2CON*/
#define T2CON_PRE_MSK                  (0x3 << 0)
#define T2CON_FREEZE                   (0x1 << 3)
#define T2CON_MOD                      (0x1 << 6)
#define T2CON_ENABLE                   (0x1 << 7)
#define T2CON_WUEN                     (0x1 << 8)
#define T2CON_CLK_MSK                  (0x3 << 9)
#define T2CON_STOPINC                  (0x1 << 11)

/* Prescaler  */
#define T2CON_PRE_DIV1                 (0 << 0)
#define T2CON_PRE_DIV16                (1 << 0)
#define T2CON_PRE_DIV256               (2 << 0)
#define T2CON_PRE_DIV32768             (3 << 0)
/* Mode  */
#define T2CON_MOD_PERIODIC             (0 << 6)
#define T2CON_MOD_FREERUN              (1 << 6)
/* Clock  */
#define T2CON_CLK_PCLK                 (0 << 9)
#define T2CON_CLK_LFXTAL               (1 << 9)
#define T2CON_CLK_LFOSC                (2 << 9)
#define T2CON_CLK_EXTCLK               (3 << 9)
/* Reset Value for T2INC*/
#define T2INC_RVAL                     0xC8 

/* Masks for bitfields in T2INC*/
#define T2INC_VALUE_MSK                (0xFFF << 0)

/* Reset Value for T2WUFB0*/
#define T2WUFB0_RVAL                   0x1FFF 

/* Masks for bitfields in T2WUFB0*/
#define T2WUFB0_VALUE_MSK              (0xFFFF << 0)

/* Reset Value for T2WUFB1*/
#define T2WUFB1_RVAL                   0x0 

/* Masks for bitfields in T2WUFB1*/
#define T2WUFB1_VALUE_MSK              (0xFFFF << 0)

/* Reset Value for T2WUFC0*/
#define T2WUFC0_RVAL                   0x2FFF 

/* Masks for bitfields in T2WUFC0*/
#define T2WUFC0_VALUE_MSK              (0xFFFF << 0)

/* Reset Value for T2WUFC1*/
#define T2WUFC1_RVAL                   0x0 

/* Masks for bitfields in T2WUFC1*/
#define T2WUFC1_VALUE_MSK              (0xFFFF << 0)

/* Reset Value for T2WUFD0*/
#define T2WUFD0_RVAL                   0x3FFF 

/* Masks for bitfields in T2WUFD0*/
#define T2WUFD0_VALUE_MSK              (0xFFFF << 0)

/* Reset Value for T2WUFD1*/
#define T2WUFD1_RVAL                   0x0 

/* Masks for bitfields in T2WUFD1*/
#define T2WUFD1_VALUE_MSK              (0xFFFF << 0)

/* Reset Value for T2IEN*/
#define T2IEN_RVAL                     0x0 
#define T2IEN_WUFA_BBA                 (*(volatile unsigned long *) 0x4204A500)
#define T2IEN_WUFB_BBA                 (*(volatile unsigned long *) 0x4204A504)
#define T2IEN_WUFC_BBA                 (*(volatile unsigned long *) 0x4204A508)
#define T2IEN_WUFD_BBA                 (*(volatile unsigned long *) 0x4204A50C)
#define T2IEN_ROLL_BBA                 (*(volatile unsigned long *) 0x4204A510)

/* Masks for bitfields in T2IEN*/
#define T2IEN_WUFA                     (0x1 << 0)
#define T2IEN_WUFB                     (0x1 << 1)
#define T2IEN_WUFC                     (0x1 << 2)
#define T2IEN_WUFD                     (0x1 << 3)
#define T2IEN_ROLL                     (0x1 << 4)

/* Reset Value for T2STA*/
#define T2STA_RVAL                     0x0 
#define T2STA_WUFA_BBA                 (*(volatile unsigned long *) 0x4204A580)
#define T2STA_WUFB_BBA                 (*(volatile unsigned long *) 0x4204A584)
#define T2STA_WUFC_BBA                 (*(volatile unsigned long *) 0x4204A588)
#define T2STA_WUFD_BBA                 (*(volatile unsigned long *) 0x4204A58C)
#define T2STA_ROLL_BBA                 (*(volatile unsigned long *) 0x4204A590)
#define T2STA_IRQCRY_BBA               (*(volatile unsigned long *) 0x4204A598)
#define T2STA_FREEZE_BBA               (*(volatile unsigned long *) 0x4204A59C)
#define T2STA_PDOK_BBA                 (*(volatile unsigned long *) 0x4204A5A0)

/* Masks for bitfields in T2STA*/
#define T2STA_WUFA                     (0x1 << 0)
#define T2STA_WUFB                     (0x1 << 1)
#define T2STA_WUFC                     (0x1 << 2)
#define T2STA_WUFD                     (0x1 << 3)
#define T2STA_ROLL                     (0x1 << 4)
#define T2STA_IRQCRY                   (0x1 << 6)
#define T2STA_FREEZE                   (0x1 << 7)
#define T2STA_PDOK                     (0x1 << 8)

/* Reset Value for T2CLRI*/
#define T2CLRI_RVAL                    0x0 
#define T2CLRI_WUFA_BBA                (*(volatile unsigned long *) 0x4204A600)
#define T2CLRI_WUFB_BBA                (*(volatile unsigned long *) 0x4204A604)
#define T2CLRI_WUFC_BBA                (*(volatile unsigned long *) 0x4204A608)
#define T2CLRI_WUFD_BBA                (*(volatile unsigned long *) 0x4204A60C)
#define T2CLRI_ROLL_BBA                (*(volatile unsigned long *) 0x4204A610)

/* Masks for bitfields in T2CLRI*/
#define T2CLRI_WUFA                    (0x1 << 0)
#define T2CLRI_WUFB                    (0x1 << 1)
#define T2CLRI_WUFC                    (0x1 << 2)
#define T2CLRI_WUFD                    (0x1 << 3)
#define T2CLRI_ROLL                    (0x1 << 4)

/* Clear interrupt on WUFA  */
#define T2CLRI_WUFA_CLR                (1 << 0)
/* Clear interrupt on WUFB  */
#define T2CLRI_WUFB_CLR                (1 << 1)
/* Clear interrupt on WUFC  */
#define T2CLRI_WUFC_CLR                (1 << 2)
/* Clear interrupt on WUFD  */
#define T2CLRI_WUFD_CLR                (1 << 3)
/* Clear interrupt on Rollover  */
#define T2CLRI_ROLL_CLR                (1 << 4)
/* Reset Value for T2WUFA0*/
#define T2WUFA0_RVAL                   0x1900 

/* Masks for bitfields in T2WUFA0*/
#define T2WUFA0_VALUE_MSK              (0xFFFF << 0)

/* Reset Value for T2WUFA1*/
#define T2WUFA1_RVAL                   0x0 

/* Masks for bitfields in T2WUFA1*/
#define T2WUFA1_VALUE_MSK              (0xFFFF << 0)


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Clock Control                                      Base Address 0x40002000 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for CLKCON*/
#define CLKCON_RVAL                    0x0 

/* Masks for bitfields in CLKCON*/
#define CLKCON_CD_MSK                  (0x7 << 0)
#define CLKCON_CLKMUX_MSK              (0x3 << 3)
#define CLKCON_CLKOUT_MSK              (0x7 << 5)

/* Clock divide bits  */
#define CLKCON_CD_DIV1                 (0 << 0)
#define CLKCON_CD_CLK16MHZ             (0 << 0)
#define CLKCON_CD_DIV2                 (1 << 0)
#define CLKCON_CD_CLK8MHZ              (1 << 0)
#define CLKCON_CD_DIV4                 (2 << 0)
#define CLKCON_CD_CLK4MHZ              (2 << 0)
#define CLKCON_CD_DIV8                 (3 << 0)
#define CLKCON_CD_CLK2MHZ              (3 << 0)
#define CLKCON_CD_DIV16                (4 << 0)
#define CLKCON_CD_CLK1MHZ              (4 << 0)
#define CLKCON_CD_DIV32                (5 << 0)
#define CLKCON_CD_CLK500KHZ            (5 << 0)
#define CLKCON_CD_DIV64                (6 << 0)
#define CLKCON_CD_CLK16250KHZ          (6 << 0)
#define CLKCON_CD_DIV128               (7 << 0)
#define CLKCON_CD_CLK125KHZ            (7 << 0)
/* Digital subsystem clock source select bits. */
#define CLKCON_CLKMUX_HFOSC            (0 << 3)
#define CLKCON_CLKMUX_LFXTAL           (1 << 3)
#define CLKCON_CLKMUX_LFOSC            (2 << 3)
#define CLKCON_CLKMUX_EXTCLK           (3 << 3)
/* GPIO output clock multiplexer select bits  */
#define CLKCON_CLKOUT_UCLKCG           (0 << 5)
#define CLKCON_CLKOUT_UCLK             (1 << 5)
#define CLKCON_CLKOUT_PCLK             (2 << 5)
#define CLKCON_CLKOUT_HFOSC            (5 << 5)
#define CLKCON_CLKOUT_LFOSC            (6 << 5)
#define CLKCON_CLKOUT_LFXTAL           (7 << 5)
/* Reset Value for CLKCON0*/
#define CLKCON0_RVAL                   0x0 

/* Masks for bitfields in CLKCON0*/
#define CLKCON0_CD_MSK                 (0x7 << 0)
#define CLKCON0_CLKMUX_MSK             (0x3 << 3)
#define CLKCON0_CLKOUT_MSK             (0x7 << 5)

/* Clock divide bits  */
#define CLKCON0_CD_DIV1                (0 << 0)
#define CLKCON0_CD_CLK16MHZ            (0 << 0)
#define CLKCON0_CD_DIV2                (1 << 0)
#define CLKCON0_CD_CLK8MHZ             (1 << 0)
#define CLKCON0_CD_DIV4                (2 << 0)
#define CLKCON0_CD_CLK4MHZ             (2 << 0)
#define CLKCON0_CD_DIV8                (3 << 0)
#define CLKCON0_CD_CLK2MHZ             (3 << 0)
#define CLKCON0_CD_DIV16               (4 << 0)
#define CLKCON0_CD_CLK1MHZ             (4 << 0)
#define CLKCON0_CD_DIV32               (5 << 0)
#define CLKCON0_CD_CLK500KHZ           (5 << 0)
#define CLKCON0_CD_DIV64               (6 << 0)
#define CLKCON0_CD_CLK16250KHZ         (6 << 0)
#define CLKCON0_CD_DIV128              (7 << 0)
#define CLKCON0_CD_CLK125KHZ           (7 << 0)
/* Digital subsystem clock source select bits. */
#define CLKCON0_CLKMUX_HFOSC           (0 << 3)
#define CLKCON0_CLKMUX_LFXTAL          (1 << 3)
#define CLKCON0_CLKMUX_LFOSC           (2 << 3)
#define CLKCON0_CLKMUX_EXTCLK          (3 << 3)
/* GPIO output clock multiplexer select bits  */
#define CLKCON0_CLKOUT_UCLKCG          (0 << 5)
#define CLKCON0_CLKOUT_UCLK            (1 << 5)
#define CLKCON0_CLKOUT_PCLK            (2 << 5)
#define CLKCON0_CLKOUT_HFOSC           (5 << 5)
#define CLKCON0_CLKOUT_LFOSC           (6 << 5)
#define CLKCON0_CLKOUT_LFXTAL          (7 << 5)

/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Flash Interface 0                                  Base Address 0x40002800 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for FEESTA*/
#define FEESTA_RVAL                    0x0 
#define FEESTA_CMDBUSY_BBA             (*(volatile unsigned long *) 0x42050000)
#define FEESTA_WRBUSY_BBA              (*(volatile unsigned long *) 0x42050004)
#define FEESTA_CMDDONE_BBA             (*(volatile unsigned long *) 0x42050008)
#define FEESTA_WRDONE_BBA              (*(volatile unsigned long *) 0x4205000C)
#define FEESTA_SIGNERR_BBA             (*(volatile unsigned long *) 0x42050018)

/* Masks for bitfields in FEESTA*/
#define FEESTA_CMDBUSY                 (0x1 << 0)
#define FEESTA_WRBUSY                  (0x1 << 1)
#define FEESTA_CMDDONE                 (0x1 << 2)
#define FEESTA_WRDONE                  (0x1 << 3)
#define FEESTA_CMDRES_MSK              (0x3 << 4)
#define FEESTA_SIGNERR                 (0x1 << 6)

/* Command result  */
#define FEESTA_CMDRES_SUCCESS          (0 << 4)
#define FEESTA_CMDRES_PROTECTED        (1 << 4)
#define FEESTA_CMDRES_VERIFYERR        (2 << 4)
#define FEESTA_CMDRES_ABORT            (3 << 4)
/* Reset Value for FEECON0*/
#define FEECON0_RVAL                   0x0 
#define FEECON0_IENCMD_BBA             (*(volatile unsigned long *) 0x42050080)
#define FEECON0_IENERR_BBA             (*(volatile unsigned long *) 0x42050084)
#define FEECON0_WREN_BBA               (*(volatile unsigned long *) 0x42050088)

/* Masks for bitfields in FEECON0*/
#define FEECON0_IENCMD                 (0x1 << 0)
#define FEECON0_IENERR                 (0x1 << 1)
#define FEECON0_WREN                   (0x1 << 2)

/* Reset Value for FEECMD*/
#define FEECMD_RVAL                    0x0 

/* Masks for bitfields in FEECMD*/
#define FEECMD_CMD_MSK                 (0xF << 0)

/* Command  */
#define FEECMD_CMD_IDLE                (0 << 0) /* No command executed      */
#define FEECMD_CMD_ERASEPAGE           (1 << 0) /* Erase Page               */
#define FEECMD_CMD_SIGN                (2 << 0) /* Sign Range               */
#define FEECMD_CMD_MASSERASE           (3 << 0) /* Mass Erase User Space    */
#define FEECMD_CMD_ABORT               (4 << 0) /* Abort a running command  */
/* Reset Value for FEEADR0L*/
#define FEEADR0L_RVAL                  0x0 

/* Masks for bitfields in FEEADR0L*/
#define FEEADR0L_VALUE_MSK             (0xFFFF << 0)

/* Reset Value for FEEADR0H*/
#define FEEADR0H_RVAL                  0x0 

/* Masks for bitfields in FEEADR0H*/
#define FEEADR0H_VALUE_MSK             (0x3 << 0)

/* Reset Value for FEEADR1L*/
#define FEEADR1L_RVAL                  0x0 

/* Masks for bitfields in FEEADR1L*/
#define FEEADR1L_VALUE_MSK             (0xFFFF << 0)

/* Reset Value for FEEADR1H*/
#define FEEADR1H_RVAL                  0x0 

/* Masks for bitfields in FEEADR1H*/
#define FEEADR1H_VALUE_MSK             (0x3 << 0)

/* Reset Value for FEEKEY*/
#define FEEKEY_RVAL                    0x0 

/* Masks for bitfields in FEEKEY*/
#define FEEKEY_VALUE_MSK               (0xFFFF << 0)

/* Value  */
#define FEEKEY_VALUE_USERKEY1          (62550 << 0)
#define FEEKEY_VALUE_USERKEY2          (61731 << 0)
/* Reset Value for FEEPROL*/
#define FEEPROL_RVAL                   0xFFFF 

/* Masks for bitfields in FEEPROL*/
#define FEEPROL_VALUE_MSK              (0xFFFF << 0)

/* Reset Value for FEEPROH*/
#define FEEPROH_RVAL                   0xFFFF 

/* Masks for bitfields in FEEPROH*/
#define FEEPROH_VALUE_MSK              (0xFFFF << 0)

/* Reset Value for FEESIGL*/
#define FEESIGL_RVAL                   0xFFFF 

/* Masks for bitfields in FEESIGL*/
#define FEESIGL_VALUE_MSK              (0xFFFF << 0)

/* Reset Value for FEESIGH*/
#define FEESIGH_RVAL                   0xFFFF 

/* Masks for bitfields in FEESIGH*/
#define FEESIGH_VALUE_MSK              (0xFF << 0)

/* Reset Value for FEECON1*/
#define FEECON1_RVAL                   0x1 
#define FEECON1_DBG_BBA                (*(volatile unsigned long *) 0x42050700)

/* Masks for bitfields in FEECON1*/
#define FEECON1_DBG                    (0x1 << 0)

/* Reset Value for FEEADRAL*/
#define FEEADRAL_RVAL                  0x800 

/* Masks for bitfields in FEEADRAL*/
#define FEEADRAL_VALUE_MSK             (0xFFFF << 0)

/* Reset Value for FEEADRAH*/
#define FEEADRAH_RVAL                  0x2 

/* Masks for bitfields in FEEADRAH*/
#define FEEADRAH_VALUE_MSK             (0xFFFF << 0)

/* Reset Value for FEEAEN0*/
#define FEEAEN0_RVAL                   0x0 
#define FEEAEN0_T2_BBA                 (*(volatile unsigned long *) 0x42050F00)
#define FEEAEN0_EXTINT0_BBA            (*(volatile unsigned long *) 0x42050F04)
#define FEEAEN0_EXTINT1_BBA            (*(volatile unsigned long *) 0x42050F08)
#define FEEAEN0_EXTINT2_BBA            (*(volatile unsigned long *) 0x42050F0C)
#define FEEAEN0_EXTINT3_BBA            (*(volatile unsigned long *) 0x42050F10)
#define FEEAEN0_EXTINT4_BBA            (*(volatile unsigned long *) 0x42050F14)
#define FEEAEN0_EXTINT5_BBA            (*(volatile unsigned long *) 0x42050F18)
#define FEEAEN0_EXTINT6_BBA            (*(volatile unsigned long *) 0x42050F1C)
#define FEEAEN0_EXTINT7_BBA            (*(volatile unsigned long *) 0x42050F20)
#define FEEAEN0_EXTINT8_BBA            (*(volatile unsigned long *) 0x42050F24)
#define FEEAEN0_T3_BBA                 (*(volatile unsigned long *) 0x42050F28)
#define FEEAEN0_T0_BBA                 (*(volatile unsigned long *) 0x42050F30)
#define FEEAEN0_T1_BBA                 (*(volatile unsigned long *) 0x42050F34)
#define FEEAEN0_ADC_BBA                (*(volatile unsigned long *) 0x42050F38)
#define FEEAEN0_FEE_BBA                (*(volatile unsigned long *) 0x42050F3C)

/* Masks for bitfields in FEEAEN0*/
#define FEEAEN0_T2                     INT0015_T2
#define FEEAEN0_EXTINT0                INT0015_EXTINT0
#define FEEAEN0_EXTINT1                INT0015_EXTINT1
#define FEEAEN0_EXTINT2                INT0015_EXTINT2
#define FEEAEN0_EXTINT3                INT0015_EXTINT3
#define FEEAEN0_EXTINT4                INT0015_EXTINT4
#define FEEAEN0_EXTINT5                INT0015_EXTINT5
#define FEEAEN0_EXTINT6                INT0015_EXTINT6
#define FEEAEN0_EXTINT7                INT0015_EXTINT7
#define FEEAEN0_EXTINT8                INT0015_EXTINT8
#define FEEAEN0_T3                     INT0015_T3
#define FEEAEN0_T0                     INT0015_T0
#define FEEAEN0_T1                     INT0015_T1
#define FEEAEN0_ADC                    INT0015_ADC
#define FEEAEN0_FEE                    INT0015_FEE

/* Reset Value for FEEAEN1*/
#define FEEAEN1_RVAL                   0x0 
#define FEEAEN1_UART_BBA               (*(volatile unsigned long *) 0x42050F80)
#define FEEAEN1_SPI0_BBA               (*(volatile unsigned long *) 0x42050F84)
#define FEEAEN1_SPI1_BBA               (*(volatile unsigned long *) 0x42050F88)
#define FEEAEN1_I2CS_BBA               (*(volatile unsigned long *) 0x42050F8C)
#define FEEAEN1_I2CM_BBA               (*(volatile unsigned long *) 0x42050F90)
#define FEEAEN1_DMAERROR_BBA           (*(volatile unsigned long *) 0x42050F98)
#define FEEAEN1_DMASPI1TX_BBA          (*(volatile unsigned long *) 0x42050F9C)
#define FEEAEN1_DMASPI1RX_BBA          (*(volatile unsigned long *) 0x42050FA0)
#define FEEAEN1_DMAUARTTX_BBA          (*(volatile unsigned long *) 0x42050FA4)
#define FEEAEN1_DMAUARTRX_BBA          (*(volatile unsigned long *) 0x42050FA8)
#define FEEAEN1_DMAI2CSTX_BBA          (*(volatile unsigned long *) 0x42050FAC)
#define FEEAEN1_DMAI2CSRX_BBA          (*(volatile unsigned long *) 0x42050FB0)
#define FEEAEN1_DMAI2CMTX_BBA          (*(volatile unsigned long *) 0x42050FB4)
#define FEEAEN1_DMAI2CMRX_BBA          (*(volatile unsigned long *) 0x42050FB8)

/* Masks for bitfields in FEEAEN1*/
#define FEEAEN1_UART                   INT1631_UART
#define FEEAEN1_SPI0                   INT1631_SPI0
#define FEEAEN1_SPI1                   INT1631_SPI1
#define FEEAEN1_I2CS                   INT1631_I2CS
#define FEEAEN1_I2CM                   INT1631_I2CM
#define FEEAEN1_DMAERROR               INT1631_DMAERROR
#define FEEAEN1_DMASPI1TX              INT1631_DMASPI1TX
#define FEEAEN1_DMASPI1RX              INT1631_DMASPI1RX
#define FEEAEN1_DMAUARTTX              INT1631_DMAUARTTX
#define FEEAEN1_DMAUARTRX              INT1631_DMAUARTRX
#define FEEAEN1_DMAI2CSTX              INT1631_DMAI2CSTX
#define FEEAEN1_DMAI2CSRX              INT1631_DMAI2CSRX
#define FEEAEN1_DMAI2CMTX              INT1631_DMAI2CMTX
#define FEEAEN1_DMAI2CMRX              INT1631_DMAI2CMRX

/* Reset Value for FEEAEN2*/
#define FEEAEN2_RVAL                   0x0 
#define FEEAEN2_DMAADC_BBA             (*(volatile unsigned long *) 0x42051008)
#define FEEAEN2_DMASPI0TX_BBA          (*(volatile unsigned long *) 0x4205100C)
#define FEEAEN2_DMASPI0RX_BBA          (*(volatile unsigned long *) 0x42051010)
#define FEEAEN2_PWMTRIP_BBA            (*(volatile unsigned long *) 0x42051014)
#define FEEAEN2_PWM0_BBA               (*(volatile unsigned long *) 0x42051018)
#define FEEAEN2_PWM1_BBA               (*(volatile unsigned long *) 0x4205101C)
#define FEEAEN2_PWM2_BBA               (*(volatile unsigned long *) 0x42051020)
#define FEEAEN2_PWM3_BBA               (*(volatile unsigned long *) 0x42051024)

/* Masks for bitfields in FEEAEN2*/
#define FEEAEN2_DMAADC                 INT3247_DMAADC
#define FEEAEN2_DMASPI0TX              INT3247_DMASPI0TX
#define FEEAEN2_DMASPI0RX              INT3247_DMASPI0RX
#define FEEAEN2_PWMTRIP                INT3247_PWMTRIP
#define FEEAEN2_PWM0                   INT3247_PWM0
#define FEEAEN2_PWM1                   INT3247_PWM1
#define FEEAEN2_PWM2                   INT3247_PWM2
#define FEEAEN2_PWM3                   INT3247_PWM3


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* I2C                                                Base Address 0x40003000 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for I2CMCON*/
#define I2CMCON_RVAL                   0x0 
#define I2CMCON_MASEN_BBA              (*(volatile unsigned long *) 0x42060000)
#define I2CMCON_COMPETE_BBA            (*(volatile unsigned long *) 0x42060004)
#define I2CMCON_LOOPBACK_BBA           (*(volatile unsigned long *) 0x42060008)
#define I2CMCON_STRETCH_BBA            (*(volatile unsigned long *) 0x4206000C)
#define I2CMCON_IENRX_BBA              (*(volatile unsigned long *) 0x42060010)
#define I2CMCON_IENTX_BBA              (*(volatile unsigned long *) 0x42060014)
#define I2CMCON_IENALOST_BBA           (*(volatile unsigned long *) 0x42060018)
#define I2CMCON_IENNACK_BBA            (*(volatile unsigned long *) 0x4206001C)
#define I2CMCON_IENCMP_BBA             (*(volatile unsigned long *) 0x42060020)
#define I2CMCON_XMITDEC_BBA            (*(volatile unsigned long *) 0x42060024)
#define I2CMCON_RXDMA_BBA              (*(volatile unsigned long *) 0x42060028)
#define I2CMCON_TXDMA_BBA              (*(volatile unsigned long *) 0x4206002C)

/* Masks for bitfields in I2CMCON*/
#define I2CMCON_MASEN                  (0x1 << 0)
#define I2CMCON_COMPETE                (0x1 << 1)
#define I2CMCON_LOOPBACK               (0x1 << 2)
#define I2CMCON_STRETCH                (0x1 << 3)
#define I2CMCON_IENRX                  (0x1 << 4)
#define I2CMCON_IENTX                  (0x1 << 5)
#define I2CMCON_IENALOST               (0x1 << 6)
#define I2CMCON_IENNACK                (0x1 << 7)
#define I2CMCON_IENCMP                 (0x1 << 8)
#define I2CMCON_RXDMA                  (0x1 << 10)
#define I2CMCON_TXDMA                  (0x1 << 11)

/* Reset Value for I2CMSTA*/
#define I2CMSTA_RVAL                   0x0 
#define I2CMSTA_TXREQ_BBA              (*(volatile unsigned long *) 0x42060088)
#define I2CMSTA_RXREQ_BBA              (*(volatile unsigned long *) 0x4206008C)
#define I2CMSTA_NACKADDR_BBA           (*(volatile unsigned long *) 0x42060090)
#define I2CMSTA_ALOST_BBA              (*(volatile unsigned long *) 0x42060094)
#define I2CMSTA_BUSY_BBA               (*(volatile unsigned long *) 0x42060098)
#define I2CMSTA_NACKDATA_BBA           (*(volatile unsigned long *) 0x4206009C)
#define I2CMSTA_TCOMP_BBA              (*(volatile unsigned long *) 0x420600A0)
#define I2CMSTA_RXOF_BBA               (*(volatile unsigned long *) 0x420600A4)
#define I2CMSTA_LINEBUSY_BBA           (*(volatile unsigned long *) 0x420600A8)
#define I2CMSTA_MSTOP_BBA              (*(volatile unsigned long *) 0x420600AC)
#define I2CMSTA_TXUR_BBA               (*(volatile unsigned long *) 0x420600B0)

/* Masks for bitfields in I2CMSTA*/
#define I2CMSTA_TXFSTA_MSK             (0x3 << 0)
#define I2CMSTA_TXREQ                  (0x1 << 2)
#define I2CMSTA_RXREQ                  (0x1 << 3)
#define I2CMSTA_NACKADDR               (0x1 << 4)
#define I2CMSTA_ALOST                  (0x1 << 5)
#define I2CMSTA_BUSY                   (0x1 << 6)
#define I2CMSTA_NACKDATA               (0x1 << 7)
#define I2CMSTA_TCOMP                  (0x1 << 8)
#define I2CMSTA_RXOF                   (0x1 << 9)
#define I2CMSTA_LINEBUSY               (0x1 << 10)
#define I2CMSTA_MSTOP                  (0x1 << 11)
#define I2CMSTA_TXUR                   (0x1 << 12)

/* Transmit FIFO Status  */
#define I2CMSTA_TXFSTA_EMPTY           (0 << 0)
#define I2CMSTA_TXFSTA_ONEBYTE         (1 << 0)
#define I2CMSTA_TXFSTA_FULL            (3 << 0)
/* Reset Value for I2CMRX*/
#define I2CMRX_RVAL                    0x0 

/* Masks for bitfields in I2CMRX*/
#define I2CMRX_VALUE_MSK               (0xFF << 0)

/* Reset Value for I2CMTX*/
#define I2CMTX_RVAL                    0x0 

/* Masks for bitfields in I2CMTX*/
#define I2CMTX_VALUE_MSK               (0xFF << 0)

/* Reset Value for I2CMRXCNT*/
#define I2CMRXCNT_RVAL                 0x0 
#define I2CMRXCNT_EXTEND_BBA           (*(volatile unsigned long *) 0x42060220)

/* Masks for bitfields in I2CMRXCNT*/
#define I2CMRXCNT_COUNT_MSK            (0xFF << 0)
#define I2CMRXCNT_EXTEND               (0x1 << 8)

/* Reset Value for I2CMCRXCNT*/
#define I2CMCRXCNT_RVAL                0x0 

/* Masks for bitfields in I2CMCRXCNT*/
#define I2CMCRXCNT_VALUE_MSK           (0xFF << 0)

/* Reset Value for I2CADR0*/
#define I2CADR0_RVAL                   0x0 

/* Masks for bitfields in I2CADR0*/
#define I2CADR0_VALUE_MSK              (0xFF << 0)

/* Reset Value for I2CADR1*/
#define I2CADR1_RVAL                   0x0 

/* Masks for bitfields in I2CADR1*/
#define I2CADR1_VALUE_MSK              (0xFF << 0)

/* Reset Value for I2CDIV*/
#define I2CDIV_RVAL                    0x1F1F 

/* Masks for bitfields in I2CDIV*/
#define I2CDIV_LOW_MSK                 (0xFF << 0)
#define I2CDIV_HIGH_MSK                (0xFF << 8)

/* Reset Value for I2CSCON*/
#define I2CSCON_RVAL                   0x0 
#define I2CSCON_SLVEN_BBA              (*(volatile unsigned long *) 0x42060500)
#define I2CSCON_ADR10EN_BBA            (*(volatile unsigned long *) 0x42060504)
#define I2CSCON_GCEN_BBA               (*(volatile unsigned long *) 0x42060508)
#define I2CSCON_HGCEN_BBA              (*(volatile unsigned long *) 0x4206050C)
#define I2CSCON_GCSBCLR_BBA            (*(volatile unsigned long *) 0x42060510)
#define I2CSCON_EARLYTXR_BBA           (*(volatile unsigned long *) 0x42060514)
#define I2CSCON_STRETCH_BBA            (*(volatile unsigned long *) 0x42060518)
#define I2CSCON_NACK_BBA               (*(volatile unsigned long *) 0x4206051C)
#define I2CSCON_IENSTOP_BBA            (*(volatile unsigned long *) 0x42060520)
#define I2CSCON_IENRX_BBA              (*(volatile unsigned long *) 0x42060524)
#define I2CSCON_IENTX_BBA              (*(volatile unsigned long *) 0x42060528)
#define I2CSCON_XMITDEC_BBA            (*(volatile unsigned long *) 0x4206052C)
#define I2CSCON_IENREPST_BBA           (*(volatile unsigned long *) 0x42060530)
#define I2CSCON_RXDMA_BBA              (*(volatile unsigned long *) 0x42060534)
#define I2CSCON_TXDMA_BBA              (*(volatile unsigned long *) 0x42060538)

/* Masks for bitfields in I2CSCON*/
#define I2CSCON_SLVEN                  (0x1 << 0)
#define I2CSCON_ADR10EN                (0x1 << 1)
#define I2CSCON_GCEN                   (0x1 << 2)
#define I2CSCON_HGCEN                  (0x1 << 3)
#define I2CSCON_GCSBCLR                (0x1 << 4)
#define I2CSCON_EARLYTXR               (0x1 << 5)
#define I2CSCON_STRETCH                (0x1 << 6)
#define I2CSCON_NACK                   (0x1 << 7)
#define I2CSCON_IENSTOP                (0x1 << 8)
#define I2CSCON_IENRX                  (0x1 << 9)
#define I2CSCON_IENTX                  (0x1 << 10)
#define I2CSCON_XMITDEC                (0x1 << 11)
#define I2CSCON_IENREPST               (0x1 << 12)
#define I2CSCON_RXDMA                  (0x1 << 13)
#define I2CSCON_TXDMA                  (0x1 << 14)

/* General call status bit clear  */
#define I2CSCON_GCSBCLR_CLR            (1 << 4)
/* Reset Value for I2CSSTA*/
#define I2CSSTA_RVAL                   0x1 
#define I2CSSTA_TXFSEREQ_BBA           (*(volatile unsigned long *) 0x42060580)
#define I2CSSTA_TXUR_BBA               (*(volatile unsigned long *) 0x42060584)
#define I2CSSTA_TXREQ_BBA              (*(volatile unsigned long *) 0x42060588)
#define I2CSSTA_RXREQ_BBA              (*(volatile unsigned long *) 0x4206058C)
#define I2CSSTA_RXOF_BBA               (*(volatile unsigned long *) 0x42060590)
#define I2CSSTA_NOACK_BBA              (*(volatile unsigned long *) 0x42060594)
#define I2CSSTA_BUSY_BBA               (*(volatile unsigned long *) 0x42060598)
#define I2CSSTA_GCINT_BBA              (*(volatile unsigned long *) 0x4206059C)
#define I2CSSTA_STOP_BBA               (*(volatile unsigned long *) 0x420605A8)
#define I2CSSTA_REPSTART_BBA           (*(volatile unsigned long *) 0x420605B4)
#define I2CSSTA_START_BBA              (*(volatile unsigned long *) 0x420605B8)

/* Masks for bitfields in I2CSSTA*/
#define I2CSSTA_TXFSEREQ               (0x1 << 0)
#define I2CSSTA_TXUR                   (0x1 << 1)
#define I2CSSTA_TXREQ                  (0x1 << 2)
#define I2CSSTA_RXREQ                  (0x1 << 3)
#define I2CSSTA_RXOF                   (0x1 << 4)
#define I2CSSTA_NOACK                  (0x1 << 5)
#define I2CSSTA_BUSY                   (0x1 << 6)
#define I2CSSTA_GCINT                  (0x1 << 7)
#define I2CSSTA_GCID_MSK               (0x3 << 8)
#define I2CSSTA_STOP                   (0x1 << 10)
#define I2CSSTA_IDMAT_MSK              (0x3 << 11)
#define I2CSSTA_REPSTART               (0x1 << 13)
#define I2CSSTA_START                  (0x1 << 14)

/* Reset Value for I2CSRX*/
#define I2CSRX_RVAL                    0x0 

/* Masks for bitfields in I2CSRX*/
#define I2CSRX_VALUE_MSK               (0xFF << 0)

/* Reset Value for I2CSTX*/
#define I2CSTX_RVAL                    0x0 

/* Masks for bitfields in I2CSTX*/
#define I2CSTX_VALUE_MSK               (0xFF << 0)

/* Reset Value for I2CALT*/
#define I2CALT_RVAL                    0x0 

/* Masks for bitfields in I2CALT*/
#define I2CALT_VALUE_MSK               (0xFF << 0)

/* Reset Value for I2CID0*/
#define I2CID0_RVAL                    0x0 

/* Masks for bitfields in I2CID0*/
#define I2CID0_VALUE_MSK               (0xFF << 0)

/* Reset Value for I2CID1*/
#define I2CID1_RVAL                    0x0 

/* Masks for bitfields in I2CID1*/
#define I2CID1_VALUE_MSK               (0xFF << 0)

/* Reset Value for I2CID2*/
#define I2CID2_RVAL                    0x0 

/* Masks for bitfields in I2CID2*/
#define I2CID2_VALUE_MSK               (0xFF << 0)

/* Reset Value for I2CID3*/
#define I2CID3_RVAL                    0x0 

/* Masks for bitfields in I2CID3*/
#define I2CID3_VALUE_MSK               (0xFF << 0)

/* Reset Value for I2CFSTA*/
#define I2CFSTA_RVAL                   0x0 
#define I2CFSTA_SFLUSH_BBA             (*(volatile unsigned long *) 0x420609A0)
#define I2CFSTA_MFLUSH_BBA             (*(volatile unsigned long *) 0x420609A4)

/* Masks for bitfields in I2CFSTA*/
#define I2CFSTA_STXFSTA_MSK            (0x3 << 0)
#define I2CFSTA_SRXFSTA_MSK            (0x3 << 2)
#define I2CFSTA_MTXFSTA_MSK            (0x3 << 4)
#define I2CFSTA_MRXFSTA_MSK            (0x3 << 6)
#define I2CFSTA_SFLUSH                 (0x1 << 8)
#define I2CFSTA_MFLUSH                 (0x1 << 9)

/* Slave Transmit FIFO Status  */
#define I2CFSTA_STXFSTA_EMPTY          (0 << 0)
#define I2CFSTA_STXFSTA_ONEBYTE        (1 << 0)
#define I2CFSTA_STXFSTA_TWOBYTES       (2 << 0)
/* Slave receive FIFO Status  */
#define I2CFSTA_SRXFSTA_EMPTY          (0 << 2)
#define I2CFSTA_SRXFSTA_ONEBYTE        (1 << 2)
#define I2CFSTA_SRXFSTA_TWOBYTES       (2 << 2)
/* Master Transmit FIFO Status  */
#define I2CFSTA_MTXFSTA_EMPTY          (0 << 4)
#define I2CFSTA_MTXFSTA_ONEBYTE        (1 << 4)
#define I2CFSTA_MTXFSTA_TWOBYTES       (2 << 4)
/* Master receive FIFO Status  */
#define I2CFSTA_MRXFSTA_EMPTY          (0 << 6)
#define I2CFSTA_MRXFSTA_ONEBYTE        (1 << 6)
#define I2CFSTA_MRXFSTA_TWOBYTES       (2 << 6)

/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* SPI Status Register                                */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Masks for bitfields in SPISTA*/
#define SPISTA_IRQ                     (0x1 << 0)
#define SPISTA_TXFSTA_MSK              (0x7 << 1)
#define SPISTA_TXUR                    (0x1 << 4)
#define SPISTA_TX                      (0x1 << 5)
#define SPISTA_RX                      (0x1 << 6)
#define SPISTA_RXOF                    (0x1 << 7)
#define SPISTA_RXFSTA_MSK              (0x7 << 8)
#define SPISTA_RXS                     (0x1 << 11)
#define SPISTA_CSERR                   (0x1 << 12)

/* transmit FIFO Status  */
#define SPISTA_TXFSTA_EMPTY            (0 << 1)
#define SPISTA_TXFSTA_ONEBYTE          (1 << 1)
#define SPISTA_TXFSTA_TWOBYTES         (2 << 1)
#define SPISTA_TXFSTA_THREEBYTES       (3 << 1)
#define SPISTA_TXFSTA_FOURBYTES        (4 << 1)
/* Receive FIFO Status  */
#define SPISTA_RXFSTA_EMPTY            (0 << 8)
#define SPISTA_RXFSTA_ONEBYTE          (1 << 8)
#define SPISTA_RXFSTA_TWOBYTES         (2 << 8)
#define SPISTA_RXFSTA_THREEBYTES       (3 << 8)
#define SPISTA_RXFSTA_FOURBYTES        (4 << 8)
/* Masks for bitfields in SPICON*/
#define SPICON_ENABLE                  (0x1 << 0)
#define SPICON_MASEN                   (0x1 << 1)
#define SPICON_CPHA                    (0x1 << 2)
#define SPICON_CPOL                    (0x1 << 3)
#define SPICON_WOM                     (0x1 << 4)
#define SPICON_LSB                     (0x1 << 5)
#define SPICON_TIM                     (0x1 << 6)
#define SPICON_ZEN                     (0x1 << 7)
#define SPICON_RXOF                    (0x1 << 8)
#define SPICON_OEN                     (0x1 << 9)
#define SPICON_LOOPBACK                (0x1 << 10)
#define SPICON_CON                     (0x1 << 11)
#define SPICON_RFLUSH                  (0x1 << 12)
#define SPICON_TFLUSH                  (0x1 << 13)
#define SPICON_MOD_MSK                 (0x3 << 14)

/* Clock phase mode  */
#define SPICON_CPHA_SAMPLELEADING      (0 << 2)
#define SPICON_CPHA_SAMPLETRAILING     (1 << 2)
/* Clock polarity mode  */
#define SPICON_CPOL_LOW                (0 << 3)
#define SPICON_CPOL_HIGH               (1 << 3)
/* Transfer and interrupt mode  */
#define SPICON_TIM_TXWR                (1 << 6) /* Set by user to initiate transfer with a write to the SPITX register. */
#define SPICON_TIM_RXRD                (0 << 6) /* Cleared by user to initiate transfer with a read of the SPIRX register */
/* SPI IRQ Mode bits */
#define SPICON_MOD_TX1RX1              (0 << 14)
#define SPICON_MOD_TX2RX1              (1 << 14)
#define SPICON_MOD_TX3RX3              (2 << 14)
#define SPICON_MOD_TX4RX4              (3 << 14)
/* Masks for bitfields in SPIDIV*/
#define SPIDIV_DIV_MSK                 (0x3F << 0)
#define SPIDIV_BCRST                   (0x1 << 7)


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* SPI 0                                              Base Address 0x40004000 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for SPI0STA*/
#define SPI0STA_RVAL                   0x0 
#define SPI0STA_IRQ_BBA                (*(volatile unsigned long *) 0x42080000)
#define SPI0STA_TXUR_BBA               (*(volatile unsigned long *) 0x42080010)
#define SPI0STA_TX_BBA                 (*(volatile unsigned long *) 0x42080014)
#define SPI0STA_RX_BBA                 (*(volatile unsigned long *) 0x42080018)
#define SPI0STA_RXOF_BBA               (*(volatile unsigned long *) 0x4208001C)
#define SPI0STA_RXS_BBA                (*(volatile unsigned long *) 0x4208002C)
#define SPI0STA_CSERR_BBA              (*(volatile unsigned long *) 0x42080030)

/* Masks for bitfields in SPI0STA*/
#define SPI0STA_IRQ                    SPISTA_IRQ
#define SPI0STA_TXFSTA_MSK             SPISTA_TXFSTA_MSK
#define SPI0STA_TXUR                   SPISTA_TXUR
#define SPI0STA_TX                     SPISTA_TX
#define SPI0STA_RX                     SPISTA_RX
#define SPI0STA_RXOF                   SPISTA_RXOF
#define SPI0STA_RXFSTA_MSK             SPISTA_RXFSTA_MSK
#define SPI0STA_RXS                    SPISTA_RXS
#define SPI0STA_CSERR                  SPISTA_CSERR

/* transmit FIFO Status  */
#define SPI0STA_TXFSTA_EMPTY           SPISTA_TXFSTA_EMPTY
#define SPI0STA_TXFSTA_ONEBYTE         SPISTA_TXFSTA_ONEBYTE
#define SPI0STA_TXFSTA_TWOBYTES        SPISTA_TXFSTA_TWOBYTES
#define SPI0STA_TXFSTA_THREEBYTES      SPISTA_TXFSTA_THREEBYTES
#define SPI0STA_TXFSTA_FOURBYTES       SPISTA_TXFSTA_FOURBYTES
/* Receive FIFO Status  */
#define SPI0STA_RXFSTA_EMPTY           SPISTA_RXFSTA_EMPTY
#define SPI0STA_RXFSTA_ONEBYTE         SPISTA_RXFSTA_ONEBYTE
#define SPI0STA_RXFSTA_TWOBYTES        SPISTA_RXFSTA_TWOBYTES
#define SPI0STA_RXFSTA_THREEBYTES      SPISTA_RXFSTA_THREEBYTES
#define SPI0STA_RXFSTA_FOURBYTES       SPISTA_RXFSTA_FOURBYTES
/* Reset Value for SPI0RX*/
#define SPI0RX_RVAL                    0x0 

/* Masks for bitfields in SPI0RX*/
#define SPI0RX_VALUE_MSK               (0xFF << 0)

/* Reset Value for SPI0TX*/
#define SPI0TX_RVAL                    0x0 

/* Masks for bitfields in SPI0TX*/
#define SPI0TX_VALUE_MSK               (0xFF << 0)

/* Reset Value for SPI0DIV*/
#define SPI0DIV_RVAL                   0x0 
#define SPI0DIV_BCRST_BBA              (*(volatile unsigned long *) 0x4208019C)

/* Masks for bitfields in SPI0DIV*/
#define SPI0DIV_DIV_MSK                SPIDIV_DIV_MSK
#define SPI0DIV_BCRST                  SPIDIV_BCRST

/* Reset Value for SPI0CON*/
#define SPI0CON_RVAL                   0x0 
#define SPI0CON_ENABLE_BBA             (*(volatile unsigned long *) 0x42080200)
#define SPI0CON_MASEN_BBA              (*(volatile unsigned long *) 0x42080204)
#define SPI0CON_CPHA_BBA               (*(volatile unsigned long *) 0x42080208)
#define SPI0CON_CPOL_BBA               (*(volatile unsigned long *) 0x4208020C)
#define SPI0CON_WOM_BBA                (*(volatile unsigned long *) 0x42080210)
#define SPI0CON_LSB_BBA                (*(volatile unsigned long *) 0x42080214)
#define SPI0CON_TIM_BBA                (*(volatile unsigned long *) 0x42080218)
#define SPI0CON_ZEN_BBA                (*(volatile unsigned long *) 0x4208021C)
#define SPI0CON_RXOF_BBA               (*(volatile unsigned long *) 0x42080220)
#define SPI0CON_OEN_BBA                (*(volatile unsigned long *) 0x42080224)
#define SPI0CON_LOOPBACK_BBA           (*(volatile unsigned long *) 0x42080228)
#define SPI0CON_CON_BBA                (*(volatile unsigned long *) 0x4208022C)
#define SPI0CON_RFLUSH_BBA             (*(volatile unsigned long *) 0x42080230)
#define SPI0CON_TFLUSH_BBA             (*(volatile unsigned long *) 0x42080234)

/* Masks for bitfields in SPI0CON*/
#define SPI0CON_ENABLE                 SPICON_ENABLE
#define SPI0CON_MASEN                  SPICON_MASEN
#define SPI0CON_CPHA                   SPICON_CPHA
#define SPI0CON_CPOL                   SPICON_CPOL
#define SPI0CON_WOM                    SPICON_WOM
#define SPI0CON_LSB                    SPICON_LSB
#define SPI0CON_TIM                    SPICON_TIM
#define SPI0CON_ZEN                    SPICON_ZEN
#define SPI0CON_RXOF                   SPICON_RXOF
#define SPI0CON_OEN                    SPICON_OEN
#define SPI0CON_LOOPBACK               SPICON_LOOPBACK
#define SPI0CON_CON                    SPICON_CON
#define SPI0CON_RFLUSH                 SPICON_RFLUSH
#define SPI0CON_TFLUSH                 SPICON_TFLUSH
#define SPI0CON_MOD_MSK                SPICON_MOD_MSK

/* Clock phase mode  */
#define SPI0CON_CPHA_SAMPLELEADING     SPICON_CPHA_SAMPLELEADING
#define SPI0CON_CPHA_SAMPLETRAILING    SPICON_CPHA_SAMPLETRAILING
/* Clock polarity mode  */
#define SPI0CON_CPOL_LOW               SPICON_CPOL_LOW
#define SPI0CON_CPOL_HIGH              SPICON_CPOL_HIGH
/* Transfer and interrupt mode  */
#define SPI0CON_TIM_TXWR               SPICON_TIM_TXWR /* Set by user to initiate transfer with a write to the SPITX register. */
#define SPI0CON_TIM_RXRD               SPICON_TIM_RXRD /* Cleared by user to initiate transfer with a read of the SPIRX register */
/* SPI IRQ Mode bits */
#define SPI0CON_MOD_TX1RX1             SPICON_MOD_TX1RX1
#define SPI0CON_MOD_TX2RX1             SPICON_MOD_TX2RX1
#define SPI0CON_MOD_TX3RX3             SPICON_MOD_TX3RX3
#define SPI0CON_MOD_TX4RX4             SPICON_MOD_TX4RX4
/* Reset Value for SPI0DMA*/
#define SPI0DMA_RVAL                   0x0 
#define SPI0DMA_ENABLE_BBA             (*(volatile unsigned long *) 0x42080280)
#define SPI0DMA_IENTXDMA_BBA           (*(volatile unsigned long *) 0x42080284)
#define SPI0DMA_IENRXDMA_BBA           (*(volatile unsigned long *) 0x42080288)

/* Masks for bitfields in SPI0DMA*/
#define SPI0DMA_ENABLE                 (0x1 << 0)
#define SPI0DMA_IENTXDMA               (0x1 << 1)
#define SPI0DMA_IENRXDMA               (0x1 << 2)

/* Reset Value for SPI0CNT*/
#define SPI0CNT_RVAL                   0x0 

/* Masks for bitfields in SPI0CNT*/
#define SPI0CNT_VALUE_MSK              (0xFF << 0)


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* SPI 1                                              Base Address 0x40004400 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for SPI1STA*/
#define SPI1STA_RVAL                   0x0 
#define SPI1STA_IRQ_BBA                (*(volatile unsigned long *) 0x42088000)
#define SPI1STA_TXUR_BBA               (*(volatile unsigned long *) 0x42088010)
#define SPI1STA_TX_BBA                 (*(volatile unsigned long *) 0x42088014)
#define SPI1STA_RX_BBA                 (*(volatile unsigned long *) 0x42088018)
#define SPI1STA_RXOF_BBA               (*(volatile unsigned long *) 0x4208801C)
#define SPI1STA_RXS_BBA                (*(volatile unsigned long *) 0x4208802C)
#define SPI1STA_CSERR_BBA              (*(volatile unsigned long *) 0x42088030)

/* Masks for bitfields in SPI1STA*/
#define SPI1STA_IRQ                    SPISTA_IRQ
#define SPI1STA_TXFSTA_MSK             SPISTA_TXFSTA_MSK
#define SPI1STA_TXUR                   SPISTA_TXUR
#define SPI1STA_TX                     SPISTA_TX
#define SPI1STA_RX                     SPISTA_RX
#define SPI1STA_RXOF                   SPISTA_RXOF
#define SPI1STA_RXFSTA_MSK             SPISTA_RXFSTA_MSK
#define SPI1STA_RXS                    SPISTA_RXS
#define SPI1STA_CSERR                  SPISTA_CSERR

/* transmit FIFO Status  */
#define SPI1STA_TXFSTA_EMPTY           SPISTA_TXFSTA_EMPTY
#define SPI1STA_TXFSTA_ONEBYTE         SPISTA_TXFSTA_ONEBYTE
#define SPI1STA_TXFSTA_TWOBYTES        SPISTA_TXFSTA_TWOBYTES
#define SPI1STA_TXFSTA_THREEBYTES      SPISTA_TXFSTA_THREEBYTES
#define SPI1STA_TXFSTA_FOURBYTES       SPISTA_TXFSTA_FOURBYTES
/* Receive FIFO Status  */
#define SPI1STA_RXFSTA_EMPTY           SPISTA_RXFSTA_EMPTY
#define SPI1STA_RXFSTA_ONEBYTE         SPISTA_RXFSTA_ONEBYTE
#define SPI1STA_RXFSTA_TWOBYTES        SPISTA_RXFSTA_TWOBYTES
#define SPI1STA_RXFSTA_THREEBYTES      SPISTA_RXFSTA_THREEBYTES
#define SPI1STA_RXFSTA_FOURBYTES       SPISTA_RXFSTA_FOURBYTES
/* Reset Value for SPI1RX*/
#define SPI1RX_RVAL                    0x0 

/* Masks for bitfields in SPI1RX*/
#define SPI1RX_VALUE_MSK               (0xFF << 0)

/* Reset Value for SPI1TX*/
#define SPI1TX_RVAL                    0x0 

/* Masks for bitfields in SPI1TX*/
#define SPI1TX_VALUE_MSK               (0xFF << 0)

/* Reset Value for SPI1DIV*/
#define SPI1DIV_RVAL                   0x0 
#define SPI1DIV_BCRST_BBA              (*(volatile unsigned long *) 0x4208819C)

/* Masks for bitfields in SPI1DIV*/
#define SPI1DIV_DIV_MSK                SPIDIV_DIV_MSK
#define SPI1DIV_BCRST                  SPIDIV_BCRST

/* Reset Value for SPI1CON*/
#define SPI1CON_RVAL                   0x0 
#define SPI1CON_ENABLE_BBA             (*(volatile unsigned long *) 0x42088200)
#define SPI1CON_MASEN_BBA              (*(volatile unsigned long *) 0x42088204)
#define SPI1CON_CPHA_BBA               (*(volatile unsigned long *) 0x42088208)
#define SPI1CON_CPOL_BBA               (*(volatile unsigned long *) 0x4208820C)
#define SPI1CON_WOM_BBA                (*(volatile unsigned long *) 0x42088210)
#define SPI1CON_LSB_BBA                (*(volatile unsigned long *) 0x42088214)
#define SPI1CON_TIM_BBA                (*(volatile unsigned long *) 0x42088218)
#define SPI1CON_ZEN_BBA                (*(volatile unsigned long *) 0x4208821C)
#define SPI1CON_RXOF_BBA               (*(volatile unsigned long *) 0x42088220)
#define SPI1CON_OEN_BBA                (*(volatile unsigned long *) 0x42088224)
#define SPI1CON_LOOPBACK_BBA           (*(volatile unsigned long *) 0x42088228)
#define SPI1CON_CON_BBA                (*(volatile unsigned long *) 0x4208822C)
#define SPI1CON_RFLUSH_BBA             (*(volatile unsigned long *) 0x42088230)
#define SPI1CON_TFLUSH_BBA             (*(volatile unsigned long *) 0x42088234)

/* Masks for bitfields in SPI1CON*/
#define SPI1CON_ENABLE                 SPICON_ENABLE
#define SPI1CON_MASEN                  SPICON_MASEN
#define SPI1CON_CPHA                   SPICON_CPHA
#define SPI1CON_CPOL                   SPICON_CPOL
#define SPI1CON_WOM                    SPICON_WOM
#define SPI1CON_LSB                    SPICON_LSB
#define SPI1CON_TIM                    SPICON_TIM
#define SPI1CON_ZEN                    SPICON_ZEN
#define SPI1CON_RXOF                   SPICON_RXOF
#define SPI1CON_OEN                    SPICON_OEN
#define SPI1CON_LOOPBACK               SPICON_LOOPBACK
#define SPI1CON_CON                    SPICON_CON
#define SPI1CON_RFLUSH                 SPICON_RFLUSH
#define SPI1CON_TFLUSH                 SPICON_TFLUSH
#define SPI1CON_MOD_MSK                SPICON_MOD_MSK

/* Clock phase mode  */
#define SPI1CON_CPHA_SAMPLELEADING     SPICON_CPHA_SAMPLELEADING
#define SPI1CON_CPHA_SAMPLETRAILING    SPICON_CPHA_SAMPLETRAILING
/* Clock polarity mode  */
#define SPI1CON_CPOL_LOW               SPICON_CPOL_LOW
#define SPI1CON_CPOL_HIGH              SPICON_CPOL_HIGH
/* Transfer and interrupt mode  */
#define SPI1CON_TIM_TXWR               SPICON_TIM_TXWR /* Set by user to initiate transfer with a write to the SPITX register. */
#define SPI1CON_TIM_RXRD               SPICON_TIM_RXRD /* Cleared by user to initiate transfer with a read of the SPIRX register */
/* SPI IRQ Mode bits */
#define SPI1CON_MOD_TX1RX1             SPICON_MOD_TX1RX1
#define SPI1CON_MOD_TX2RX1             SPICON_MOD_TX2RX1
#define SPI1CON_MOD_TX3RX3             SPICON_MOD_TX3RX3
#define SPI1CON_MOD_TX4RX4             SPICON_MOD_TX4RX4
/* Reset Value for SPI1DMA*/
#define SPI1DMA_RVAL                   0x0 
#define SPI1DMA_ENABLE_BBA             (*(volatile unsigned long *) 0x42088280)
#define SPI1DMA_IENTXDMA_BBA           (*(volatile unsigned long *) 0x42088284)
#define SPI1DMA_IENRXDMA_BBA           (*(volatile unsigned long *) 0x42088288)

/* Masks for bitfields in SPI1DMA*/
#define SPI1DMA_ENABLE                 (0x1 << 0)
#define SPI1DMA_IENTXDMA               (0x1 << 1)
#define SPI1DMA_IENRXDMA               (0x1 << 2)

/* Reset Value for SPI1CNT*/
#define SPI1CNT_RVAL                   0x0 

/* Masks for bitfields in SPI1CNT*/
#define SPI1CNT_VALUE_MSK              (0xFF << 0)


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* UART                                               Base Address 0x40005000 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for COMTX*/
#define COMTX_RVAL                     0x0 

/* Masks for bitfields in COMTX*/
#define COMTX_VALUE_MSK                (0xFF << 0)

/* Reset Value for COMRX*/
#define COMRX_RVAL                     0x0 

/* Masks for bitfields in COMRX*/
#define COMRX_VALUE_MSK                (0xFF << 0)

/* Reset Value for COMIEN*/
#define COMIEN_RVAL                    0x0 
#define COMIEN_ERBFI_BBA               (*(volatile unsigned long *) 0x420A0080)
#define COMIEN_ETBEI_BBA               (*(volatile unsigned long *) 0x420A0084)
#define COMIEN_ELSI_BBA                (*(volatile unsigned long *) 0x420A0088)
#define COMIEN_EDSSI_BBA               (*(volatile unsigned long *) 0x420A008C)
#define COMIEN_EDMAT_BBA               (*(volatile unsigned long *) 0x420A0090)
#define COMIEN_EDMAR_BBA               (*(volatile unsigned long *) 0x420A0094)

/* Masks for bitfields in COMIEN*/
#define COMIEN_ERBFI                   (0x1 << 0)
#define COMIEN_ETBEI                   (0x1 << 1)
#define COMIEN_ELSI                    (0x1 << 2)
#define COMIEN_EDSSI                   (0x1 << 3)
#define COMIEN_EDMAT                   (0x1 << 4)
#define COMIEN_EDMAR                   (0x1 << 5)

/* Reset Value for COMIIR*/
#define COMIIR_RVAL                    0x1 
#define COMIIR_NINT_BBA                (*(volatile unsigned long *) 0x420A0100)

/* Masks for bitfields in COMIIR*/
#define COMIIR_NINT                    (0x1 << 0)
#define COMIIR_STA_MSK                 (0x3 << 1)

/* Status bits.  */
#define COMIIR_STA_MODEMSTATUS         (0 << 1) /* Modem status interrupt.  */
#define COMIIR_STA_TXBUFEMPTY          (1 << 1) /* Transmit buffer empty interrupt. */
#define COMIIR_STA_RXBUFFULL           (2 << 1) /* Receive buffer full interrupt. Read RBR register to clear. */
#define COMIIR_STA_RXLINESTATUS        (3 << 1) /* Receive line status interrupt. Read LSR register to clear. */
/* Reset Value for COMLCR*/
#define COMLCR_RVAL                    0x0 
#define COMLCR_STOP_BBA                (*(volatile unsigned long *) 0x420A0188)
#define COMLCR_PEN_BBA                 (*(volatile unsigned long *) 0x420A018C)
#define COMLCR_EPS_BBA                 (*(volatile unsigned long *) 0x420A0190)
#define COMLCR_SP_BBA                  (*(volatile unsigned long *) 0x420A0194)
#define COMLCR_BRK_BBA                 (*(volatile unsigned long *) 0x420A0198)

/* Masks for bitfields in COMLCR*/
#define COMLCR_WLS_MSK                 (0x3 << 0)
#define COMLCR_STOP                    (0x1 << 2)
#define COMLCR_PEN                     (0x1 << 3)
#define COMLCR_EPS                     (0x1 << 4)
#define COMLCR_SP                      (0x1 << 5)
#define COMLCR_BRK                     (0x1 << 6)

/* Word Length Select bits  */
#define COMLCR_WLS_5BITS               (0 << 0)
#define COMLCR_WLS_6BITS               (1 << 0)
#define COMLCR_WLS_7BITS               (2 << 0)
#define COMLCR_WLS_8BITS               (3 << 0)
/* Set Break.  */
#define COMLCR_BRK_CLR                 (0 << 6)
#define COMLCR_BRK_SET                 (1 << 6)
/* Reset Value for COMMCR*/
#define COMMCR_RVAL                    0x0 
#define COMMCR_DTR_BBA                 (*(volatile unsigned long *) 0x420A0200)
#define COMMCR_RTS_BBA                 (*(volatile unsigned long *) 0x420A0204)
#define COMMCR_OUT2_BBA                (*(volatile unsigned long *) 0x420A0208)
#define COMMCR_OUT1_BBA                (*(volatile unsigned long *) 0x420A020C)
#define COMMCR_LOOPBACK_BBA            (*(volatile unsigned long *) 0x420A0210)

/* Masks for bitfields in COMMCR*/
#define COMMCR_DTR                     (0x1 << 0)
#define COMMCR_RTS                     (0x1 << 1)
#define COMMCR_OUT2                    (0x1 << 2)
#define COMMCR_OUT1                    (0x1 << 3)
#define COMMCR_LOOPBACK                (0x1 << 4)

/* Reset Value for COMLSR*/
#define COMLSR_RVAL                    0x60 
#define COMLSR_DR_BBA                  (*(volatile unsigned long *) 0x420A0280)
#define COMLSR_OE_BBA                  (*(volatile unsigned long *) 0x420A0284)
#define COMLSR_PE_BBA                  (*(volatile unsigned long *) 0x420A0288)
#define COMLSR_FE_BBA                  (*(volatile unsigned long *) 0x420A028C)
#define COMLSR_BI_BBA                  (*(volatile unsigned long *) 0x420A0290)
#define COMLSR_THRE_BBA                (*(volatile unsigned long *) 0x420A0294)
#define COMLSR_TEMT_BBA                (*(volatile unsigned long *) 0x420A0298)

/* Masks for bitfields in COMLSR*/
#define COMLSR_DR                      (0x1 << 0)
#define COMLSR_OE                      (0x1 << 1)
#define COMLSR_PE                      (0x1 << 2)
#define COMLSR_FE                      (0x1 << 3)
#define COMLSR_BI                      (0x1 << 4)
#define COMLSR_THRE                    (0x1 << 5)
#define COMLSR_TEMT                    (0x1 << 6)

/* Reset Value for COMMSR*/
#define COMMSR_RVAL                    0x0 
#define COMMSR_DCTS_BBA                (*(volatile unsigned long *) 0x420A0300)
#define COMMSR_DDSR_BBA                (*(volatile unsigned long *) 0x420A0304)
#define COMMSR_TERI_BBA                (*(volatile unsigned long *) 0x420A0308)
#define COMMSR_DDCD_BBA                (*(volatile unsigned long *) 0x420A030C)
#define COMMSR_CTS_BBA                 (*(volatile unsigned long *) 0x420A0310)
#define COMMSR_DSR_BBA                 (*(volatile unsigned long *) 0x420A0314)
#define COMMSR_RI_BBA                  (*(volatile unsigned long *) 0x420A0318)
#define COMMSR_DCD_BBA                 (*(volatile unsigned long *) 0x420A031C)

/* Masks for bitfields in COMMSR*/
#define COMMSR_DCTS                    (0x1 << 0)
#define COMMSR_DDSR                    (0x1 << 1)
#define COMMSR_TERI                    (0x1 << 2)
#define COMMSR_DDCD                    (0x1 << 3)
#define COMMSR_CTS                     (0x1 << 4)
#define COMMSR_DSR                     (0x1 << 5)
#define COMMSR_RI                      (0x1 << 6)
#define COMMSR_DCD                     (0x1 << 7)

/* Reset Value for COMFBR*/
#define COMFBR_RVAL                    0x0 
#define COMFBR_ENABLE_BBA              (*(volatile unsigned long *) 0x420A04BC)

/* Masks for bitfields in COMFBR*/
#define COMFBR_DIVN_MSK                (0x7FF << 0)
#define COMFBR_DIVM_MSK                (0x3 << 11)
#define COMFBR_ENABLE                  (0x1 << 15)

/* Reset Value for COMDIV*/
#define COMDIV_RVAL                    0x1 

/* Masks for bitfields in COMDIV*/
#define COMDIV_VALUE_MSK               (0xFFFF << 0)

/* Reset Value for COMCON*/
#define COMCON_RVAL                    0x0 
#define COMCON_DISABLE_BBA             (*(volatile unsigned long *) 0x420A0600)

/* Masks for bitfields in COMCON*/
#define COMCON_DISABLE                 (0x1 << 0)

/* Masks for bitfields in GPOEN*/
#define GPOEN_OEN0                     (0x1 << 0)
#define GPOEN_OEN1                     (0x1 << 1)
#define GPOEN_OEN2                     (0x1 << 2)
#define GPOEN_OEN3                     (0x1 << 3)
#define GPOEN_OEN4                     (0x1 << 4)
#define GPOEN_OEN5                     (0x1 << 5)
#define GPOEN_OEN6                     (0x1 << 6)
#define GPOEN_OEN7                     (0x1 << 7)

/* Direction for port pin  */
#define GPOEN_OEN0_IN                  (0 << 0)
#define GPOEN_OEN0_OUT                 (1 << 0)
/* Direction for port pin  */
#define GPOEN_OEN1_IN                  (0 << 1)
#define GPOEN_OEN1_OUT                 (1 << 1)
/* Direction for port pin  */
#define GPOEN_OEN2_IN                  (0 << 2)
#define GPOEN_OEN2_OUT                 (1 << 2)
/* Direction for port pin  */
#define GPOEN_OEN3_IN                  (0 << 3)
#define GPOEN_OEN3_OUT                 (1 << 3)
/* Direction for port pin  */
#define GPOEN_OEN4_IN                  (0 << 4)
#define GPOEN_OEN4_OUT                 (1 << 4)
/* Direction for port pin  */
#define GPOEN_OEN5_IN                  (0 << 5)
#define GPOEN_OEN5_OUT                 (1 << 5)
/* Direction for port pin  */
#define GPOEN_OEN6_IN                  (0 << 6)
#define GPOEN_OEN6_OUT                 (1 << 6)
/* Direction for port pin  */
#define GPOEN_OEN7_IN                  (0 << 7)
#define GPOEN_OEN7_OUT                 (1 << 7)
/* Masks for bitfields in GPPUL*/
#define GPPUL_PUL0                     (0x1 << 0)
#define GPPUL_PUL1                     (0x1 << 1)
#define GPPUL_PUL2                     (0x1 << 2)
#define GPPUL_PUL3                     (0x1 << 3)
#define GPPUL_PUL4                     (0x1 << 4)
#define GPPUL_PUL5                     (0x1 << 5)
#define GPPUL_PUL6                     (0x1 << 6)
#define GPPUL_PUL7                     (0x1 << 7)

/* Masks for bitfields in GPOCE*/
#define GPOCE_OCE0                     (0x1 << 0)
#define GPOCE_OCE1                     (0x1 << 1)
#define GPOCE_OCE2                     (0x1 << 2)
#define GPOCE_OCE3                     (0x1 << 3)
#define GPOCE_OCE4                     (0x1 << 4)
#define GPOCE_OCE5                     (0x1 << 5)
#define GPOCE_OCE6                     (0x1 << 6)
#define GPOCE_OCE7                     (0x1 << 7)

/* Masks for bitfields in GPIN*/
#define GPIN_IN0                       (0x1 << 0)
#define GPIN_IN1                       (0x1 << 1)
#define GPIN_IN2                       (0x1 << 2)
#define GPIN_IN3                       (0x1 << 3)
#define GPIN_IN4                       (0x1 << 4)
#define GPIN_IN5                       (0x1 << 5)
#define GPIN_IN6                       (0x1 << 6)
#define GPIN_IN7                       (0x1 << 7)

/* Input for port pin  */
#define GPIN_IN0_LOW                   (0 << 0)
#define GPIN_IN0_HIGH                  (1 << 0)
/* Input for port pin  */
#define GPIN_IN1_LOW                   (0 << 1)
#define GPIN_IN1_HIGH                  (1 << 1)
/* Input for port pin  */
#define GPIN_IN2_LOW                   (0 << 2)
#define GPIN_IN2_HIGH                  (1 << 2)
/* Input for port pin  */
#define GPIN_IN3_LOW                   (0 << 3)
#define GPIN_IN3_HIGH                  (1 << 3)
/* Input for port pin  */
#define GPIN_IN4_LOW                   (0 << 4)
#define GPIN_IN4_HIGH                  (1 << 4)
/* Input for port pin  */
#define GPIN_IN5_LOW                   (0 << 5)
#define GPIN_IN5_HIGH                  (1 << 5)
/* Input for port pin  */
#define GPIN_IN6_LOW                   (0 << 6)
#define GPIN_IN6_HIGH                  (1 << 6)
/* Input for port pin  */
#define GPIN_IN7_LOW                   (0 << 7)
#define GPIN_IN7_HIGH                  (1 << 7)
/* Masks for bitfields in GPOUT*/
#define GPOUT_OUT0                     (0x1 << 0)
#define GPOUT_OUT1                     (0x1 << 1)
#define GPOUT_OUT2                     (0x1 << 2)
#define GPOUT_OUT3                     (0x1 << 3)
#define GPOUT_OUT4                     (0x1 << 4)
#define GPOUT_OUT5                     (0x1 << 5)
#define GPOUT_OUT6                     (0x1 << 6)
#define GPOUT_OUT7                     (0x1 << 7)

/* Output for port pin  */
#define GPOUT_OUT0_LOW                 (0 << 0)
#define GPOUT_OUT0_HIGH                (1 << 0)
/* Output for port pin  */
#define GPOUT_OUT1_LOW                 (0 << 1)
#define GPOUT_OUT1_HIGH                (1 << 1)
/* Output for port pin  */
#define GPOUT_OUT2_LOW                 (0 << 2)
#define GPOUT_OUT2_HIGH                (1 << 2)
/* Output for port pin  */
#define GPOUT_OUT3_LOW                 (0 << 3)
#define GPOUT_OUT3_HIGH                (1 << 3)
/* Output for port pin  */
#define GPOUT_OUT4_LOW                 (0 << 4)
#define GPOUT_OUT4_HIGH                (1 << 4)
/* Output for port pin  */
#define GPOUT_OUT5_LOW                 (0 << 5)
#define GPOUT_OUT5_HIGH                (1 << 5)
/* Output for port pin  */
#define GPOUT_OUT6_LOW                 (0 << 6)
#define GPOUT_OUT6_HIGH                (1 << 6)
/* Output for port pin  */
#define GPOUT_OUT7_LOW                 (0 << 7)
#define GPOUT_OUT7_HIGH                (1 << 7)
/* Masks for bitfields in GPSET*/
#define GPSET_SET0                     (0x1 << 0)
#define GPSET_SET1                     (0x1 << 1)
#define GPSET_SET2                     (0x1 << 2)
#define GPSET_SET3                     (0x1 << 3)
#define GPSET_SET4                     (0x1 << 4)
#define GPSET_SET5                     (0x1 << 5)
#define GPSET_SET6                     (0x1 << 6)
#define GPSET_SET7                     (0x1 << 7)

/* Set Output High for port pin  */
#define GPSET_SET0_SET                 (1 << 0)
/* Set Output High for port pin  */
#define GPSET_SET1_SET                 (1 << 1)
/* Set Output High for port pin  */
#define GPSET_SET2_SET                 (1 << 2)
/* Set Output High for port pin  */
#define GPSET_SET3_SET                 (1 << 3)
/* Set Output High for port pin  */
#define GPSET_SET4_SET                 (1 << 4)
/* Set Output High for port pin  */
#define GPSET_SET5_SET                 (1 << 5)
/* Set Output High for port pin  */
#define GPSET_SET6_SET                 (1 << 6)
/* Set Output High for port pin  */
#define GPSET_SET7_SET                 (1 << 7)
/* Masks for bitfields in GPCLR*/
#define GPCLR_CLR0                     (0x1 << 0)
#define GPCLR_CLR1                     (0x1 << 1)
#define GPCLR_CLR2                     (0x1 << 2)
#define GPCLR_CLR3                     (0x1 << 3)
#define GPCLR_CLR4                     (0x1 << 4)
#define GPCLR_CLR5                     (0x1 << 5)
#define GPCLR_CLR6                     (0x1 << 6)
#define GPCLR_CLR7                     (0x1 << 7)

/* Set Output Low for port pin  */
#define GPCLR_CLR0_CLR                 (1 << 0)
/* Set Output Low for port pin  */
#define GPCLR_CLR1_CLR                 (1 << 1)
/* Set Output Low for port pin  */
#define GPCLR_CLR2_CLR                 (1 << 2)
/* Set Output Low for port pin  */
#define GPCLR_CLR3_CLR                 (1 << 3)
/* Set Output Low for port pin  */
#define GPCLR_CLR4_CLR                 (1 << 4)
/* Set Output Low for port pin  */
#define GPCLR_CLR5_CLR                 (1 << 5)
/* Set Output Low for port pin  */
#define GPCLR_CLR6_CLR                 (1 << 6)
/* Set Output Low for port pin  */
#define GPCLR_CLR7_CLR                 (1 << 7)
/* Masks for bitfields in GPTGL*/
#define GPTGL_TGL0                     (0x1 << 0)
#define GPTGL_TGL1                     (0x1 << 1)
#define GPTGL_TGL2                     (0x1 << 2)
#define GPTGL_TGL3                     (0x1 << 3)
#define GPTGL_TGL4                     (0x1 << 4)
#define GPTGL_TGL5                     (0x1 << 5)
#define GPTGL_TGL6                     (0x1 << 6)
#define GPTGL_TGL7                     (0x1 << 7)

/* Toggle Output for port pin  */
#define GPTGL_TGL0_TGL                 (1 << 0)
/* Toggle Output for port pin  */
#define GPTGL_TGL1_TGL                 (1 << 1)
/* Toggle Output for port pin  */
#define GPTGL_TGL2_TGL                 (1 << 2)
/* Toggle Output for port pin  */
#define GPTGL_TGL3_TGL                 (1 << 3)
/* Toggle Output for port pin  */
#define GPTGL_TGL4_TGL                 (1 << 4)
/* Toggle Output for port pin  */
#define GPTGL_TGL5_TGL                 (1 << 5)
/* Toggle Output for port pin  */
#define GPTGL_TGL6_TGL                 (1 << 6)
/* Toggle Output for port pin  */
#define GPTGL_TGL7_TGL                 (1 << 7)

/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* GPIO0                                              Base Address 0x40006000 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for GP0CON*/
#define GP0CON_RVAL                    0x0 

/* Masks for bitfields in GP0CON*/
#define GP0CON_CON0_MSK                (0x3 << 0)
#define GP0CON_CON1_MSK                (0x3 << 2)
#define GP0CON_CON2_MSK                (0x3 << 4)
#define GP0CON_CON3_MSK                (0x3 << 6)
#define GP0CON_CON4_MSK                (0x3 << 8)
#define GP0CON_CON5_MSK                (0x3 << 10)
#define GP0CON_CON6_MSK                (0x3 << 12)
#define GP0CON_CON7_MSK                (0x3 << 14)

/* Configuration bits for P0.0  */
#define GP0CON_CON0_GPIO               (0 << 0)
#define GP0CON_CON0_SPI1MISO           (1 << 0)
/* Configuration bits for P0.1  */
#define GP0CON_CON1_GPIO               (0 << 2)
#define GP0CON_CON1_SPI1SCLK           (1 << 2)
/* Configuration bits for P0.2  */
#define GP0CON_CON2_GPIO               (0 << 4)
#define GP0CON_CON2_SPI1MOSI           (1 << 4)
#define GP0CON_CON2_PWM0               (3 << 4)
/* Configuration bits for P0.3  */
#define GP0CON_CON3_GPIOIRQ1           (0 << 6)
#define GP0CON_CON3_SPI1CS0            (1 << 6)
#define GP0CON_CON3_PWM1               (3 << 6)
/* Configuration bits for P0.4  */
#define GP0CON_CON4_GPIOIRQ0           (0 << 8)
#define GP0CON_CON4_SPI1CS1            (1 << 8)
#define GP0CON_CON4_ECLKOUT            (2 << 8)
/* Configuration bits for P0.5  */
#define GP0CON_CON5_GPIO               (0 << 10)
#define GP0CON_CON5_SPI1CS2            (1 << 10)
#define GP0CON_CON5_ECLKIN             (2 << 10)
/* Configuration bits for P0.6  */
#define GP0CON_CON6_GPIOIRQ2           (0 << 12)
#define GP0CON_CON6_SPI1CS3            (1 << 12)
#define GP0CON_CON6_UARTRTS            (2 << 12)
/* Configuration bits for P0.7  */
#define GP0CON_CON7_GPIOIRQ3           (0 << 14)
#define GP0CON_CON7_SPI1CS4            (1 << 14)
#define GP0CON_CON7_UARTCTS            (2 << 14)
/* Reset Value for GP0OEN*/
#define GP0OEN_RVAL                    0x0 
#define GP0OEN_OEN0_BBA                (*(volatile unsigned long *) 0x420C0080)
#define GP0OEN_OEN1_BBA                (*(volatile unsigned long *) 0x420C0084)
#define GP0OEN_OEN2_BBA                (*(volatile unsigned long *) 0x420C0088)
#define GP0OEN_OEN3_BBA                (*(volatile unsigned long *) 0x420C008C)
#define GP0OEN_OEN4_BBA                (*(volatile unsigned long *) 0x420C0090)
#define GP0OEN_OEN5_BBA                (*(volatile unsigned long *) 0x420C0094)
#define GP0OEN_OEN6_BBA                (*(volatile unsigned long *) 0x420C0098)
#define GP0OEN_OEN7_BBA                (*(volatile unsigned long *) 0x420C009C)

/* Masks for bitfields in GP0OEN*/
#define GP0OEN_OEN0                    GPOEN_OEN0
#define GP0OEN_OEN1                    GPOEN_OEN1
#define GP0OEN_OEN2                    GPOEN_OEN2
#define GP0OEN_OEN3                    GPOEN_OEN3
#define GP0OEN_OEN4                    GPOEN_OEN4
#define GP0OEN_OEN5                    GPOEN_OEN5
#define GP0OEN_OEN6                    GPOEN_OEN6
#define GP0OEN_OEN7                    GPOEN_OEN7

/* Direction for port pin  */
#define GP0OEN_OEN0_IN                 GPOEN_OEN0_IN
#define GP0OEN_OEN0_OUT                GPOEN_OEN0_OUT
/* Direction for port pin  */
#define GP0OEN_OEN1_IN                 GPOEN_OEN1_IN
#define GP0OEN_OEN1_OUT                GPOEN_OEN1_OUT
/* Direction for port pin  */
#define GP0OEN_OEN2_IN                 GPOEN_OEN2_IN
#define GP0OEN_OEN2_OUT                GPOEN_OEN2_OUT
/* Direction for port pin  */
#define GP0OEN_OEN3_IN                 GPOEN_OEN3_IN
#define GP0OEN_OEN3_OUT                GPOEN_OEN3_OUT
/* Direction for port pin  */
#define GP0OEN_OEN4_IN                 GPOEN_OEN4_IN
#define GP0OEN_OEN4_OUT                GPOEN_OEN4_OUT
/* Direction for port pin  */
#define GP0OEN_OEN5_IN                 GPOEN_OEN5_IN
#define GP0OEN_OEN5_OUT                GPOEN_OEN5_OUT
/* Direction for port pin  */
#define GP0OEN_OEN6_IN                 GPOEN_OEN6_IN
#define GP0OEN_OEN6_OUT                GPOEN_OEN6_OUT
/* Direction for port pin  */
#define GP0OEN_OEN7_IN                 GPOEN_OEN7_IN
#define GP0OEN_OEN7_OUT                GPOEN_OEN7_OUT
/* Reset Value for GP0PUL*/
#define GP0PUL_RVAL                    0xFF 
#define GP0PUL_PUL0_BBA                (*(volatile unsigned long *) 0x420C0100)
#define GP0PUL_PUL1_BBA                (*(volatile unsigned long *) 0x420C0104)
#define GP0PUL_PUL2_BBA                (*(volatile unsigned long *) 0x420C0108)
#define GP0PUL_PUL3_BBA                (*(volatile unsigned long *) 0x420C010C)
#define GP0PUL_PUL4_BBA                (*(volatile unsigned long *) 0x420C0110)
#define GP0PUL_PUL5_BBA                (*(volatile unsigned long *) 0x420C0114)
#define GP0PUL_PUL6_BBA                (*(volatile unsigned long *) 0x420C0118)
#define GP0PUL_PUL7_BBA                (*(volatile unsigned long *) 0x420C011C)

/* Masks for bitfields in GP0PUL*/
#define GP0PUL_PUL0                    GPPUL_PUL0
#define GP0PUL_PUL1                    GPPUL_PUL1
#define GP0PUL_PUL2                    GPPUL_PUL2
#define GP0PUL_PUL3                    GPPUL_PUL3
#define GP0PUL_PUL4                    GPPUL_PUL4
#define GP0PUL_PUL5                    GPPUL_PUL5
#define GP0PUL_PUL6                    GPPUL_PUL6
#define GP0PUL_PUL7                    GPPUL_PUL7

/* Reset Value for GP0OCE*/
#define GP0OCE_RVAL                    0x0 
#define GP0OCE_OCE0_BBA                (*(volatile unsigned long *) 0x420C0180)
#define GP0OCE_OCE1_BBA                (*(volatile unsigned long *) 0x420C0184)
#define GP0OCE_OCE2_BBA                (*(volatile unsigned long *) 0x420C0188)
#define GP0OCE_OCE3_BBA                (*(volatile unsigned long *) 0x420C018C)
#define GP0OCE_OCE4_BBA                (*(volatile unsigned long *) 0x420C0190)
#define GP0OCE_OCE5_BBA                (*(volatile unsigned long *) 0x420C0194)
#define GP0OCE_OCE6_BBA                (*(volatile unsigned long *) 0x420C0198)
#define GP0OCE_OCE7_BBA                (*(volatile unsigned long *) 0x420C019C)

/* Masks for bitfields in GP0OCE*/
#define GP0OCE_OCE0                    GPOCE_OCE0
#define GP0OCE_OCE1                    GPOCE_OCE1
#define GP0OCE_OCE2                    GPOCE_OCE2
#define GP0OCE_OCE3                    GPOCE_OCE3
#define GP0OCE_OCE4                    GPOCE_OCE4
#define GP0OCE_OCE5                    GPOCE_OCE5
#define GP0OCE_OCE6                    GPOCE_OCE6
#define GP0OCE_OCE7                    GPOCE_OCE7

/* Reset Value for GP0IN*/
#define GP0IN_RVAL                     0xFF 
#define GP0IN_IN0_BBA                  (*(volatile unsigned long *) 0x420C0280)
#define GP0IN_IN1_BBA                  (*(volatile unsigned long *) 0x420C0284)
#define GP0IN_IN2_BBA                  (*(volatile unsigned long *) 0x420C0288)
#define GP0IN_IN3_BBA                  (*(volatile unsigned long *) 0x420C028C)
#define GP0IN_IN4_BBA                  (*(volatile unsigned long *) 0x420C0290)
#define GP0IN_IN5_BBA                  (*(volatile unsigned long *) 0x420C0294)
#define GP0IN_IN6_BBA                  (*(volatile unsigned long *) 0x420C0298)
#define GP0IN_IN7_BBA                  (*(volatile unsigned long *) 0x420C029C)

/* Masks for bitfields in GP0IN*/
#define GP0IN_IN0                      GPIN_IN0
#define GP0IN_IN1                      GPIN_IN1
#define GP0IN_IN2                      GPIN_IN2
#define GP0IN_IN3                      GPIN_IN3
#define GP0IN_IN4                      GPIN_IN4
#define GP0IN_IN5                      GPIN_IN5
#define GP0IN_IN6                      GPIN_IN6
#define GP0IN_IN7                      GPIN_IN7

/* Input for port pin  */
#define GP0IN_IN0_LOW                  GPIN_IN0_LOW
#define GP0IN_IN0_HIGH                 GPIN_IN0_HIGH
/* Input for port pin  */
#define GP0IN_IN1_LOW                  GPIN_IN1_LOW
#define GP0IN_IN1_HIGH                 GPIN_IN1_HIGH
/* Input for port pin  */
#define GP0IN_IN2_LOW                  GPIN_IN2_LOW
#define GP0IN_IN2_HIGH                 GPIN_IN2_HIGH
/* Input for port pin  */
#define GP0IN_IN3_LOW                  GPIN_IN3_LOW
#define GP0IN_IN3_HIGH                 GPIN_IN3_HIGH
/* Input for port pin  */
#define GP0IN_IN4_LOW                  GPIN_IN4_LOW
#define GP0IN_IN4_HIGH                 GPIN_IN4_HIGH
/* Input for port pin  */
#define GP0IN_IN5_LOW                  GPIN_IN5_LOW
#define GP0IN_IN5_HIGH                 GPIN_IN5_HIGH
/* Input for port pin  */
#define GP0IN_IN6_LOW                  GPIN_IN6_LOW
#define GP0IN_IN6_HIGH                 GPIN_IN6_HIGH
/* Input for port pin  */
#define GP0IN_IN7_LOW                  GPIN_IN7_LOW
#define GP0IN_IN7_HIGH                 GPIN_IN7_HIGH
/* Reset Value for GP0OUT*/
#define GP0OUT_RVAL                    0x0 
#define GP0OUT_OUT0_BBA                (*(volatile unsigned long *) 0x420C0300)
#define GP0OUT_OUT1_BBA                (*(volatile unsigned long *) 0x420C0304)
#define GP0OUT_OUT2_BBA                (*(volatile unsigned long *) 0x420C0308)
#define GP0OUT_OUT3_BBA                (*(volatile unsigned long *) 0x420C030C)
#define GP0OUT_OUT4_BBA                (*(volatile unsigned long *) 0x420C0310)
#define GP0OUT_OUT5_BBA                (*(volatile unsigned long *) 0x420C0314)
#define GP0OUT_OUT6_BBA                (*(volatile unsigned long *) 0x420C0318)
#define GP0OUT_OUT7_BBA                (*(volatile unsigned long *) 0x420C031C)

/* Masks for bitfields in GP0OUT*/
#define GP0OUT_OUT0                    GPOUT_OUT0
#define GP0OUT_OUT1                    GPOUT_OUT1
#define GP0OUT_OUT2                    GPOUT_OUT2
#define GP0OUT_OUT3                    GPOUT_OUT3
#define GP0OUT_OUT4                    GPOUT_OUT4
#define GP0OUT_OUT5                    GPOUT_OUT5
#define GP0OUT_OUT6                    GPOUT_OUT6
#define GP0OUT_OUT7                    GPOUT_OUT7

/* Output for port pin  */
#define GP0OUT_OUT0_LOW                GPOUT_OUT0_LOW
#define GP0OUT_OUT0_HIGH               GPOUT_OUT0_HIGH
/* Output for port pin  */
#define GP0OUT_OUT1_LOW                GPOUT_OUT1_LOW
#define GP0OUT_OUT1_HIGH               GPOUT_OUT1_HIGH
/* Output for port pin  */
#define GP0OUT_OUT2_LOW                GPOUT_OUT2_LOW
#define GP0OUT_OUT2_HIGH               GPOUT_OUT2_HIGH
/* Output for port pin  */
#define GP0OUT_OUT3_LOW                GPOUT_OUT3_LOW
#define GP0OUT_OUT3_HIGH               GPOUT_OUT3_HIGH
/* Output for port pin  */
#define GP0OUT_OUT4_LOW                GPOUT_OUT4_LOW
#define GP0OUT_OUT4_HIGH               GPOUT_OUT4_HIGH
/* Output for port pin  */
#define GP0OUT_OUT5_LOW                GPOUT_OUT5_LOW
#define GP0OUT_OUT5_HIGH               GPOUT_OUT5_HIGH
/* Output for port pin  */
#define GP0OUT_OUT6_LOW                GPOUT_OUT6_LOW
#define GP0OUT_OUT6_HIGH               GPOUT_OUT6_HIGH
/* Output for port pin  */
#define GP0OUT_OUT7_LOW                GPOUT_OUT7_LOW
#define GP0OUT_OUT7_HIGH               GPOUT_OUT7_HIGH
/* Reset Value for GP0SET*/
#define GP0SET_RVAL                    0x0 
#define GP0SET_SET0_BBA                (*(volatile unsigned long *) 0x420C0380)
#define GP0SET_SET1_BBA                (*(volatile unsigned long *) 0x420C0384)
#define GP0SET_SET2_BBA                (*(volatile unsigned long *) 0x420C0388)
#define GP0SET_SET3_BBA                (*(volatile unsigned long *) 0x420C038C)
#define GP0SET_SET4_BBA                (*(volatile unsigned long *) 0x420C0390)
#define GP0SET_SET5_BBA                (*(volatile unsigned long *) 0x420C0394)
#define GP0SET_SET6_BBA                (*(volatile unsigned long *) 0x420C0398)
#define GP0SET_SET7_BBA                (*(volatile unsigned long *) 0x420C039C)

/* Masks for bitfields in GP0SET*/
#define GP0SET_SET0                    GPSET_SET0
#define GP0SET_SET1                    GPSET_SET1
#define GP0SET_SET2                    GPSET_SET2
#define GP0SET_SET3                    GPSET_SET3
#define GP0SET_SET4                    GPSET_SET4
#define GP0SET_SET5                    GPSET_SET5
#define GP0SET_SET6                    GPSET_SET6
#define GP0SET_SET7                    GPSET_SET7

/* Set Output High for port pin  */
#define GP0SET_SET0_SET                GPSET_SET0_SET
/* Set Output High for port pin  */
#define GP0SET_SET1_SET                GPSET_SET1_SET
/* Set Output High for port pin  */
#define GP0SET_SET2_SET                GPSET_SET2_SET
/* Set Output High for port pin  */
#define GP0SET_SET3_SET                GPSET_SET3_SET
/* Set Output High for port pin  */
#define GP0SET_SET4_SET                GPSET_SET4_SET
/* Set Output High for port pin  */
#define GP0SET_SET5_SET                GPSET_SET5_SET
/* Set Output High for port pin  */
#define GP0SET_SET6_SET                GPSET_SET6_SET
/* Set Output High for port pin  */
#define GP0SET_SET7_SET                GPSET_SET7_SET
/* Reset Value for GP0CLR*/
#define GP0CLR_RVAL                    0x0 
#define GP0CLR_CLR0_BBA                (*(volatile unsigned long *) 0x420C0400)
#define GP0CLR_CLR1_BBA                (*(volatile unsigned long *) 0x420C0404)
#define GP0CLR_CLR2_BBA                (*(volatile unsigned long *) 0x420C0408)
#define GP0CLR_CLR3_BBA                (*(volatile unsigned long *) 0x420C040C)
#define GP0CLR_CLR4_BBA                (*(volatile unsigned long *) 0x420C0410)
#define GP0CLR_CLR5_BBA                (*(volatile unsigned long *) 0x420C0414)
#define GP0CLR_CLR6_BBA                (*(volatile unsigned long *) 0x420C0418)
#define GP0CLR_CLR7_BBA                (*(volatile unsigned long *) 0x420C041C)

/* Masks for bitfields in GP0CLR*/
#define GP0CLR_CLR0                    GPCLR_CLR0
#define GP0CLR_CLR1                    GPCLR_CLR1
#define GP0CLR_CLR2                    GPCLR_CLR2
#define GP0CLR_CLR3                    GPCLR_CLR3
#define GP0CLR_CLR4                    GPCLR_CLR4
#define GP0CLR_CLR5                    GPCLR_CLR5
#define GP0CLR_CLR6                    GPCLR_CLR6
#define GP0CLR_CLR7                    GPCLR_CLR7

/* Set Output Low for port pin  */
#define GP0CLR_CLR0_CLR                GPCLR_CLR0_CLR
/* Set Output Low for port pin  */
#define GP0CLR_CLR1_CLR                GPCLR_CLR1_CLR
/* Set Output Low for port pin  */
#define GP0CLR_CLR2_CLR                GPCLR_CLR2_CLR
/* Set Output Low for port pin  */
#define GP0CLR_CLR3_CLR                GPCLR_CLR3_CLR
/* Set Output Low for port pin  */
#define GP0CLR_CLR4_CLR                GPCLR_CLR4_CLR
/* Set Output Low for port pin  */
#define GP0CLR_CLR5_CLR                GPCLR_CLR5_CLR
/* Set Output Low for port pin  */
#define GP0CLR_CLR6_CLR                GPCLR_CLR6_CLR
/* Set Output Low for port pin  */
#define GP0CLR_CLR7_CLR                GPCLR_CLR7_CLR
/* Reset Value for GP0TGL*/
#define GP0TGL_RVAL                    0x0 
#define GP0TGL_TGL0_BBA                (*(volatile unsigned long *) 0x420C0480)
#define GP0TGL_TGL1_BBA                (*(volatile unsigned long *) 0x420C0484)
#define GP0TGL_TGL2_BBA                (*(volatile unsigned long *) 0x420C0488)
#define GP0TGL_TGL3_BBA                (*(volatile unsigned long *) 0x420C048C)
#define GP0TGL_TGL4_BBA                (*(volatile unsigned long *) 0x420C0490)
#define GP0TGL_TGL5_BBA                (*(volatile unsigned long *) 0x420C0494)
#define GP0TGL_TGL6_BBA                (*(volatile unsigned long *) 0x420C0498)
#define GP0TGL_TGL7_BBA                (*(volatile unsigned long *) 0x420C049C)

/* Masks for bitfields in GP0TGL*/
#define GP0TGL_TGL0                    GPTGL_TGL0
#define GP0TGL_TGL1                    GPTGL_TGL1
#define GP0TGL_TGL2                    GPTGL_TGL2
#define GP0TGL_TGL3                    GPTGL_TGL3
#define GP0TGL_TGL4                    GPTGL_TGL4
#define GP0TGL_TGL5                    GPTGL_TGL5
#define GP0TGL_TGL6                    GPTGL_TGL6
#define GP0TGL_TGL7                    GPTGL_TGL7

/* Toggle Output for port pin  */
#define GP0TGL_TGL0_TGL                GPTGL_TGL0_TGL
/* Toggle Output for port pin  */
#define GP0TGL_TGL1_TGL                GPTGL_TGL1_TGL
/* Toggle Output for port pin  */
#define GP0TGL_TGL2_TGL                GPTGL_TGL2_TGL
/* Toggle Output for port pin  */
#define GP0TGL_TGL3_TGL                GPTGL_TGL3_TGL
/* Toggle Output for port pin  */
#define GP0TGL_TGL4_TGL                GPTGL_TGL4_TGL
/* Toggle Output for port pin  */
#define GP0TGL_TGL5_TGL                GPTGL_TGL5_TGL
/* Toggle Output for port pin  */
#define GP0TGL_TGL6_TGL                GPTGL_TGL6_TGL
/* Toggle Output for port pin  */
#define GP0TGL_TGL7_TGL                GPTGL_TGL7_TGL

/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* GPIO1                                              Base Address 0x40006030 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for GP1CON*/
#define GP1CON_RVAL                    0x0 

/* Masks for bitfields in GP1CON*/
#define GP1CON_CON0_MSK                (0x3 << 0)
#define GP1CON_CON1_MSK                (0x3 << 2)
#define GP1CON_CON2_MSK                (0x3 << 4)
#define GP1CON_CON3_MSK                (0x3 << 6)
#define GP1CON_CON4_MSK                (0x3 << 8)
#define GP1CON_CON5_MSK                (0x3 << 10)
#define GP1CON_CON6_MSK                (0x3 << 12)

/* Configuration bits for P1.0  */
#define GP1CON_CON0_GPIOIRQ4           (0 << 0)
#define GP1CON_CON0_UART0RXD           (1 << 0)
#define GP1CON_CON0_PWM2               (3 << 0)
/* Configuration bits for P1.1  */
#define GP1CON_CON1_PORB               (0 << 2)
#define GP1CON_CON1_GPIO               (1 << 2)
#define GP1CON_CON1_UART0TXD           (2 << 2)
#define GP1CON_CON1_PWM3               (3 << 2)
/* Configuration bits for P1.2  */
#define GP1CON_CON2_GPIO               (1 << 4)
#define GP1CON_CON2_PWM4               (3 << 4)
/* Configuration bits for P1.3  */
#define GP1CON_CON3_GPIO               (1 << 6)
#define GP1CON_CON3_PWM5               (3 << 6)
/* Configuration bits for P1.4  */
#define GP1CON_CON4_GPIOIRQ5           (0 << 8)
#define GP1CON_CON4_I2C0SCL            (1 << 8)
#define GP1CON_CON4_PWM6               (2 << 8)
/* Configuration bits for P1.5  */
#define GP1CON_CON5_GPIOIRQ6           (0 << 10)
#define GP1CON_CON5_I2C0SDA            (1 << 10)
#define GP1CON_CON5_PWM7               (2 << 10)
/* Configuration bits for P1.6  */
#define GP1CON_CON6_GPIOIRQ7           (0 << 12)
#define GP1CON_CON6_ADCCONVST          (1 << 12)
#define GP1CON_CON6_PWMSYNC            (3 << 12)
/* Reset Value for GP1OEN*/
#define GP1OEN_RVAL                    0x0 
#define GP1OEN_OEN0_BBA                (*(volatile unsigned long *) 0x420C0680)
#define GP1OEN_OEN1_BBA                (*(volatile unsigned long *) 0x420C0684)
#define GP1OEN_OEN2_BBA                (*(volatile unsigned long *) 0x420C0688)
#define GP1OEN_OEN3_BBA                (*(volatile unsigned long *) 0x420C068C)
#define GP1OEN_OEN4_BBA                (*(volatile unsigned long *) 0x420C0690)
#define GP1OEN_OEN5_BBA                (*(volatile unsigned long *) 0x420C0694)
#define GP1OEN_OEN6_BBA                (*(volatile unsigned long *) 0x420C0698)
#define GP1OEN_OEN7_BBA                (*(volatile unsigned long *) 0x420C069C)

/* Masks for bitfields in GP1OEN*/
#define GP1OEN_OEN0                    GPOEN_OEN0
#define GP1OEN_OEN1                    GPOEN_OEN1
#define GP1OEN_OEN2                    GPOEN_OEN2
#define GP1OEN_OEN3                    GPOEN_OEN3
#define GP1OEN_OEN4                    GPOEN_OEN4
#define GP1OEN_OEN5                    GPOEN_OEN5
#define GP1OEN_OEN6                    GPOEN_OEN6
#define GP1OEN_OEN7                    GPOEN_OEN7

/* Direction for port pin  */
#define GP1OEN_OEN0_IN                 GPOEN_OEN0_IN
#define GP1OEN_OEN0_OUT                GPOEN_OEN0_OUT
/* Direction for port pin  */
#define GP1OEN_OEN1_IN                 GPOEN_OEN1_IN
#define GP1OEN_OEN1_OUT                GPOEN_OEN1_OUT
/* Direction for port pin  */
#define GP1OEN_OEN2_IN                 GPOEN_OEN2_IN
#define GP1OEN_OEN2_OUT                GPOEN_OEN2_OUT
/* Direction for port pin  */
#define GP1OEN_OEN3_IN                 GPOEN_OEN3_IN
#define GP1OEN_OEN3_OUT                GPOEN_OEN3_OUT
/* Direction for port pin  */
#define GP1OEN_OEN4_IN                 GPOEN_OEN4_IN
#define GP1OEN_OEN4_OUT                GPOEN_OEN4_OUT
/* Direction for port pin  */
#define GP1OEN_OEN5_IN                 GPOEN_OEN5_IN
#define GP1OEN_OEN5_OUT                GPOEN_OEN5_OUT
/* Direction for port pin  */
#define GP1OEN_OEN6_IN                 GPOEN_OEN6_IN
#define GP1OEN_OEN6_OUT                GPOEN_OEN6_OUT
/* Direction for port pin  */
#define GP1OEN_OEN7_IN                 GPOEN_OEN7_IN
#define GP1OEN_OEN7_OUT                GPOEN_OEN7_OUT
/* Reset Value for GP1PUL*/
#define GP1PUL_RVAL                    0x7F 
#define GP1PUL_PUL0_BBA                (*(volatile unsigned long *) 0x420C0700)
#define GP1PUL_PUL1_BBA                (*(volatile unsigned long *) 0x420C0704)
#define GP1PUL_PUL2_BBA                (*(volatile unsigned long *) 0x420C0708)
#define GP1PUL_PUL3_BBA                (*(volatile unsigned long *) 0x420C070C)
#define GP1PUL_PUL4_BBA                (*(volatile unsigned long *) 0x420C0710)
#define GP1PUL_PUL5_BBA                (*(volatile unsigned long *) 0x420C0714)
#define GP1PUL_PUL6_BBA                (*(volatile unsigned long *) 0x420C0718)
#define GP1PUL_PUL7_BBA                (*(volatile unsigned long *) 0x420C071C)

/* Masks for bitfields in GP1PUL*/
#define GP1PUL_PUL0                    GPPUL_PUL0
#define GP1PUL_PUL1                    GPPUL_PUL1
#define GP1PUL_PUL2                    GPPUL_PUL2
#define GP1PUL_PUL3                    GPPUL_PUL3
#define GP1PUL_PUL4                    GPPUL_PUL4
#define GP1PUL_PUL5                    GPPUL_PUL5
#define GP1PUL_PUL6                    GPPUL_PUL6
#define GP1PUL_PUL7                    GPPUL_PUL7

/* Reset Value for GP1OCE*/
#define GP1OCE_RVAL                    0x0 
#define GP1OCE_OCE0_BBA                (*(volatile unsigned long *) 0x420C0780)
#define GP1OCE_OCE1_BBA                (*(volatile unsigned long *) 0x420C0784)
#define GP1OCE_OCE2_BBA                (*(volatile unsigned long *) 0x420C0788)
#define GP1OCE_OCE3_BBA                (*(volatile unsigned long *) 0x420C078C)
#define GP1OCE_OCE4_BBA                (*(volatile unsigned long *) 0x420C0790)
#define GP1OCE_OCE5_BBA                (*(volatile unsigned long *) 0x420C0794)
#define GP1OCE_OCE6_BBA                (*(volatile unsigned long *) 0x420C0798)
#define GP1OCE_OCE7_BBA                (*(volatile unsigned long *) 0x420C079C)

/* Masks for bitfields in GP1OCE*/
#define GP1OCE_OCE0                    GPOCE_OCE0
#define GP1OCE_OCE1                    GPOCE_OCE1
#define GP1OCE_OCE2                    GPOCE_OCE2
#define GP1OCE_OCE3                    GPOCE_OCE3
#define GP1OCE_OCE4                    GPOCE_OCE4
#define GP1OCE_OCE5                    GPOCE_OCE5
#define GP1OCE_OCE6                    GPOCE_OCE6
#define GP1OCE_OCE7                    GPOCE_OCE7

/* Reset Value for GP1IN*/
#define GP1IN_RVAL                     0x7F 
#define GP1IN_IN0_BBA                  (*(volatile unsigned long *) 0x420C0880)
#define GP1IN_IN1_BBA                  (*(volatile unsigned long *) 0x420C0884)
#define GP1IN_IN2_BBA                  (*(volatile unsigned long *) 0x420C0888)
#define GP1IN_IN3_BBA                  (*(volatile unsigned long *) 0x420C088C)
#define GP1IN_IN4_BBA                  (*(volatile unsigned long *) 0x420C0890)
#define GP1IN_IN5_BBA                  (*(volatile unsigned long *) 0x420C0894)
#define GP1IN_IN6_BBA                  (*(volatile unsigned long *) 0x420C0898)
#define GP1IN_IN7_BBA                  (*(volatile unsigned long *) 0x420C089C)

/* Masks for bitfields in GP1IN*/
#define GP1IN_IN0                      GPIN_IN0
#define GP1IN_IN1                      GPIN_IN1
#define GP1IN_IN2                      GPIN_IN2
#define GP1IN_IN3                      GPIN_IN3
#define GP1IN_IN4                      GPIN_IN4
#define GP1IN_IN5                      GPIN_IN5
#define GP1IN_IN6                      GPIN_IN6
#define GP1IN_IN7                      GPIN_IN7

/* Input for port pin  */
#define GP1IN_IN0_LOW                  GPIN_IN0_LOW
#define GP1IN_IN0_HIGH                 GPIN_IN0_HIGH
/* Input for port pin  */
#define GP1IN_IN1_LOW                  GPIN_IN1_LOW
#define GP1IN_IN1_HIGH                 GPIN_IN1_HIGH
/* Input for port pin  */
#define GP1IN_IN2_LOW                  GPIN_IN2_LOW
#define GP1IN_IN2_HIGH                 GPIN_IN2_HIGH
/* Input for port pin  */
#define GP1IN_IN3_LOW                  GPIN_IN3_LOW
#define GP1IN_IN3_HIGH                 GPIN_IN3_HIGH
/* Input for port pin  */
#define GP1IN_IN4_LOW                  GPIN_IN4_LOW
#define GP1IN_IN4_HIGH                 GPIN_IN4_HIGH
/* Input for port pin  */
#define GP1IN_IN5_LOW                  GPIN_IN5_LOW
#define GP1IN_IN5_HIGH                 GPIN_IN5_HIGH
/* Input for port pin  */
#define GP1IN_IN6_LOW                  GPIN_IN6_LOW
#define GP1IN_IN6_HIGH                 GPIN_IN6_HIGH
/* Input for port pin  */
#define GP1IN_IN7_LOW                  GPIN_IN7_LOW
#define GP1IN_IN7_HIGH                 GPIN_IN7_HIGH
/* Reset Value for GP1OUT*/
#define GP1OUT_RVAL                    0x0 
#define GP1OUT_OUT0_BBA                (*(volatile unsigned long *) 0x420C0900)
#define GP1OUT_OUT1_BBA                (*(volatile unsigned long *) 0x420C0904)
#define GP1OUT_OUT2_BBA                (*(volatile unsigned long *) 0x420C0908)
#define GP1OUT_OUT3_BBA                (*(volatile unsigned long *) 0x420C090C)
#define GP1OUT_OUT4_BBA                (*(volatile unsigned long *) 0x420C0910)
#define GP1OUT_OUT5_BBA                (*(volatile unsigned long *) 0x420C0914)
#define GP1OUT_OUT6_BBA                (*(volatile unsigned long *) 0x420C0918)
#define GP1OUT_OUT7_BBA                (*(volatile unsigned long *) 0x420C091C)

/* Masks for bitfields in GP1OUT*/
#define GP1OUT_OUT0                    GPOUT_OUT0
#define GP1OUT_OUT1                    GPOUT_OUT1
#define GP1OUT_OUT2                    GPOUT_OUT2
#define GP1OUT_OUT3                    GPOUT_OUT3
#define GP1OUT_OUT4                    GPOUT_OUT4
#define GP1OUT_OUT5                    GPOUT_OUT5
#define GP1OUT_OUT6                    GPOUT_OUT6
#define GP1OUT_OUT7                    GPOUT_OUT7

/* Output for port pin  */
#define GP1OUT_OUT0_LOW                GPOUT_OUT0_LOW
#define GP1OUT_OUT0_HIGH               GPOUT_OUT0_HIGH
/* Output for port pin  */
#define GP1OUT_OUT1_LOW                GPOUT_OUT1_LOW
#define GP1OUT_OUT1_HIGH               GPOUT_OUT1_HIGH
/* Output for port pin  */
#define GP1OUT_OUT2_LOW                GPOUT_OUT2_LOW
#define GP1OUT_OUT2_HIGH               GPOUT_OUT2_HIGH
/* Output for port pin  */
#define GP1OUT_OUT3_LOW                GPOUT_OUT3_LOW
#define GP1OUT_OUT3_HIGH               GPOUT_OUT3_HIGH
/* Output for port pin  */
#define GP1OUT_OUT4_LOW                GPOUT_OUT4_LOW
#define GP1OUT_OUT4_HIGH               GPOUT_OUT4_HIGH
/* Output for port pin  */
#define GP1OUT_OUT5_LOW                GPOUT_OUT5_LOW
#define GP1OUT_OUT5_HIGH               GPOUT_OUT5_HIGH
/* Output for port pin  */
#define GP1OUT_OUT6_LOW                GPOUT_OUT6_LOW
#define GP1OUT_OUT6_HIGH               GPOUT_OUT6_HIGH
/* Output for port pin  */
#define GP1OUT_OUT7_LOW                GPOUT_OUT7_LOW
#define GP1OUT_OUT7_HIGH               GPOUT_OUT7_HIGH
/* Reset Value for GP1SET*/
#define GP1SET_RVAL                    0x0 
#define GP1SET_SET0_BBA                (*(volatile unsigned long *) 0x420C0980)
#define GP1SET_SET1_BBA                (*(volatile unsigned long *) 0x420C0984)
#define GP1SET_SET2_BBA                (*(volatile unsigned long *) 0x420C0988)
#define GP1SET_SET3_BBA                (*(volatile unsigned long *) 0x420C098C)
#define GP1SET_SET4_BBA                (*(volatile unsigned long *) 0x420C0990)
#define GP1SET_SET5_BBA                (*(volatile unsigned long *) 0x420C0994)
#define GP1SET_SET6_BBA                (*(volatile unsigned long *) 0x420C0998)
#define GP1SET_SET7_BBA                (*(volatile unsigned long *) 0x420C099C)

/* Masks for bitfields in GP1SET*/
#define GP1SET_SET0                    GPSET_SET0
#define GP1SET_SET1                    GPSET_SET1
#define GP1SET_SET2                    GPSET_SET2
#define GP1SET_SET3                    GPSET_SET3
#define GP1SET_SET4                    GPSET_SET4
#define GP1SET_SET5                    GPSET_SET5
#define GP1SET_SET6                    GPSET_SET6
#define GP1SET_SET7                    GPSET_SET7

/* Set Output High for port pin  */
#define GP1SET_SET0_SET                GPSET_SET0_SET
/* Set Output High for port pin  */
#define GP1SET_SET1_SET                GPSET_SET1_SET
/* Set Output High for port pin  */
#define GP1SET_SET2_SET                GPSET_SET2_SET
/* Set Output High for port pin  */
#define GP1SET_SET3_SET                GPSET_SET3_SET
/* Set Output High for port pin  */
#define GP1SET_SET4_SET                GPSET_SET4_SET
/* Set Output High for port pin  */
#define GP1SET_SET5_SET                GPSET_SET5_SET
/* Set Output High for port pin  */
#define GP1SET_SET6_SET                GPSET_SET6_SET
/* Set Output High for port pin  */
#define GP1SET_SET7_SET                GPSET_SET7_SET
/* Reset Value for GP1CLR*/
#define GP1CLR_RVAL                    0x0 
#define GP1CLR_CLR0_BBA                (*(volatile unsigned long *) 0x420C0A00)
#define GP1CLR_CLR1_BBA                (*(volatile unsigned long *) 0x420C0A04)
#define GP1CLR_CLR2_BBA                (*(volatile unsigned long *) 0x420C0A08)
#define GP1CLR_CLR3_BBA                (*(volatile unsigned long *) 0x420C0A0C)
#define GP1CLR_CLR4_BBA                (*(volatile unsigned long *) 0x420C0A10)
#define GP1CLR_CLR5_BBA                (*(volatile unsigned long *) 0x420C0A14)
#define GP1CLR_CLR6_BBA                (*(volatile unsigned long *) 0x420C0A18)
#define GP1CLR_CLR7_BBA                (*(volatile unsigned long *) 0x420C0A1C)

/* Masks for bitfields in GP1CLR*/
#define GP1CLR_CLR0                    GPCLR_CLR0
#define GP1CLR_CLR1                    GPCLR_CLR1
#define GP1CLR_CLR2                    GPCLR_CLR2
#define GP1CLR_CLR3                    GPCLR_CLR3
#define GP1CLR_CLR4                    GPCLR_CLR4
#define GP1CLR_CLR5                    GPCLR_CLR5
#define GP1CLR_CLR6                    GPCLR_CLR6
#define GP1CLR_CLR7                    GPCLR_CLR7

/* Set Output Low for port pin  */
#define GP1CLR_CLR0_CLR                GPCLR_CLR0_CLR
/* Set Output Low for port pin  */
#define GP1CLR_CLR1_CLR                GPCLR_CLR1_CLR
/* Set Output Low for port pin  */
#define GP1CLR_CLR2_CLR                GPCLR_CLR2_CLR
/* Set Output Low for port pin  */
#define GP1CLR_CLR3_CLR                GPCLR_CLR3_CLR
/* Set Output Low for port pin  */
#define GP1CLR_CLR4_CLR                GPCLR_CLR4_CLR
/* Set Output Low for port pin  */
#define GP1CLR_CLR5_CLR                GPCLR_CLR5_CLR
/* Set Output Low for port pin  */
#define GP1CLR_CLR6_CLR                GPCLR_CLR6_CLR
/* Set Output Low for port pin  */
#define GP1CLR_CLR7_CLR                GPCLR_CLR7_CLR
/* Reset Value for GP1TGL*/
#define GP1TGL_RVAL                    0x0 
#define GP1TGL_TGL0_BBA                (*(volatile unsigned long *) 0x420C0A80)
#define GP1TGL_TGL1_BBA                (*(volatile unsigned long *) 0x420C0A84)
#define GP1TGL_TGL2_BBA                (*(volatile unsigned long *) 0x420C0A88)
#define GP1TGL_TGL3_BBA                (*(volatile unsigned long *) 0x420C0A8C)
#define GP1TGL_TGL4_BBA                (*(volatile unsigned long *) 0x420C0A90)
#define GP1TGL_TGL5_BBA                (*(volatile unsigned long *) 0x420C0A94)
#define GP1TGL_TGL6_BBA                (*(volatile unsigned long *) 0x420C0A98)
#define GP1TGL_TGL7_BBA                (*(volatile unsigned long *) 0x420C0A9C)

/* Masks for bitfields in GP1TGL*/
#define GP1TGL_TGL0                    GPTGL_TGL0
#define GP1TGL_TGL1                    GPTGL_TGL1
#define GP1TGL_TGL2                    GPTGL_TGL2
#define GP1TGL_TGL3                    GPTGL_TGL3
#define GP1TGL_TGL4                    GPTGL_TGL4
#define GP1TGL_TGL5                    GPTGL_TGL5
#define GP1TGL_TGL6                    GPTGL_TGL6
#define GP1TGL_TGL7                    GPTGL_TGL7

/* Toggle Output for port pin  */
#define GP1TGL_TGL0_TGL                GPTGL_TGL0_TGL
/* Toggle Output for port pin  */
#define GP1TGL_TGL1_TGL                GPTGL_TGL1_TGL
/* Toggle Output for port pin  */
#define GP1TGL_TGL2_TGL                GPTGL_TGL2_TGL
/* Toggle Output for port pin  */
#define GP1TGL_TGL3_TGL                GPTGL_TGL3_TGL
/* Toggle Output for port pin  */
#define GP1TGL_TGL4_TGL                GPTGL_TGL4_TGL
/* Toggle Output for port pin  */
#define GP1TGL_TGL5_TGL                GPTGL_TGL5_TGL
/* Toggle Output for port pin  */
#define GP1TGL_TGL6_TGL                GPTGL_TGL6_TGL
/* Toggle Output for port pin  */
#define GP1TGL_TGL7_TGL                GPTGL_TGL7_TGL

/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* GPIO2                                              Base Address 0x40006060 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for GP2CON*/
#define GP2CON_RVAL                    0x0 

/* Masks for bitfields in GP2CON*/
#define GP2CON_CON0_MSK                (0x3 << 0)
#define GP2CON_CON1_MSK                (0x3 << 2)
#define GP2CON_CON2_MSK                (0x3 << 4)
#define GP2CON_CON3_MSK                (0x3 << 6)
#define GP2CON_CON4_MSK                (0x3 << 8)
#define GP2CON_CON5_MSK                (0x3 << 10)
#define GP2CON_CON6_MSK                (0x3 << 12)
#define GP2CON_CON7_MSK                (0x3 << 14)

/* Configuration bits for P2.0  */
#define GP2CON_CON0_SPI0MISO           (0 << 0)
#define GP2CON_CON0_GPIO               (1 << 0)
/* Configuration bits for P2.1  */
#define GP2CON_CON1_SPI0SCLK           (0 << 2)
#define GP2CON_CON1_GPIO               (1 << 2)
/* Configuration bits for P2.2  */
#define GP2CON_CON2_SPI0MOSI           (0 << 4)
#define GP2CON_CON2_GPIO               (1 << 4)
/* Configuration bits for P2.3  */
#define GP2CON_CON3_SPI0CS             (0 << 6)
#define GP2CON_CON3_GPIO               (1 << 6)
/* Configuration bits for P2.4  */
#define GP2CON_CON4_IRQ8               (0 << 8)
#define GP2CON_CON4_GPIO               (1 << 8)
/* Configuration bits for P2.5  */
#define GP2CON_CON5_GPIO               (2 << 10)
/* Configuration bits for P2.6  */
#define GP2CON_CON6_GPIO               (1 << 12)
/* Configuration bits for P2.7  */
#define GP2CON_CON7_GPIO               (0 << 14)
/* Reset Value for GP2OEN*/
#define GP2OEN_RVAL                    0x0 
#define GP2OEN_OEN0_BBA                (*(volatile unsigned long *) 0x420C0C80)
#define GP2OEN_OEN1_BBA                (*(volatile unsigned long *) 0x420C0C84)
#define GP2OEN_OEN2_BBA                (*(volatile unsigned long *) 0x420C0C88)
#define GP2OEN_OEN3_BBA                (*(volatile unsigned long *) 0x420C0C8C)
#define GP2OEN_OEN4_BBA                (*(volatile unsigned long *) 0x420C0C90)
#define GP2OEN_OEN5_BBA                (*(volatile unsigned long *) 0x420C0C94)
#define GP2OEN_OEN6_BBA                (*(volatile unsigned long *) 0x420C0C98)
#define GP2OEN_OEN7_BBA                (*(volatile unsigned long *) 0x420C0C9C)

/* Masks for bitfields in GP2OEN*/
#define GP2OEN_OEN0                    GPOEN_OEN0
#define GP2OEN_OEN1                    GPOEN_OEN1
#define GP2OEN_OEN2                    GPOEN_OEN2
#define GP2OEN_OEN3                    GPOEN_OEN3
#define GP2OEN_OEN4                    GPOEN_OEN4
#define GP2OEN_OEN5                    GPOEN_OEN5
#define GP2OEN_OEN6                    GPOEN_OEN6
#define GP2OEN_OEN7                    GPOEN_OEN7

/* Direction for port pin  */
#define GP2OEN_OEN0_IN                 GPOEN_OEN0_IN
#define GP2OEN_OEN0_OUT                GPOEN_OEN0_OUT
/* Direction for port pin  */
#define GP2OEN_OEN1_IN                 GPOEN_OEN1_IN
#define GP2OEN_OEN1_OUT                GPOEN_OEN1_OUT
/* Direction for port pin  */
#define GP2OEN_OEN2_IN                 GPOEN_OEN2_IN
#define GP2OEN_OEN2_OUT                GPOEN_OEN2_OUT
/* Direction for port pin  */
#define GP2OEN_OEN3_IN                 GPOEN_OEN3_IN
#define GP2OEN_OEN3_OUT                GPOEN_OEN3_OUT
/* Direction for port pin  */
#define GP2OEN_OEN4_IN                 GPOEN_OEN4_IN
#define GP2OEN_OEN4_OUT                GPOEN_OEN4_OUT
/* Direction for port pin  */
#define GP2OEN_OEN5_IN                 GPOEN_OEN5_IN
#define GP2OEN_OEN5_OUT                GPOEN_OEN5_OUT
/* Direction for port pin  */
#define GP2OEN_OEN6_IN                 GPOEN_OEN6_IN
#define GP2OEN_OEN6_OUT                GPOEN_OEN6_OUT
/* Direction for port pin  */
#define GP2OEN_OEN7_IN                 GPOEN_OEN7_IN
#define GP2OEN_OEN7_OUT                GPOEN_OEN7_OUT
/* Reset Value for GP2PUL*/
#define GP2PUL_RVAL                    0xFF 
#define GP2PUL_PUL0_BBA                (*(volatile unsigned long *) 0x420C0D00)
#define GP2PUL_PUL1_BBA                (*(volatile unsigned long *) 0x420C0D04)
#define GP2PUL_PUL2_BBA                (*(volatile unsigned long *) 0x420C0D08)
#define GP2PUL_PUL3_BBA                (*(volatile unsigned long *) 0x420C0D0C)
#define GP2PUL_PUL4_BBA                (*(volatile unsigned long *) 0x420C0D10)
#define GP2PUL_PUL5_BBA                (*(volatile unsigned long *) 0x420C0D14)
#define GP2PUL_PUL6_BBA                (*(volatile unsigned long *) 0x420C0D18)
#define GP2PUL_PUL7_BBA                (*(volatile unsigned long *) 0x420C0D1C)

/* Masks for bitfields in GP2PUL*/
#define GP2PUL_PUL0                    GPPUL_PUL0
#define GP2PUL_PUL1                    GPPUL_PUL1
#define GP2PUL_PUL2                    GPPUL_PUL2
#define GP2PUL_PUL3                    GPPUL_PUL3
#define GP2PUL_PUL4                    GPPUL_PUL4
#define GP2PUL_PUL5                    GPPUL_PUL5
#define GP2PUL_PUL6                    GPPUL_PUL6
#define GP2PUL_PUL7                    GPPUL_PUL7

/* Reset Value for GP2OCE*/
#define GP2OCE_RVAL                    0x0 
#define GP2OCE_OCE0_BBA                (*(volatile unsigned long *) 0x420C0D80)
#define GP2OCE_OCE1_BBA                (*(volatile unsigned long *) 0x420C0D84)
#define GP2OCE_OCE2_BBA                (*(volatile unsigned long *) 0x420C0D88)
#define GP2OCE_OCE3_BBA                (*(volatile unsigned long *) 0x420C0D8C)
#define GP2OCE_OCE4_BBA                (*(volatile unsigned long *) 0x420C0D90)
#define GP2OCE_OCE5_BBA                (*(volatile unsigned long *) 0x420C0D94)
#define GP2OCE_OCE6_BBA                (*(volatile unsigned long *) 0x420C0D98)
#define GP2OCE_OCE7_BBA                (*(volatile unsigned long *) 0x420C0D9C)

/* Masks for bitfields in GP2OCE*/
#define GP2OCE_OCE0                    GPOCE_OCE0
#define GP2OCE_OCE1                    GPOCE_OCE1
#define GP2OCE_OCE2                    GPOCE_OCE2
#define GP2OCE_OCE3                    GPOCE_OCE3
#define GP2OCE_OCE4                    GPOCE_OCE4
#define GP2OCE_OCE5                    GPOCE_OCE5
#define GP2OCE_OCE6                    GPOCE_OCE6
#define GP2OCE_OCE7                    GPOCE_OCE7

/* Reset Value for GP2IN*/
#define GP2IN_RVAL                     0xFF 
#define GP2IN_IN0_BBA                  (*(volatile unsigned long *) 0x420C0E80)
#define GP2IN_IN1_BBA                  (*(volatile unsigned long *) 0x420C0E84)
#define GP2IN_IN2_BBA                  (*(volatile unsigned long *) 0x420C0E88)
#define GP2IN_IN3_BBA                  (*(volatile unsigned long *) 0x420C0E8C)
#define GP2IN_IN4_BBA                  (*(volatile unsigned long *) 0x420C0E90)
#define GP2IN_IN5_BBA                  (*(volatile unsigned long *) 0x420C0E94)
#define GP2IN_IN6_BBA                  (*(volatile unsigned long *) 0x420C0E98)
#define GP2IN_IN7_BBA                  (*(volatile unsigned long *) 0x420C0E9C)

/* Masks for bitfields in GP2IN*/
#define GP2IN_IN0                      GPIN_IN0
#define GP2IN_IN1                      GPIN_IN1
#define GP2IN_IN2                      GPIN_IN2
#define GP2IN_IN3                      GPIN_IN3
#define GP2IN_IN4                      GPIN_IN4
#define GP2IN_IN5                      GPIN_IN5
#define GP2IN_IN6                      GPIN_IN6
#define GP2IN_IN7                      GPIN_IN7

/* Input for port pin  */
#define GP2IN_IN0_LOW                  GPIN_IN0_LOW
#define GP2IN_IN0_HIGH                 GPIN_IN0_HIGH
/* Input for port pin  */
#define GP2IN_IN1_LOW                  GPIN_IN1_LOW
#define GP2IN_IN1_HIGH                 GPIN_IN1_HIGH
/* Input for port pin  */
#define GP2IN_IN2_LOW                  GPIN_IN2_LOW
#define GP2IN_IN2_HIGH                 GPIN_IN2_HIGH
/* Input for port pin  */
#define GP2IN_IN3_LOW                  GPIN_IN3_LOW
#define GP2IN_IN3_HIGH                 GPIN_IN3_HIGH
/* Input for port pin  */
#define GP2IN_IN4_LOW                  GPIN_IN4_LOW
#define GP2IN_IN4_HIGH                 GPIN_IN4_HIGH
/* Input for port pin  */
#define GP2IN_IN5_LOW                  GPIN_IN5_LOW
#define GP2IN_IN5_HIGH                 GPIN_IN5_HIGH
/* Input for port pin  */
#define GP2IN_IN6_LOW                  GPIN_IN6_LOW
#define GP2IN_IN6_HIGH                 GPIN_IN6_HIGH
/* Input for port pin  */
#define GP2IN_IN7_LOW                  GPIN_IN7_LOW
#define GP2IN_IN7_HIGH                 GPIN_IN7_HIGH
/* Reset Value for GP2OUT*/
#define GP2OUT_RVAL                    0x0 
#define GP2OUT_OUT0_BBA                (*(volatile unsigned long *) 0x420C0F00)
#define GP2OUT_OUT1_BBA                (*(volatile unsigned long *) 0x420C0F04)
#define GP2OUT_OUT2_BBA                (*(volatile unsigned long *) 0x420C0F08)
#define GP2OUT_OUT3_BBA                (*(volatile unsigned long *) 0x420C0F0C)
#define GP2OUT_OUT4_BBA                (*(volatile unsigned long *) 0x420C0F10)
#define GP2OUT_OUT5_BBA                (*(volatile unsigned long *) 0x420C0F14)
#define GP2OUT_OUT6_BBA                (*(volatile unsigned long *) 0x420C0F18)
#define GP2OUT_OUT7_BBA                (*(volatile unsigned long *) 0x420C0F1C)

/* Masks for bitfields in GP2OUT*/
#define GP2OUT_OUT0                    GPOUT_OUT0
#define GP2OUT_OUT1                    GPOUT_OUT1
#define GP2OUT_OUT2                    GPOUT_OUT2
#define GP2OUT_OUT3                    GPOUT_OUT3
#define GP2OUT_OUT4                    GPOUT_OUT4
#define GP2OUT_OUT5                    GPOUT_OUT5
#define GP2OUT_OUT6                    GPOUT_OUT6
#define GP2OUT_OUT7                    GPOUT_OUT7

/* Output for port pin  */
#define GP2OUT_OUT0_LOW                GPOUT_OUT0_LOW
#define GP2OUT_OUT0_HIGH               GPOUT_OUT0_HIGH
/* Output for port pin  */
#define GP2OUT_OUT1_LOW                GPOUT_OUT1_LOW
#define GP2OUT_OUT1_HIGH               GPOUT_OUT1_HIGH
/* Output for port pin  */
#define GP2OUT_OUT2_LOW                GPOUT_OUT2_LOW
#define GP2OUT_OUT2_HIGH               GPOUT_OUT2_HIGH
/* Output for port pin  */
#define GP2OUT_OUT3_LOW                GPOUT_OUT3_LOW
#define GP2OUT_OUT3_HIGH               GPOUT_OUT3_HIGH
/* Output for port pin  */
#define GP2OUT_OUT4_LOW                GPOUT_OUT4_LOW
#define GP2OUT_OUT4_HIGH               GPOUT_OUT4_HIGH
/* Output for port pin  */
#define GP2OUT_OUT5_LOW                GPOUT_OUT5_LOW
#define GP2OUT_OUT5_HIGH               GPOUT_OUT5_HIGH
/* Output for port pin  */
#define GP2OUT_OUT6_LOW                GPOUT_OUT6_LOW
#define GP2OUT_OUT6_HIGH               GPOUT_OUT6_HIGH
/* Output for port pin  */
#define GP2OUT_OUT7_LOW                GPOUT_OUT7_LOW
#define GP2OUT_OUT7_HIGH               GPOUT_OUT7_HIGH
/* Reset Value for GP2SET*/
#define GP2SET_RVAL                    0x0 
#define GP2SET_SET0_BBA                (*(volatile unsigned long *) 0x420C0F80)
#define GP2SET_SET1_BBA                (*(volatile unsigned long *) 0x420C0F84)
#define GP2SET_SET2_BBA                (*(volatile unsigned long *) 0x420C0F88)
#define GP2SET_SET3_BBA                (*(volatile unsigned long *) 0x420C0F8C)
#define GP2SET_SET4_BBA                (*(volatile unsigned long *) 0x420C0F90)
#define GP2SET_SET5_BBA                (*(volatile unsigned long *) 0x420C0F94)
#define GP2SET_SET6_BBA                (*(volatile unsigned long *) 0x420C0F98)
#define GP2SET_SET7_BBA                (*(volatile unsigned long *) 0x420C0F9C)

/* Masks for bitfields in GP2SET*/
#define GP2SET_SET0                    GPSET_SET0
#define GP2SET_SET1                    GPSET_SET1
#define GP2SET_SET2                    GPSET_SET2
#define GP2SET_SET3                    GPSET_SET3
#define GP2SET_SET4                    GPSET_SET4
#define GP2SET_SET5                    GPSET_SET5
#define GP2SET_SET6                    GPSET_SET6
#define GP2SET_SET7                    GPSET_SET7

/* Set Output High for port pin  */
#define GP2SET_SET0_SET                GPSET_SET0_SET
/* Set Output High for port pin  */
#define GP2SET_SET1_SET                GPSET_SET1_SET
/* Set Output High for port pin  */
#define GP2SET_SET2_SET                GPSET_SET2_SET
/* Set Output High for port pin  */
#define GP2SET_SET3_SET                GPSET_SET3_SET
/* Set Output High for port pin  */
#define GP2SET_SET4_SET                GPSET_SET4_SET
/* Set Output High for port pin  */
#define GP2SET_SET5_SET                GPSET_SET5_SET
/* Set Output High for port pin  */
#define GP2SET_SET6_SET                GPSET_SET6_SET
/* Set Output High for port pin  */
#define GP2SET_SET7_SET                GPSET_SET7_SET
/* Reset Value for GP2CLR*/
#define GP2CLR_RVAL                    0x0 
#define GP2CLR_CLR0_BBA                (*(volatile unsigned long *) 0x420C1000)
#define GP2CLR_CLR1_BBA                (*(volatile unsigned long *) 0x420C1004)
#define GP2CLR_CLR2_BBA                (*(volatile unsigned long *) 0x420C1008)
#define GP2CLR_CLR3_BBA                (*(volatile unsigned long *) 0x420C100C)
#define GP2CLR_CLR4_BBA                (*(volatile unsigned long *) 0x420C1010)
#define GP2CLR_CLR5_BBA                (*(volatile unsigned long *) 0x420C1014)
#define GP2CLR_CLR6_BBA                (*(volatile unsigned long *) 0x420C1018)
#define GP2CLR_CLR7_BBA                (*(volatile unsigned long *) 0x420C101C)

/* Masks for bitfields in GP2CLR*/
#define GP2CLR_CLR0                    GPCLR_CLR0
#define GP2CLR_CLR1                    GPCLR_CLR1
#define GP2CLR_CLR2                    GPCLR_CLR2
#define GP2CLR_CLR3                    GPCLR_CLR3
#define GP2CLR_CLR4                    GPCLR_CLR4
#define GP2CLR_CLR5                    GPCLR_CLR5
#define GP2CLR_CLR6                    GPCLR_CLR6
#define GP2CLR_CLR7                    GPCLR_CLR7

/* Set Output Low for port pin  */
#define GP2CLR_CLR0_CLR                GPCLR_CLR0_CLR
/* Set Output Low for port pin  */
#define GP2CLR_CLR1_CLR                GPCLR_CLR1_CLR
/* Set Output Low for port pin  */
#define GP2CLR_CLR2_CLR                GPCLR_CLR2_CLR
/* Set Output Low for port pin  */
#define GP2CLR_CLR3_CLR                GPCLR_CLR3_CLR
/* Set Output Low for port pin  */
#define GP2CLR_CLR4_CLR                GPCLR_CLR4_CLR
/* Set Output Low for port pin  */
#define GP2CLR_CLR5_CLR                GPCLR_CLR5_CLR
/* Set Output Low for port pin  */
#define GP2CLR_CLR6_CLR                GPCLR_CLR6_CLR
/* Set Output Low for port pin  */
#define GP2CLR_CLR7_CLR                GPCLR_CLR7_CLR
/* Reset Value for GP2TGL*/
#define GP2TGL_RVAL                    0x0 
#define GP2TGL_TGL0_BBA                (*(volatile unsigned long *) 0x420C1080)
#define GP2TGL_TGL1_BBA                (*(volatile unsigned long *) 0x420C1084)
#define GP2TGL_TGL2_BBA                (*(volatile unsigned long *) 0x420C1088)
#define GP2TGL_TGL3_BBA                (*(volatile unsigned long *) 0x420C108C)
#define GP2TGL_TGL4_BBA                (*(volatile unsigned long *) 0x420C1090)
#define GP2TGL_TGL5_BBA                (*(volatile unsigned long *) 0x420C1094)
#define GP2TGL_TGL6_BBA                (*(volatile unsigned long *) 0x420C1098)
#define GP2TGL_TGL7_BBA                (*(volatile unsigned long *) 0x420C109C)

/* Masks for bitfields in GP2TGL*/
#define GP2TGL_TGL0                    GPTGL_TGL0
#define GP2TGL_TGL1                    GPTGL_TGL1
#define GP2TGL_TGL2                    GPTGL_TGL2
#define GP2TGL_TGL3                    GPTGL_TGL3
#define GP2TGL_TGL4                    GPTGL_TGL4
#define GP2TGL_TGL5                    GPTGL_TGL5
#define GP2TGL_TGL6                    GPTGL_TGL6
#define GP2TGL_TGL7                    GPTGL_TGL7

/* Toggle Output for port pin  */
#define GP2TGL_TGL0_TGL                GPTGL_TGL0_TGL
/* Toggle Output for port pin  */
#define GP2TGL_TGL1_TGL                GPTGL_TGL1_TGL
/* Toggle Output for port pin  */
#define GP2TGL_TGL2_TGL                GPTGL_TGL2_TGL
/* Toggle Output for port pin  */
#define GP2TGL_TGL3_TGL                GPTGL_TGL3_TGL
/* Toggle Output for port pin  */
#define GP2TGL_TGL4_TGL                GPTGL_TGL4_TGL
/* Toggle Output for port pin  */
#define GP2TGL_TGL5_TGL                GPTGL_TGL5_TGL
/* Toggle Output for port pin  */
#define GP2TGL_TGL6_TGL                GPTGL_TGL6_TGL
/* Toggle Output for port pin  */
#define GP2TGL_TGL7_TGL                GPTGL_TGL7_TGL

/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* GPIO3                                              Base Address 0x40006090 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for GP3CON*/
#define GP3CON_RVAL                    0x0 

/* Masks for bitfields in GP3CON*/
#define GP3CON_CON0_MSK                (0x3 << 0)
#define GP3CON_CON1_MSK                (0x3 << 2)
#define GP3CON_CON2_MSK                (0x3 << 4)
#define GP3CON_CON3_MSK                (0x3 << 6)
#define GP3CON_CON4_MSK                (0x3 << 8)
#define GP3CON_CON5_MSK                (0x3 << 10)
#define GP3CON_CON6_MSK                (0x3 << 12)
#define GP3CON_CON7_MSK                (0x3 << 14)

/* Configuration bits for P3.0  */
#define GP3CON_CON0_GPIO               (0 << 0)
#define GP3CON_CON0_PWMTRIP            (3 << 0)
/* Configuration bits for P3.1  */
#define GP3CON_CON1_GPIO               (0 << 2)
/* Configuration bits for P3.2  */
#define GP3CON_CON2_ADIO8              (0 << 4)
#define GP3CON_CON2_GPIO               (1 << 4)
#define GP3CON_CON2_PWMSYNC            (2 << 4)
#define GP3CON_CON2_SPI0MISO           (3 << 4)
/* Configuration bits for P3.3  */
#define GP3CON_CON3_ADIO9              (0 << 6)
#define GP3CON_CON3_GPIO               (1 << 6)
#define GP3CON_CON3_PWMTRIP            (2 << 6)
#define GP3CON_CON3_SPI0SCLK           (3 << 6)
/* Configuration bits for P3.4  */
#define GP3CON_CON4_ADIO10             (0 << 8)
#define GP3CON_CON4_GPIO               (1 << 8)
/* Configuration bits for P3.5  */
#define GP3CON_CON5_ADIO11             (0 << 10)
#define GP3CON_CON5_GPIO               (1 << 10)
#define GP3CON_CON5_SPI0MOSI           (3 << 10)
/* Configuration bits for P3.6  */
#define GP3CON_CON6_GPIO               (1 << 12)
/* Configuration bits for P3.7  */
#define GP3CON_CON7_GPIO               (1 << 14)
/* Reset Value for GP3OEN*/
#define GP3OEN_RVAL                    0x0 
#define GP3OEN_OEN0_BBA                (*(volatile unsigned long *) 0x420C1280)
#define GP3OEN_OEN1_BBA                (*(volatile unsigned long *) 0x420C1284)
#define GP3OEN_OEN2_BBA                (*(volatile unsigned long *) 0x420C1288)
#define GP3OEN_OEN3_BBA                (*(volatile unsigned long *) 0x420C128C)
#define GP3OEN_OEN4_BBA                (*(volatile unsigned long *) 0x420C1290)
#define GP3OEN_OEN5_BBA                (*(volatile unsigned long *) 0x420C1294)
#define GP3OEN_OEN6_BBA                (*(volatile unsigned long *) 0x420C1298)
#define GP3OEN_OEN7_BBA                (*(volatile unsigned long *) 0x420C129C)

/* Masks for bitfields in GP3OEN*/
#define GP3OEN_OEN0                    GPOEN_OEN0
#define GP3OEN_OEN1                    GPOEN_OEN1
#define GP3OEN_OEN2                    GPOEN_OEN2
#define GP3OEN_OEN3                    GPOEN_OEN3
#define GP3OEN_OEN4                    GPOEN_OEN4
#define GP3OEN_OEN5                    GPOEN_OEN5
#define GP3OEN_OEN6                    GPOEN_OEN6
#define GP3OEN_OEN7                    GPOEN_OEN7

/* Direction for port pin  */
#define GP3OEN_OEN0_IN                 GPOEN_OEN0_IN
#define GP3OEN_OEN0_OUT                GPOEN_OEN0_OUT
/* Direction for port pin  */
#define GP3OEN_OEN1_IN                 GPOEN_OEN1_IN
#define GP3OEN_OEN1_OUT                GPOEN_OEN1_OUT
/* Direction for port pin  */
#define GP3OEN_OEN2_IN                 GPOEN_OEN2_IN
#define GP3OEN_OEN2_OUT                GPOEN_OEN2_OUT
/* Direction for port pin  */
#define GP3OEN_OEN3_IN                 GPOEN_OEN3_IN
#define GP3OEN_OEN3_OUT                GPOEN_OEN3_OUT
/* Direction for port pin  */
#define GP3OEN_OEN4_IN                 GPOEN_OEN4_IN
#define GP3OEN_OEN4_OUT                GPOEN_OEN4_OUT
/* Direction for port pin  */
#define GP3OEN_OEN5_IN                 GPOEN_OEN5_IN
#define GP3OEN_OEN5_OUT                GPOEN_OEN5_OUT
/* Direction for port pin  */
#define GP3OEN_OEN6_IN                 GPOEN_OEN6_IN
#define GP3OEN_OEN6_OUT                GPOEN_OEN6_OUT
/* Direction for port pin  */
#define GP3OEN_OEN7_IN                 GPOEN_OEN7_IN
#define GP3OEN_OEN7_OUT                GPOEN_OEN7_OUT
/* Reset Value for GP3PUL*/
#define GP3PUL_RVAL                    0xFF 
#define GP3PUL_PUL0_BBA                (*(volatile unsigned long *) 0x420C1300)
#define GP3PUL_PUL1_BBA                (*(volatile unsigned long *) 0x420C1304)
#define GP3PUL_PUL2_BBA                (*(volatile unsigned long *) 0x420C1308)
#define GP3PUL_PUL3_BBA                (*(volatile unsigned long *) 0x420C130C)
#define GP3PUL_PUL4_BBA                (*(volatile unsigned long *) 0x420C1310)
#define GP3PUL_PUL5_BBA                (*(volatile unsigned long *) 0x420C1314)
#define GP3PUL_PUL6_BBA                (*(volatile unsigned long *) 0x420C1318)
#define GP3PUL_PUL7_BBA                (*(volatile unsigned long *) 0x420C131C)

/* Masks for bitfields in GP3PUL*/
#define GP3PUL_PUL0                    GPPUL_PUL0
#define GP3PUL_PUL1                    GPPUL_PUL1
#define GP3PUL_PUL2                    GPPUL_PUL2
#define GP3PUL_PUL3                    GPPUL_PUL3
#define GP3PUL_PUL4                    GPPUL_PUL4
#define GP3PUL_PUL5                    GPPUL_PUL5
#define GP3PUL_PUL6                    GPPUL_PUL6
#define GP3PUL_PUL7                    GPPUL_PUL7

/* Reset Value for GP3OCE*/
#define GP3OCE_RVAL                    0x0 
#define GP3OCE_OCE0_BBA                (*(volatile unsigned long *) 0x420C1380)
#define GP3OCE_OCE1_BBA                (*(volatile unsigned long *) 0x420C1384)
#define GP3OCE_OCE2_BBA                (*(volatile unsigned long *) 0x420C1388)
#define GP3OCE_OCE3_BBA                (*(volatile unsigned long *) 0x420C138C)
#define GP3OCE_OCE4_BBA                (*(volatile unsigned long *) 0x420C1390)
#define GP3OCE_OCE5_BBA                (*(volatile unsigned long *) 0x420C1394)
#define GP3OCE_OCE6_BBA                (*(volatile unsigned long *) 0x420C1398)
#define GP3OCE_OCE7_BBA                (*(volatile unsigned long *) 0x420C139C)

/* Masks for bitfields in GP3OCE*/
#define GP3OCE_OCE0                    GPOCE_OCE0
#define GP3OCE_OCE1                    GPOCE_OCE1
#define GP3OCE_OCE2                    GPOCE_OCE2
#define GP3OCE_OCE3                    GPOCE_OCE3
#define GP3OCE_OCE4                    GPOCE_OCE4
#define GP3OCE_OCE5                    GPOCE_OCE5
#define GP3OCE_OCE6                    GPOCE_OCE6
#define GP3OCE_OCE7                    GPOCE_OCE7

/* Reset Value for GP3IN*/
#define GP3IN_RVAL                     0xFF 
#define GP3IN_IN0_BBA                  (*(volatile unsigned long *) 0x420C1480)
#define GP3IN_IN1_BBA                  (*(volatile unsigned long *) 0x420C1484)
#define GP3IN_IN2_BBA                  (*(volatile unsigned long *) 0x420C1488)
#define GP3IN_IN3_BBA                  (*(volatile unsigned long *) 0x420C148C)
#define GP3IN_IN4_BBA                  (*(volatile unsigned long *) 0x420C1490)
#define GP3IN_IN5_BBA                  (*(volatile unsigned long *) 0x420C1494)
#define GP3IN_IN6_BBA                  (*(volatile unsigned long *) 0x420C1498)
#define GP3IN_IN7_BBA                  (*(volatile unsigned long *) 0x420C149C)

/* Masks for bitfields in GP3IN*/
#define GP3IN_IN0                      GPIN_IN0
#define GP3IN_IN1                      GPIN_IN1
#define GP3IN_IN2                      GPIN_IN2
#define GP3IN_IN3                      GPIN_IN3
#define GP3IN_IN4                      GPIN_IN4
#define GP3IN_IN5                      GPIN_IN5
#define GP3IN_IN6                      GPIN_IN6
#define GP3IN_IN7                      GPIN_IN7

/* Input for port pin  */
#define GP3IN_IN0_LOW                  GPIN_IN0_LOW
#define GP3IN_IN0_HIGH                 GPIN_IN0_HIGH
/* Input for port pin  */
#define GP3IN_IN1_LOW                  GPIN_IN1_LOW
#define GP3IN_IN1_HIGH                 GPIN_IN1_HIGH
/* Input for port pin  */
#define GP3IN_IN2_LOW                  GPIN_IN2_LOW
#define GP3IN_IN2_HIGH                 GPIN_IN2_HIGH
/* Input for port pin  */
#define GP3IN_IN3_LOW                  GPIN_IN3_LOW
#define GP3IN_IN3_HIGH                 GPIN_IN3_HIGH
/* Input for port pin  */
#define GP3IN_IN4_LOW                  GPIN_IN4_LOW
#define GP3IN_IN4_HIGH                 GPIN_IN4_HIGH
/* Input for port pin  */
#define GP3IN_IN5_LOW                  GPIN_IN5_LOW
#define GP3IN_IN5_HIGH                 GPIN_IN5_HIGH
/* Input for port pin  */
#define GP3IN_IN6_LOW                  GPIN_IN6_LOW
#define GP3IN_IN6_HIGH                 GPIN_IN6_HIGH
/* Input for port pin  */
#define GP3IN_IN7_LOW                  GPIN_IN7_LOW
#define GP3IN_IN7_HIGH                 GPIN_IN7_HIGH
/* Reset Value for GP3OUT*/
#define GP3OUT_RVAL                    0x0 
#define GP3OUT_OUT0_BBA                (*(volatile unsigned long *) 0x420C1500)
#define GP3OUT_OUT1_BBA                (*(volatile unsigned long *) 0x420C1504)
#define GP3OUT_OUT2_BBA                (*(volatile unsigned long *) 0x420C1508)
#define GP3OUT_OUT3_BBA                (*(volatile unsigned long *) 0x420C150C)
#define GP3OUT_OUT4_BBA                (*(volatile unsigned long *) 0x420C1510)
#define GP3OUT_OUT5_BBA                (*(volatile unsigned long *) 0x420C1514)
#define GP3OUT_OUT6_BBA                (*(volatile unsigned long *) 0x420C1518)
#define GP3OUT_OUT7_BBA                (*(volatile unsigned long *) 0x420C151C)

/* Masks for bitfields in GP3OUT*/
#define GP3OUT_OUT0                    GPOUT_OUT0
#define GP3OUT_OUT1                    GPOUT_OUT1
#define GP3OUT_OUT2                    GPOUT_OUT2
#define GP3OUT_OUT3                    GPOUT_OUT3
#define GP3OUT_OUT4                    GPOUT_OUT4
#define GP3OUT_OUT5                    GPOUT_OUT5
#define GP3OUT_OUT6                    GPOUT_OUT6
#define GP3OUT_OUT7                    GPOUT_OUT7

/* Output for port pin  */
#define GP3OUT_OUT0_LOW                GPOUT_OUT0_LOW
#define GP3OUT_OUT0_HIGH               GPOUT_OUT0_HIGH
/* Output for port pin  */
#define GP3OUT_OUT1_LOW                GPOUT_OUT1_LOW
#define GP3OUT_OUT1_HIGH               GPOUT_OUT1_HIGH
/* Output for port pin  */
#define GP3OUT_OUT2_LOW                GPOUT_OUT2_LOW
#define GP3OUT_OUT2_HIGH               GPOUT_OUT2_HIGH
/* Output for port pin  */
#define GP3OUT_OUT3_LOW                GPOUT_OUT3_LOW
#define GP3OUT_OUT3_HIGH               GPOUT_OUT3_HIGH
/* Output for port pin  */
#define GP3OUT_OUT4_LOW                GPOUT_OUT4_LOW
#define GP3OUT_OUT4_HIGH               GPOUT_OUT4_HIGH
/* Output for port pin  */
#define GP3OUT_OUT5_LOW                GPOUT_OUT5_LOW
#define GP3OUT_OUT5_HIGH               GPOUT_OUT5_HIGH
/* Output for port pin  */
#define GP3OUT_OUT6_LOW                GPOUT_OUT6_LOW
#define GP3OUT_OUT6_HIGH               GPOUT_OUT6_HIGH
/* Output for port pin  */
#define GP3OUT_OUT7_LOW                GPOUT_OUT7_LOW
#define GP3OUT_OUT7_HIGH               GPOUT_OUT7_HIGH
/* Reset Value for GP3SET*/
#define GP3SET_RVAL                    0x0 
#define GP3SET_SET0_BBA                (*(volatile unsigned long *) 0x420C1580)
#define GP3SET_SET1_BBA                (*(volatile unsigned long *) 0x420C1584)
#define GP3SET_SET2_BBA                (*(volatile unsigned long *) 0x420C1588)
#define GP3SET_SET3_BBA                (*(volatile unsigned long *) 0x420C158C)
#define GP3SET_SET4_BBA                (*(volatile unsigned long *) 0x420C1590)
#define GP3SET_SET5_BBA                (*(volatile unsigned long *) 0x420C1594)
#define GP3SET_SET6_BBA                (*(volatile unsigned long *) 0x420C1598)
#define GP3SET_SET7_BBA                (*(volatile unsigned long *) 0x420C159C)

/* Masks for bitfields in GP3SET*/
#define GP3SET_SET0                    GPSET_SET0
#define GP3SET_SET1                    GPSET_SET1
#define GP3SET_SET2                    GPSET_SET2
#define GP3SET_SET3                    GPSET_SET3
#define GP3SET_SET4                    GPSET_SET4
#define GP3SET_SET5                    GPSET_SET5
#define GP3SET_SET6                    GPSET_SET6
#define GP3SET_SET7                    GPSET_SET7

/* Set Output High for port pin  */
#define GP3SET_SET0_SET                GPSET_SET0_SET
/* Set Output High for port pin  */
#define GP3SET_SET1_SET                GPSET_SET1_SET
/* Set Output High for port pin  */
#define GP3SET_SET2_SET                GPSET_SET2_SET
/* Set Output High for port pin  */
#define GP3SET_SET3_SET                GPSET_SET3_SET
/* Set Output High for port pin  */
#define GP3SET_SET4_SET                GPSET_SET4_SET
/* Set Output High for port pin  */
#define GP3SET_SET5_SET                GPSET_SET5_SET
/* Set Output High for port pin  */
#define GP3SET_SET6_SET                GPSET_SET6_SET
/* Set Output High for port pin  */
#define GP3SET_SET7_SET                GPSET_SET7_SET
/* Reset Value for GP3CLR*/
#define GP3CLR_RVAL                    0x0 
#define GP3CLR_CLR0_BBA                (*(volatile unsigned long *) 0x420C1600)
#define GP3CLR_CLR1_BBA                (*(volatile unsigned long *) 0x420C1604)
#define GP3CLR_CLR2_BBA                (*(volatile unsigned long *) 0x420C1608)
#define GP3CLR_CLR3_BBA                (*(volatile unsigned long *) 0x420C160C)
#define GP3CLR_CLR4_BBA                (*(volatile unsigned long *) 0x420C1610)
#define GP3CLR_CLR5_BBA                (*(volatile unsigned long *) 0x420C1614)
#define GP3CLR_CLR6_BBA                (*(volatile unsigned long *) 0x420C1618)
#define GP3CLR_CLR7_BBA                (*(volatile unsigned long *) 0x420C161C)

/* Masks for bitfields in GP3CLR*/
#define GP3CLR_CLR0                    GPCLR_CLR0
#define GP3CLR_CLR1                    GPCLR_CLR1
#define GP3CLR_CLR2                    GPCLR_CLR2
#define GP3CLR_CLR3                    GPCLR_CLR3
#define GP3CLR_CLR4                    GPCLR_CLR4
#define GP3CLR_CLR5                    GPCLR_CLR5
#define GP3CLR_CLR6                    GPCLR_CLR6
#define GP3CLR_CLR7                    GPCLR_CLR7

/* Set Output Low for port pin  */
#define GP3CLR_CLR0_CLR                GPCLR_CLR0_CLR
/* Set Output Low for port pin  */
#define GP3CLR_CLR1_CLR                GPCLR_CLR1_CLR
/* Set Output Low for port pin  */
#define GP3CLR_CLR2_CLR                GPCLR_CLR2_CLR
/* Set Output Low for port pin  */
#define GP3CLR_CLR3_CLR                GPCLR_CLR3_CLR
/* Set Output Low for port pin  */
#define GP3CLR_CLR4_CLR                GPCLR_CLR4_CLR
/* Set Output Low for port pin  */
#define GP3CLR_CLR5_CLR                GPCLR_CLR5_CLR
/* Set Output Low for port pin  */
#define GP3CLR_CLR6_CLR                GPCLR_CLR6_CLR
/* Set Output Low for port pin  */
#define GP3CLR_CLR7_CLR                GPCLR_CLR7_CLR
/* Reset Value for GP3TGL*/
#define GP3TGL_RVAL                    0x0 
#define GP3TGL_TGL0_BBA                (*(volatile unsigned long *) 0x420C1680)
#define GP3TGL_TGL1_BBA                (*(volatile unsigned long *) 0x420C1684)
#define GP3TGL_TGL2_BBA                (*(volatile unsigned long *) 0x420C1688)
#define GP3TGL_TGL3_BBA                (*(volatile unsigned long *) 0x420C168C)
#define GP3TGL_TGL4_BBA                (*(volatile unsigned long *) 0x420C1690)
#define GP3TGL_TGL5_BBA                (*(volatile unsigned long *) 0x420C1694)
#define GP3TGL_TGL6_BBA                (*(volatile unsigned long *) 0x420C1698)
#define GP3TGL_TGL7_BBA                (*(volatile unsigned long *) 0x420C169C)

/* Masks for bitfields in GP3TGL*/
#define GP3TGL_TGL0                    GPTGL_TGL0
#define GP3TGL_TGL1                    GPTGL_TGL1
#define GP3TGL_TGL2                    GPTGL_TGL2
#define GP3TGL_TGL3                    GPTGL_TGL3
#define GP3TGL_TGL4                    GPTGL_TGL4
#define GP3TGL_TGL5                    GPTGL_TGL5
#define GP3TGL_TGL6                    GPTGL_TGL6
#define GP3TGL_TGL7                    GPTGL_TGL7

/* Toggle Output for port pin  */
#define GP3TGL_TGL0_TGL                GPTGL_TGL0_TGL
/* Toggle Output for port pin  */
#define GP3TGL_TGL1_TGL                GPTGL_TGL1_TGL
/* Toggle Output for port pin  */
#define GP3TGL_TGL2_TGL                GPTGL_TGL2_TGL
/* Toggle Output for port pin  */
#define GP3TGL_TGL3_TGL                GPTGL_TGL3_TGL
/* Toggle Output for port pin  */
#define GP3TGL_TGL4_TGL                GPTGL_TGL4_TGL
/* Toggle Output for port pin  */
#define GP3TGL_TGL5_TGL                GPTGL_TGL5_TGL
/* Toggle Output for port pin  */
#define GP3TGL_TGL6_TGL                GPTGL_TGL6_TGL
/* Toggle Output for port pin  */
#define GP3TGL_TGL7_TGL                GPTGL_TGL7_TGL

/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* GPIO4                                              Base Address 0x400060C0 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for GP4CON*/
#define GP4CON_RVAL                    0x0 

/* Masks for bitfields in GP4CON*/
#define GP4CON_CON0_MSK                (0x3 << 0)
#define GP4CON_CON1_MSK                (0x3 << 2)
#define GP4CON_CON2_MSK                (0x3 << 4)
#define GP4CON_CON3_MSK                (0x3 << 6)
#define GP4CON_CON4_MSK                (0x3 << 8)
#define GP4CON_CON5_MSK                (0x3 << 10)
#define GP4CON_CON6_MSK                (0x3 << 12)
#define GP4CON_CON7_MSK                (0x3 << 14)

/* Configuration bits for P4.0  */
#define GP4CON_CON0_ADIO0              (0 << 0)
#define GP4CON_CON0_GPIO               (1 << 0)
#define GP4CON_CON0_PWM0               (2 << 0)
/* Configuration bits for P4.1  */
#define GP4CON_CON1_ADIO1              (0 << 2)
#define GP4CON_CON1_GPIO               (1 << 2)
#define GP4CON_CON1_PWM1               (2 << 2)
/* Configuration bits for P4.2  */
#define GP4CON_CON2_ADIO2              (0 << 4)
#define GP4CON_CON2_GPIO               (1 << 4)
#define GP4CON_CON2_PWM2               (2 << 4)
#define GP4CON_CON2_SPI0CS             (3 << 4)
/* Configuration bits for P4.3  */
#define GP4CON_CON3_ADIO3              (0 << 6)
#define GP4CON_CON3_GPIO               (1 << 6)
#define GP4CON_CON3_PWM3               (2 << 6)
/* Configuration bits for P4.4  */
#define GP4CON_CON4_ADIO4              (0 << 8)
#define GP4CON_CON4_GPIO               (1 << 8)
#define GP4CON_CON4_PWM4               (2 << 8)
/* Configuration bits for P4.5  */
#define GP4CON_CON5_ADIO5              (0 << 10)
#define GP4CON_CON5_GPIO               (1 << 10)
#define GP4CON_CON5_PWM5               (2 << 10)
/* Configuration bits for P4.6  */
#define GP4CON_CON6_ADIO6              (0 << 12)
#define GP4CON_CON6_GPIO               (1 << 12)
#define GP4CON_CON6_PWM6               (2 << 12)
/* Configuration bits for P4.7  */
#define GP4CON_CON7_ADIO7              (0 << 14)
#define GP4CON_CON7_GPIO               (1 << 14)
#define GP4CON_CON7_PWM7               (2 << 14)
/* Reset Value for GP4OEN*/
#define GP4OEN_RVAL                    0x0 
#define GP4OEN_OEN0_BBA                (*(volatile unsigned long *) 0x420C1880)
#define GP4OEN_OEN1_BBA                (*(volatile unsigned long *) 0x420C1884)
#define GP4OEN_OEN2_BBA                (*(volatile unsigned long *) 0x420C1888)
#define GP4OEN_OEN3_BBA                (*(volatile unsigned long *) 0x420C188C)
#define GP4OEN_OEN4_BBA                (*(volatile unsigned long *) 0x420C1890)
#define GP4OEN_OEN5_BBA                (*(volatile unsigned long *) 0x420C1894)
#define GP4OEN_OEN6_BBA                (*(volatile unsigned long *) 0x420C1898)
#define GP4OEN_OEN7_BBA                (*(volatile unsigned long *) 0x420C189C)

/* Masks for bitfields in GP4OEN*/
#define GP4OEN_OEN0                    GPOEN_OEN0
#define GP4OEN_OEN1                    GPOEN_OEN1
#define GP4OEN_OEN2                    GPOEN_OEN2
#define GP4OEN_OEN3                    GPOEN_OEN3
#define GP4OEN_OEN4                    GPOEN_OEN4
#define GP4OEN_OEN5                    GPOEN_OEN5
#define GP4OEN_OEN6                    GPOEN_OEN6
#define GP4OEN_OEN7                    GPOEN_OEN7

/* Direction for port pin  */
#define GP4OEN_OEN0_IN                 GPOEN_OEN0_IN
#define GP4OEN_OEN0_OUT                GPOEN_OEN0_OUT
/* Direction for port pin  */
#define GP4OEN_OEN1_IN                 GPOEN_OEN1_IN
#define GP4OEN_OEN1_OUT                GPOEN_OEN1_OUT
/* Direction for port pin  */
#define GP4OEN_OEN2_IN                 GPOEN_OEN2_IN
#define GP4OEN_OEN2_OUT                GPOEN_OEN2_OUT
/* Direction for port pin  */
#define GP4OEN_OEN3_IN                 GPOEN_OEN3_IN
#define GP4OEN_OEN3_OUT                GPOEN_OEN3_OUT
/* Direction for port pin  */
#define GP4OEN_OEN4_IN                 GPOEN_OEN4_IN
#define GP4OEN_OEN4_OUT                GPOEN_OEN4_OUT
/* Direction for port pin  */
#define GP4OEN_OEN5_IN                 GPOEN_OEN5_IN
#define GP4OEN_OEN5_OUT                GPOEN_OEN5_OUT
/* Direction for port pin  */
#define GP4OEN_OEN6_IN                 GPOEN_OEN6_IN
#define GP4OEN_OEN6_OUT                GPOEN_OEN6_OUT
/* Direction for port pin  */
#define GP4OEN_OEN7_IN                 GPOEN_OEN7_IN
#define GP4OEN_OEN7_OUT                GPOEN_OEN7_OUT
/* Reset Value for GP4PUL*/
#define GP4PUL_RVAL                    0xFF 
#define GP4PUL_PUL0_BBA                (*(volatile unsigned long *) 0x420C1900)
#define GP4PUL_PUL1_BBA                (*(volatile unsigned long *) 0x420C1904)
#define GP4PUL_PUL2_BBA                (*(volatile unsigned long *) 0x420C1908)
#define GP4PUL_PUL3_BBA                (*(volatile unsigned long *) 0x420C190C)
#define GP4PUL_PUL4_BBA                (*(volatile unsigned long *) 0x420C1910)
#define GP4PUL_PUL5_BBA                (*(volatile unsigned long *) 0x420C1914)
#define GP4PUL_PUL6_BBA                (*(volatile unsigned long *) 0x420C1918)
#define GP4PUL_PUL7_BBA                (*(volatile unsigned long *) 0x420C191C)

/* Masks for bitfields in GP4PUL*/
#define GP4PUL_PUL0                    GPPUL_PUL0
#define GP4PUL_PUL1                    GPPUL_PUL1
#define GP4PUL_PUL2                    GPPUL_PUL2
#define GP4PUL_PUL3                    GPPUL_PUL3
#define GP4PUL_PUL4                    GPPUL_PUL4
#define GP4PUL_PUL5                    GPPUL_PUL5
#define GP4PUL_PUL6                    GPPUL_PUL6
#define GP4PUL_PUL7                    GPPUL_PUL7

/* Reset Value for GP4OCE*/
#define GP4OCE_RVAL                    0x0 
#define GP4OCE_OCE0_BBA                (*(volatile unsigned long *) 0x420C1980)
#define GP4OCE_OCE1_BBA                (*(volatile unsigned long *) 0x420C1984)
#define GP4OCE_OCE2_BBA                (*(volatile unsigned long *) 0x420C1988)
#define GP4OCE_OCE3_BBA                (*(volatile unsigned long *) 0x420C198C)
#define GP4OCE_OCE4_BBA                (*(volatile unsigned long *) 0x420C1990)
#define GP4OCE_OCE5_BBA                (*(volatile unsigned long *) 0x420C1994)
#define GP4OCE_OCE6_BBA                (*(volatile unsigned long *) 0x420C1998)
#define GP4OCE_OCE7_BBA                (*(volatile unsigned long *) 0x420C199C)

/* Masks for bitfields in GP4OCE*/
#define GP4OCE_OCE0                    GPOCE_OCE0
#define GP4OCE_OCE1                    GPOCE_OCE1
#define GP4OCE_OCE2                    GPOCE_OCE2
#define GP4OCE_OCE3                    GPOCE_OCE3
#define GP4OCE_OCE4                    GPOCE_OCE4
#define GP4OCE_OCE5                    GPOCE_OCE5
#define GP4OCE_OCE6                    GPOCE_OCE6
#define GP4OCE_OCE7                    GPOCE_OCE7

/* Reset Value for GP4IN*/
#define GP4IN_RVAL                     0xFF 
#define GP4IN_IN0_BBA                  (*(volatile unsigned long *) 0x420C1A80)
#define GP4IN_IN1_BBA                  (*(volatile unsigned long *) 0x420C1A84)
#define GP4IN_IN2_BBA                  (*(volatile unsigned long *) 0x420C1A88)
#define GP4IN_IN3_BBA                  (*(volatile unsigned long *) 0x420C1A8C)
#define GP4IN_IN4_BBA                  (*(volatile unsigned long *) 0x420C1A90)
#define GP4IN_IN5_BBA                  (*(volatile unsigned long *) 0x420C1A94)
#define GP4IN_IN6_BBA                  (*(volatile unsigned long *) 0x420C1A98)
#define GP4IN_IN7_BBA                  (*(volatile unsigned long *) 0x420C1A9C)

/* Masks for bitfields in GP4IN*/
#define GP4IN_IN0                      GPIN_IN0
#define GP4IN_IN1                      GPIN_IN1
#define GP4IN_IN2                      GPIN_IN2
#define GP4IN_IN3                      GPIN_IN3
#define GP4IN_IN4                      GPIN_IN4
#define GP4IN_IN5                      GPIN_IN5
#define GP4IN_IN6                      GPIN_IN6
#define GP4IN_IN7                      GPIN_IN7

/* Input for port pin  */
#define GP4IN_IN0_LOW                  GPIN_IN0_LOW
#define GP4IN_IN0_HIGH                 GPIN_IN0_HIGH
/* Input for port pin  */
#define GP4IN_IN1_LOW                  GPIN_IN1_LOW
#define GP4IN_IN1_HIGH                 GPIN_IN1_HIGH
/* Input for port pin  */
#define GP4IN_IN2_LOW                  GPIN_IN2_LOW
#define GP4IN_IN2_HIGH                 GPIN_IN2_HIGH
/* Input for port pin  */
#define GP4IN_IN3_LOW                  GPIN_IN3_LOW
#define GP4IN_IN3_HIGH                 GPIN_IN3_HIGH
/* Input for port pin  */
#define GP4IN_IN4_LOW                  GPIN_IN4_LOW
#define GP4IN_IN4_HIGH                 GPIN_IN4_HIGH
/* Input for port pin  */
#define GP4IN_IN5_LOW                  GPIN_IN5_LOW
#define GP4IN_IN5_HIGH                 GPIN_IN5_HIGH
/* Input for port pin  */
#define GP4IN_IN6_LOW                  GPIN_IN6_LOW
#define GP4IN_IN6_HIGH                 GPIN_IN6_HIGH
/* Input for port pin  */
#define GP4IN_IN7_LOW                  GPIN_IN7_LOW
#define GP4IN_IN7_HIGH                 GPIN_IN7_HIGH
/* Reset Value for GP4OUT*/
#define GP4OUT_RVAL                    0x0 
#define GP4OUT_OUT0_BBA                (*(volatile unsigned long *) 0x420C1B00)
#define GP4OUT_OUT1_BBA                (*(volatile unsigned long *) 0x420C1B04)
#define GP4OUT_OUT2_BBA                (*(volatile unsigned long *) 0x420C1B08)
#define GP4OUT_OUT3_BBA                (*(volatile unsigned long *) 0x420C1B0C)
#define GP4OUT_OUT4_BBA                (*(volatile unsigned long *) 0x420C1B10)
#define GP4OUT_OUT5_BBA                (*(volatile unsigned long *) 0x420C1B14)
#define GP4OUT_OUT6_BBA                (*(volatile unsigned long *) 0x420C1B18)
#define GP4OUT_OUT7_BBA                (*(volatile unsigned long *) 0x420C1B1C)

/* Masks for bitfields in GP4OUT*/
#define GP4OUT_OUT0                    GPOUT_OUT0
#define GP4OUT_OUT1                    GPOUT_OUT1
#define GP4OUT_OUT2                    GPOUT_OUT2
#define GP4OUT_OUT3                    GPOUT_OUT3
#define GP4OUT_OUT4                    GPOUT_OUT4
#define GP4OUT_OUT5                    GPOUT_OUT5
#define GP4OUT_OUT6                    GPOUT_OUT6
#define GP4OUT_OUT7                    GPOUT_OUT7

/* Output for port pin  */
#define GP4OUT_OUT0_LOW                GPOUT_OUT0_LOW
#define GP4OUT_OUT0_HIGH               GPOUT_OUT0_HIGH
/* Output for port pin  */
#define GP4OUT_OUT1_LOW                GPOUT_OUT1_LOW
#define GP4OUT_OUT1_HIGH               GPOUT_OUT1_HIGH
/* Output for port pin  */
#define GP4OUT_OUT2_LOW                GPOUT_OUT2_LOW
#define GP4OUT_OUT2_HIGH               GPOUT_OUT2_HIGH
/* Output for port pin  */
#define GP4OUT_OUT3_LOW                GPOUT_OUT3_LOW
#define GP4OUT_OUT3_HIGH               GPOUT_OUT3_HIGH
/* Output for port pin  */
#define GP4OUT_OUT4_LOW                GPOUT_OUT4_LOW
#define GP4OUT_OUT4_HIGH               GPOUT_OUT4_HIGH
/* Output for port pin  */
#define GP4OUT_OUT5_LOW                GPOUT_OUT5_LOW
#define GP4OUT_OUT5_HIGH               GPOUT_OUT5_HIGH
/* Output for port pin  */
#define GP4OUT_OUT6_LOW                GPOUT_OUT6_LOW
#define GP4OUT_OUT6_HIGH               GPOUT_OUT6_HIGH
/* Output for port pin  */
#define GP4OUT_OUT7_LOW                GPOUT_OUT7_LOW
#define GP4OUT_OUT7_HIGH               GPOUT_OUT7_HIGH
/* Reset Value for GP4SET*/
#define GP4SET_RVAL                    0x0 
#define GP4SET_SET0_BBA                (*(volatile unsigned long *) 0x420C1B80)
#define GP4SET_SET1_BBA                (*(volatile unsigned long *) 0x420C1B84)
#define GP4SET_SET2_BBA                (*(volatile unsigned long *) 0x420C1B88)
#define GP4SET_SET3_BBA                (*(volatile unsigned long *) 0x420C1B8C)
#define GP4SET_SET4_BBA                (*(volatile unsigned long *) 0x420C1B90)
#define GP4SET_SET5_BBA                (*(volatile unsigned long *) 0x420C1B94)
#define GP4SET_SET6_BBA                (*(volatile unsigned long *) 0x420C1B98)
#define GP4SET_SET7_BBA                (*(volatile unsigned long *) 0x420C1B9C)

/* Masks for bitfields in GP4SET*/
#define GP4SET_SET0                    GPSET_SET0
#define GP4SET_SET1                    GPSET_SET1
#define GP4SET_SET2                    GPSET_SET2
#define GP4SET_SET3                    GPSET_SET3
#define GP4SET_SET4                    GPSET_SET4
#define GP4SET_SET5                    GPSET_SET5
#define GP4SET_SET6                    GPSET_SET6
#define GP4SET_SET7                    GPSET_SET7

/* Set Output High for port pin  */
#define GP4SET_SET0_SET                GPSET_SET0_SET
/* Set Output High for port pin  */
#define GP4SET_SET1_SET                GPSET_SET1_SET
/* Set Output High for port pin  */
#define GP4SET_SET2_SET                GPSET_SET2_SET
/* Set Output High for port pin  */
#define GP4SET_SET3_SET                GPSET_SET3_SET
/* Set Output High for port pin  */
#define GP4SET_SET4_SET                GPSET_SET4_SET
/* Set Output High for port pin  */
#define GP4SET_SET5_SET                GPSET_SET5_SET
/* Set Output High for port pin  */
#define GP4SET_SET6_SET                GPSET_SET6_SET
/* Set Output High for port pin  */
#define GP4SET_SET7_SET                GPSET_SET7_SET
/* Reset Value for GP4CLR*/
#define GP4CLR_RVAL                    0x0 
#define GP4CLR_CLR0_BBA                (*(volatile unsigned long *) 0x420C1C00)
#define GP4CLR_CLR1_BBA                (*(volatile unsigned long *) 0x420C1C04)
#define GP4CLR_CLR2_BBA                (*(volatile unsigned long *) 0x420C1C08)
#define GP4CLR_CLR3_BBA                (*(volatile unsigned long *) 0x420C1C0C)
#define GP4CLR_CLR4_BBA                (*(volatile unsigned long *) 0x420C1C10)
#define GP4CLR_CLR5_BBA                (*(volatile unsigned long *) 0x420C1C14)
#define GP4CLR_CLR6_BBA                (*(volatile unsigned long *) 0x420C1C18)
#define GP4CLR_CLR7_BBA                (*(volatile unsigned long *) 0x420C1C1C)

/* Masks for bitfields in GP4CLR*/
#define GP4CLR_CLR0                    GPCLR_CLR0
#define GP4CLR_CLR1                    GPCLR_CLR1
#define GP4CLR_CLR2                    GPCLR_CLR2
#define GP4CLR_CLR3                    GPCLR_CLR3
#define GP4CLR_CLR4                    GPCLR_CLR4
#define GP4CLR_CLR5                    GPCLR_CLR5
#define GP4CLR_CLR6                    GPCLR_CLR6
#define GP4CLR_CLR7                    GPCLR_CLR7

/* Set Output Low for port pin  */
#define GP4CLR_CLR0_CLR                GPCLR_CLR0_CLR
/* Set Output Low for port pin  */
#define GP4CLR_CLR1_CLR                GPCLR_CLR1_CLR
/* Set Output Low for port pin  */
#define GP4CLR_CLR2_CLR                GPCLR_CLR2_CLR
/* Set Output Low for port pin  */
#define GP4CLR_CLR3_CLR                GPCLR_CLR3_CLR
/* Set Output Low for port pin  */
#define GP4CLR_CLR4_CLR                GPCLR_CLR4_CLR
/* Set Output Low for port pin  */
#define GP4CLR_CLR5_CLR                GPCLR_CLR5_CLR
/* Set Output Low for port pin  */
#define GP4CLR_CLR6_CLR                GPCLR_CLR6_CLR
/* Set Output Low for port pin  */
#define GP4CLR_CLR7_CLR                GPCLR_CLR7_CLR
/* Reset Value for GP4TGL*/
#define GP4TGL_RVAL                    0x0 
#define GP4TGL_TGL0_BBA                (*(volatile unsigned long *) 0x420C1C80)
#define GP4TGL_TGL1_BBA                (*(volatile unsigned long *) 0x420C1C84)
#define GP4TGL_TGL2_BBA                (*(volatile unsigned long *) 0x420C1C88)
#define GP4TGL_TGL3_BBA                (*(volatile unsigned long *) 0x420C1C8C)
#define GP4TGL_TGL4_BBA                (*(volatile unsigned long *) 0x420C1C90)
#define GP4TGL_TGL5_BBA                (*(volatile unsigned long *) 0x420C1C94)
#define GP4TGL_TGL6_BBA                (*(volatile unsigned long *) 0x420C1C98)
#define GP4TGL_TGL7_BBA                (*(volatile unsigned long *) 0x420C1C9C)

/* Masks for bitfields in GP4TGL*/
#define GP4TGL_TGL0                    GPTGL_TGL0
#define GP4TGL_TGL1                    GPTGL_TGL1
#define GP4TGL_TGL2                    GPTGL_TGL2
#define GP4TGL_TGL3                    GPTGL_TGL3
#define GP4TGL_TGL4                    GPTGL_TGL4
#define GP4TGL_TGL5                    GPTGL_TGL5
#define GP4TGL_TGL6                    GPTGL_TGL6
#define GP4TGL_TGL7                    GPTGL_TGL7

/* Toggle Output for port pin  */
#define GP4TGL_TGL0_TGL                GPTGL_TGL0_TGL
/* Toggle Output for port pin  */
#define GP4TGL_TGL1_TGL                GPTGL_TGL1_TGL
/* Toggle Output for port pin  */
#define GP4TGL_TGL2_TGL                GPTGL_TGL2_TGL
/* Toggle Output for port pin  */
#define GP4TGL_TGL3_TGL                GPTGL_TGL3_TGL
/* Toggle Output for port pin  */
#define GP4TGL_TGL4_TGL                GPTGL_TGL4_TGL
/* Toggle Output for port pin  */
#define GP4TGL_TGL5_TGL                GPTGL_TGL5_TGL
/* Toggle Output for port pin  */
#define GP4TGL_TGL6_TGL                GPTGL_TGL6_TGL
/* Toggle Output for port pin  */
#define GP4TGL_TGL7_TGL                GPTGL_TGL7_TGL

/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Analog ITF                                         Base Address 0x40008800 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for RFTST*/
#define RFTST_RVAL                     0x0 
#define RFTST_GPX_BBA                  (*(volatile unsigned long *) 0x42110480)
#define RFTST_SPI0_BBA                 (*(volatile unsigned long *) 0x42110484)
#define RFTST_AN0_BBA                  (*(volatile unsigned long *) 0x42110488)
#define RFTST_AN1_BBA                  (*(volatile unsigned long *) 0x4211048C)

/* Masks for bitfields in RFTST*/
#define RFTST_GPX                      (0x1 << 0)
#define RFTST_SPI0                     (0x1 << 1)
#define RFTST_AN0                      (0x1 << 2)
#define RFTST_AN1                      (0x1 << 3)
#define RFTST_DIR_MSK                  (0x7FF << 5)

/* Masks for bitfields in DMACHNL*/
#define DMACHNL_SPI1TX                 (0x1 << 0)
#define DMACHNL_SPI1RX                 (0x1 << 1)
#define DMACHNL_UARTTX                 (0x1 << 2)
#define DMACHNL_UARTRX                 (0x1 << 3)
#define DMACHNL_I2CSTX                 (0x1 << 4)
#define DMACHNL_I2CSRX                 (0x1 << 5)
#define DMACHNL_I2CMTX                 (0x1 << 6)
#define DMACHNL_I2CMRX                 (0x1 << 7)
#define DMACHNL_ADC                    (0x1 << 11)
#define DMACHNL_SPI0TX                 (0x1 << 12)
#define DMACHNL_SPI0RX                 (0x1 << 13)


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* uDMA                                               Base Address 0x40010000 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for DMASTA*/
#define DMASTA_RVAL                    0xD0000 
#define DMASTA_ENABLE_BBA              (*(volatile unsigned long *) 0x42200000)

/* Masks for bitfields in DMASTA*/
#define DMASTA_ENABLE                  (0x1 << 0)
#define DMASTA_STATE_MSK               (0xF << 4)
#define DMASTA_CHNLSMINUS1_MSK         (0x1F << 16)

/* Current state of the control state machine.  */
#define DMASTA_STATE_IDLE              (0 << 4) /* Idle                     */
#define DMASTA_STATE_RDCHNLDATA        (1 << 4) /* Reading channel controller data */
#define DMASTA_STATE_RDSRCENDPTR       (2 << 4) /* Reading source data end pointer */
#define DMASTA_STATE_RDDSTENDPTR       (3 << 4) /* Reading destination data end pointer */
#define DMASTA_STATE_RDSRCDATA         (4 << 4) /* Reading source data      */
#define DMASTA_STATE_WRDSTDATA         (5 << 4) /* Writing destination data */
#define DMASTA_STATE_WAITDMAREQCLR     (6 << 4) /* Waiting for DMA request to clear */
#define DMASTA_STATE_WRCHNLDATA        (7 << 4) /* Writing channel controller data */
#define DMASTA_STATE_STALLED           (8 << 4) /* Stalled                  */
#define DMASTA_STATE_DONE              (9 << 4) /* Done                     */
#define DMASTA_STATE_SCATRGATHR        (10 << 4) /* Peripheral scatter-gather transition */
/* Number of available DMA channels minus one.  */
#define DMASTA_CHNLSMINUS1_FOURTEENCHNLS (13 << 16) /* Controller configured to use 14 DMA channels */
#define DMASTA_CHNLSMINUS1_TWELVECHNLS (11 << 16) /* Controller configured to use 12 DMA channels */
/* Reset Value for DMACFG*/
#define DMACFG_RVAL                    0x0 
#define DMACFG_ENABLE_BBA              (*(volatile unsigned long *) 0x42200080)

/* Masks for bitfields in DMACFG*/
#define DMACFG_ENABLE                  (0x1 << 0)

/* Reset Value for DMAPDBPTR*/
#define DMAPDBPTR_RVAL                 0x0 

/* Masks for bitfields in DMAPDBPTR*/
#define DMAPDBPTR_CTRLBASEPTR_MSK      (0xFFFFFFFF << 0)

/* Reset Value for DMAADBPTR*/
#define DMAADBPTR_RVAL                 0x100 

/* Masks for bitfields in DMAADBPTR*/
#define DMAADBPTR_ALTCBPTR_MSK         (0xFFFFFFFF << 0)

/* Reset Value for DMASWREQ*/
#define DMASWREQ_RVAL                  0x0 
#define DMASWREQ_SPI1TX_BBA            (*(volatile unsigned long *) 0x42200280)
#define DMASWREQ_SPI1RX_BBA            (*(volatile unsigned long *) 0x42200284)
#define DMASWREQ_UARTTX_BBA            (*(volatile unsigned long *) 0x42200288)
#define DMASWREQ_UARTRX_BBA            (*(volatile unsigned long *) 0x4220028C)
#define DMASWREQ_I2CSTX_BBA            (*(volatile unsigned long *) 0x42200290)
#define DMASWREQ_I2CSRX_BBA            (*(volatile unsigned long *) 0x42200294)
#define DMASWREQ_I2CMTX_BBA            (*(volatile unsigned long *) 0x42200298)
#define DMASWREQ_I2CMRX_BBA            (*(volatile unsigned long *) 0x4220029C)
#define DMASWREQ_ADC_BBA               (*(volatile unsigned long *) 0x422002AC)
#define DMASWREQ_SPI0TX_BBA            (*(volatile unsigned long *) 0x422002B0)
#define DMASWREQ_SPI0RX_BBA            (*(volatile unsigned long *) 0x422002B4)

/* Masks for bitfields in DMASWREQ*/
#define DMASWREQ_SPI1TX                DMACHNL_SPI1TX
#define DMASWREQ_SPI1RX                DMACHNL_SPI1RX
#define DMASWREQ_UARTTX                DMACHNL_UARTTX
#define DMASWREQ_UARTRX                DMACHNL_UARTRX
#define DMASWREQ_I2CSTX                DMACHNL_I2CSTX
#define DMASWREQ_I2CSRX                DMACHNL_I2CSRX
#define DMASWREQ_I2CMTX                DMACHNL_I2CMTX
#define DMASWREQ_I2CMRX                DMACHNL_I2CMRX
#define DMASWREQ_ADC                   DMACHNL_ADC
#define DMASWREQ_SPI0TX                DMACHNL_SPI0TX
#define DMASWREQ_SPI0RX                DMACHNL_SPI0RX

/* Reset Value for DMARMSKSET*/
#define DMARMSKSET_RVAL                0x0 
#define DMARMSKSET_SPI1TX_BBA          (*(volatile unsigned long *) 0x42200400)
#define DMARMSKSET_SPI1RX_BBA          (*(volatile unsigned long *) 0x42200404)
#define DMARMSKSET_UARTTX_BBA          (*(volatile unsigned long *) 0x42200408)
#define DMARMSKSET_UARTRX_BBA          (*(volatile unsigned long *) 0x4220040C)
#define DMARMSKSET_I2CSTX_BBA          (*(volatile unsigned long *) 0x42200410)
#define DMARMSKSET_I2CSRX_BBA          (*(volatile unsigned long *) 0x42200414)
#define DMARMSKSET_I2CMTX_BBA          (*(volatile unsigned long *) 0x42200418)
#define DMARMSKSET_I2CMRX_BBA          (*(volatile unsigned long *) 0x4220041C)
#define DMARMSKSET_ADC_BBA             (*(volatile unsigned long *) 0x4220042C)
#define DMARMSKSET_SPI0TX_BBA          (*(volatile unsigned long *) 0x42200430)
#define DMARMSKSET_SPI0RX_BBA          (*(volatile unsigned long *) 0x42200434)

/* Masks for bitfields in DMARMSKSET*/
#define DMARMSKSET_SPI1TX              DMACHNL_SPI1TX
#define DMARMSKSET_SPI1RX              DMACHNL_SPI1RX
#define DMARMSKSET_UARTTX              DMACHNL_UARTTX
#define DMARMSKSET_UARTRX              DMACHNL_UARTRX
#define DMARMSKSET_I2CSTX              DMACHNL_I2CSTX
#define DMARMSKSET_I2CSRX              DMACHNL_I2CSRX
#define DMARMSKSET_I2CMTX              DMACHNL_I2CMTX
#define DMARMSKSET_I2CMRX              DMACHNL_I2CMRX
#define DMARMSKSET_ADC                 DMACHNL_ADC
#define DMARMSKSET_SPI0TX              DMACHNL_SPI0TX
#define DMARMSKSET_SPI0RX              DMACHNL_SPI0RX

/* Reset Value for DMARMSKCLR*/
#define DMARMSKCLR_RVAL                0x0 
#define DMARMSKCLR_SPI1TX_BBA          (*(volatile unsigned long *) 0x42200480)
#define DMARMSKCLR_SPI1RX_BBA          (*(volatile unsigned long *) 0x42200484)
#define DMARMSKCLR_UARTTX_BBA          (*(volatile unsigned long *) 0x42200488)
#define DMARMSKCLR_UARTRX_BBA          (*(volatile unsigned long *) 0x4220048C)
#define DMARMSKCLR_I2CSTX_BBA          (*(volatile unsigned long *) 0x42200490)
#define DMARMSKCLR_I2CSRX_BBA          (*(volatile unsigned long *) 0x42200494)
#define DMARMSKCLR_I2CMTX_BBA          (*(volatile unsigned long *) 0x42200498)
#define DMARMSKCLR_I2CMRX_BBA          (*(volatile unsigned long *) 0x4220049C)
#define DMARMSKCLR_ADC_BBA             (*(volatile unsigned long *) 0x422004AC)
#define DMARMSKCLR_SPI0TX_BBA          (*(volatile unsigned long *) 0x422004B0)
#define DMARMSKCLR_SPI0RX_BBA          (*(volatile unsigned long *) 0x422004B4)

/* Masks for bitfields in DMARMSKCLR*/
#define DMARMSKCLR_SPI1TX              DMACHNL_SPI1TX
#define DMARMSKCLR_SPI1RX              DMACHNL_SPI1RX
#define DMARMSKCLR_UARTTX              DMACHNL_UARTTX
#define DMARMSKCLR_UARTRX              DMACHNL_UARTRX
#define DMARMSKCLR_I2CSTX              DMACHNL_I2CSTX
#define DMARMSKCLR_I2CSRX              DMACHNL_I2CSRX
#define DMARMSKCLR_I2CMTX              DMACHNL_I2CMTX
#define DMARMSKCLR_I2CMRX              DMACHNL_I2CMRX
#define DMARMSKCLR_ADC                 DMACHNL_ADC
#define DMARMSKCLR_SPI0TX              DMACHNL_SPI0TX
#define DMARMSKCLR_SPI0RX              DMACHNL_SPI0RX

/* Reset Value for DMAENSET*/
#define DMAENSET_RVAL                  0x0 
#define DMAENSET_SPI1TX_BBA            (*(volatile unsigned long *) 0x42200500)
#define DMAENSET_SPI1RX_BBA            (*(volatile unsigned long *) 0x42200504)
#define DMAENSET_UARTTX_BBA            (*(volatile unsigned long *) 0x42200508)
#define DMAENSET_UARTRX_BBA            (*(volatile unsigned long *) 0x4220050C)
#define DMAENSET_I2CSTX_BBA            (*(volatile unsigned long *) 0x42200510)
#define DMAENSET_I2CSRX_BBA            (*(volatile unsigned long *) 0x42200514)
#define DMAENSET_I2CMTX_BBA            (*(volatile unsigned long *) 0x42200518)
#define DMAENSET_I2CMRX_BBA            (*(volatile unsigned long *) 0x4220051C)
#define DMAENSET_ADC_BBA               (*(volatile unsigned long *) 0x4220052C)
#define DMAENSET_SPI0TX_BBA            (*(volatile unsigned long *) 0x42200530)
#define DMAENSET_SPI0RX_BBA            (*(volatile unsigned long *) 0x42200534)

/* Masks for bitfields in DMAENSET*/
#define DMAENSET_SPI1TX                DMACHNL_SPI1TX
#define DMAENSET_SPI1RX                DMACHNL_SPI1RX
#define DMAENSET_UARTTX                DMACHNL_UARTTX
#define DMAENSET_UARTRX                DMACHNL_UARTRX
#define DMAENSET_I2CSTX                DMACHNL_I2CSTX
#define DMAENSET_I2CSRX                DMACHNL_I2CSRX
#define DMAENSET_I2CMTX                DMACHNL_I2CMTX
#define DMAENSET_I2CMRX                DMACHNL_I2CMRX
#define DMAENSET_ADC                   DMACHNL_ADC
#define DMAENSET_SPI0TX                DMACHNL_SPI0TX
#define DMAENSET_SPI0RX                DMACHNL_SPI0RX

/* Reset Value for DMAENCLR*/
#define DMAENCLR_RVAL                  0x0 
#define DMAENCLR_SPI1TX_BBA            (*(volatile unsigned long *) 0x42200580)
#define DMAENCLR_SPI1RX_BBA            (*(volatile unsigned long *) 0x42200584)
#define DMAENCLR_UARTTX_BBA            (*(volatile unsigned long *) 0x42200588)
#define DMAENCLR_UARTRX_BBA            (*(volatile unsigned long *) 0x4220058C)
#define DMAENCLR_I2CSTX_BBA            (*(volatile unsigned long *) 0x42200590)
#define DMAENCLR_I2CSRX_BBA            (*(volatile unsigned long *) 0x42200594)
#define DMAENCLR_I2CMTX_BBA            (*(volatile unsigned long *) 0x42200598)
#define DMAENCLR_I2CMRX_BBA            (*(volatile unsigned long *) 0x4220059C)
#define DMAENCLR_ADC_BBA               (*(volatile unsigned long *) 0x422005AC)
#define DMAENCLR_SPI0TX_BBA            (*(volatile unsigned long *) 0x422005B0)
#define DMAENCLR_SPI0RX_BBA            (*(volatile unsigned long *) 0x422005B4)

/* Masks for bitfields in DMAENCLR*/
#define DMAENCLR_SPI1TX                DMACHNL_SPI1TX
#define DMAENCLR_SPI1RX                DMACHNL_SPI1RX
#define DMAENCLR_UARTTX                DMACHNL_UARTTX
#define DMAENCLR_UARTRX                DMACHNL_UARTRX
#define DMAENCLR_I2CSTX                DMACHNL_I2CSTX
#define DMAENCLR_I2CSRX                DMACHNL_I2CSRX
#define DMAENCLR_I2CMTX                DMACHNL_I2CMTX
#define DMAENCLR_I2CMRX                DMACHNL_I2CMRX
#define DMAENCLR_ADC                   DMACHNL_ADC
#define DMAENCLR_SPI0TX                DMACHNL_SPI0TX
#define DMAENCLR_SPI0RX                DMACHNL_SPI0RX

/* Reset Value for DMAALTSET*/
#define DMAALTSET_RVAL                 0x0 
#define DMAALTSET_SPI1TX_BBA           (*(volatile unsigned long *) 0x42200600)
#define DMAALTSET_SPI1RX_BBA           (*(volatile unsigned long *) 0x42200604)
#define DMAALTSET_UARTTX_BBA           (*(volatile unsigned long *) 0x42200608)
#define DMAALTSET_UARTRX_BBA           (*(volatile unsigned long *) 0x4220060C)
#define DMAALTSET_I2CSTX_BBA           (*(volatile unsigned long *) 0x42200610)
#define DMAALTSET_I2CSRX_BBA           (*(volatile unsigned long *) 0x42200614)
#define DMAALTSET_I2CMTX_BBA           (*(volatile unsigned long *) 0x42200618)
#define DMAALTSET_I2CMRX_BBA           (*(volatile unsigned long *) 0x4220061C)
#define DMAALTSET_ADC_BBA              (*(volatile unsigned long *) 0x4220062C)
#define DMAALTSET_SPI0TX_BBA           (*(volatile unsigned long *) 0x42200630)
#define DMAALTSET_SPI0RX_BBA           (*(volatile unsigned long *) 0x42200634)

/* Masks for bitfields in DMAALTSET*/
#define DMAALTSET_SPI1TX               DMACHNL_SPI1TX
#define DMAALTSET_SPI1RX               DMACHNL_SPI1RX
#define DMAALTSET_UARTTX               DMACHNL_UARTTX
#define DMAALTSET_UARTRX               DMACHNL_UARTRX
#define DMAALTSET_I2CSTX               DMACHNL_I2CSTX
#define DMAALTSET_I2CSRX               DMACHNL_I2CSRX
#define DMAALTSET_I2CMTX               DMACHNL_I2CMTX
#define DMAALTSET_I2CMRX               DMACHNL_I2CMRX
#define DMAALTSET_ADC                  DMACHNL_ADC
#define DMAALTSET_SPI0TX               DMACHNL_SPI0TX
#define DMAALTSET_SPI0RX               DMACHNL_SPI0RX

/* Reset Value for DMAALTCLR*/
#define DMAALTCLR_RVAL                 0x0 
#define DMAALTCLR_SPI1TX_BBA           (*(volatile unsigned long *) 0x42200680)
#define DMAALTCLR_SPI1RX_BBA           (*(volatile unsigned long *) 0x42200684)
#define DMAALTCLR_UARTTX_BBA           (*(volatile unsigned long *) 0x42200688)
#define DMAALTCLR_UARTRX_BBA           (*(volatile unsigned long *) 0x4220068C)
#define DMAALTCLR_I2CSTX_BBA           (*(volatile unsigned long *) 0x42200690)
#define DMAALTCLR_I2CSRX_BBA           (*(volatile unsigned long *) 0x42200694)
#define DMAALTCLR_I2CMTX_BBA           (*(volatile unsigned long *) 0x42200698)
#define DMAALTCLR_I2CMRX_BBA           (*(volatile unsigned long *) 0x4220069C)
#define DMAALTCLR_ADC_BBA              (*(volatile unsigned long *) 0x422006AC)
#define DMAALTCLR_SPI0TX_BBA           (*(volatile unsigned long *) 0x422006B0)
#define DMAALTCLR_SPI0RX_BBA           (*(volatile unsigned long *) 0x422006B4)

/* Masks for bitfields in DMAALTCLR*/
#define DMAALTCLR_SPI1TX               DMACHNL_SPI1TX
#define DMAALTCLR_SPI1RX               DMACHNL_SPI1RX
#define DMAALTCLR_UARTTX               DMACHNL_UARTTX
#define DMAALTCLR_UARTRX               DMACHNL_UARTRX
#define DMAALTCLR_I2CSTX               DMACHNL_I2CSTX
#define DMAALTCLR_I2CSRX               DMACHNL_I2CSRX
#define DMAALTCLR_I2CMTX               DMACHNL_I2CMTX
#define DMAALTCLR_I2CMRX               DMACHNL_I2CMRX
#define DMAALTCLR_ADC                  DMACHNL_ADC
#define DMAALTCLR_SPI0TX               DMACHNL_SPI0TX
#define DMAALTCLR_SPI0RX               DMACHNL_SPI0RX

/* Reset Value for DMAPRISET*/
#define DMAPRISET_RVAL                 0x0 
#define DMAPRISET_SPI1TX_BBA           (*(volatile unsigned long *) 0x42200700)
#define DMAPRISET_SPI1RX_BBA           (*(volatile unsigned long *) 0x42200704)
#define DMAPRISET_UARTTX_BBA           (*(volatile unsigned long *) 0x42200708)
#define DMAPRISET_UARTRX_BBA           (*(volatile unsigned long *) 0x4220070C)
#define DMAPRISET_I2CSTX_BBA           (*(volatile unsigned long *) 0x42200710)
#define DMAPRISET_I2CSRX_BBA           (*(volatile unsigned long *) 0x42200714)
#define DMAPRISET_I2CMTX_BBA           (*(volatile unsigned long *) 0x42200718)
#define DMAPRISET_I2CMRX_BBA           (*(volatile unsigned long *) 0x4220071C)
#define DMAPRISET_ADC_BBA              (*(volatile unsigned long *) 0x4220072C)
#define DMAPRISET_SPI0TX_BBA           (*(volatile unsigned long *) 0x42200730)
#define DMAPRISET_SPI0RX_BBA           (*(volatile unsigned long *) 0x42200734)

/* Masks for bitfields in DMAPRISET*/
#define DMAPRISET_SPI1TX               DMACHNL_SPI1TX
#define DMAPRISET_SPI1RX               DMACHNL_SPI1RX
#define DMAPRISET_UARTTX               DMACHNL_UARTTX
#define DMAPRISET_UARTRX               DMACHNL_UARTRX
#define DMAPRISET_I2CSTX               DMACHNL_I2CSTX
#define DMAPRISET_I2CSRX               DMACHNL_I2CSRX
#define DMAPRISET_I2CMTX               DMACHNL_I2CMTX
#define DMAPRISET_I2CMRX               DMACHNL_I2CMRX
#define DMAPRISET_ADC                  DMACHNL_ADC
#define DMAPRISET_SPI0TX               DMACHNL_SPI0TX
#define DMAPRISET_SPI0RX               DMACHNL_SPI0RX

/* Reset Value for DMAPRICLR*/
#define DMAPRICLR_RVAL                 0x0 
#define DMAPRICLR_SPI1TX_BBA           (*(volatile unsigned long *) 0x42200780)
#define DMAPRICLR_SPI1RX_BBA           (*(volatile unsigned long *) 0x42200784)
#define DMAPRICLR_UARTTX_BBA           (*(volatile unsigned long *) 0x42200788)
#define DMAPRICLR_UARTRX_BBA           (*(volatile unsigned long *) 0x4220078C)
#define DMAPRICLR_I2CSTX_BBA           (*(volatile unsigned long *) 0x42200790)
#define DMAPRICLR_I2CSRX_BBA           (*(volatile unsigned long *) 0x42200794)
#define DMAPRICLR_I2CMTX_BBA           (*(volatile unsigned long *) 0x42200798)
#define DMAPRICLR_I2CMRX_BBA           (*(volatile unsigned long *) 0x4220079C)
#define DMAPRICLR_ADC_BBA              (*(volatile unsigned long *) 0x422007AC)
#define DMAPRICLR_SPI0TX_BBA           (*(volatile unsigned long *) 0x422007B0)
#define DMAPRICLR_SPI0RX_BBA           (*(volatile unsigned long *) 0x422007B4)

/* Masks for bitfields in DMAPRICLR*/
#define DMAPRICLR_SPI1TX               DMACHNL_SPI1TX
#define DMAPRICLR_SPI1RX               DMACHNL_SPI1RX
#define DMAPRICLR_UARTTX               DMACHNL_UARTTX
#define DMAPRICLR_UARTRX               DMACHNL_UARTRX
#define DMAPRICLR_I2CSTX               DMACHNL_I2CSTX
#define DMAPRICLR_I2CSRX               DMACHNL_I2CSRX
#define DMAPRICLR_I2CMTX               DMACHNL_I2CMTX
#define DMAPRICLR_I2CMRX               DMACHNL_I2CMRX
#define DMAPRICLR_ADC                  DMACHNL_ADC
#define DMAPRICLR_SPI0TX               DMACHNL_SPI0TX
#define DMAPRICLR_SPI0RX               DMACHNL_SPI0RX

/* Reset Value for DMAERRCLR*/
#define DMAERRCLR_RVAL                 0x0 
#define DMAERRCLR_ERROR_BBA            (*(volatile unsigned long *) 0x42200980)

/* Masks for bitfields in DMAERRCLR*/
#define DMAERRCLR_ERROR                (0x1 << 0)

/* Reset Value for DMAPERID4*/
#define DMAPERID4_RVAL                 0x4 

/* Masks for bitfields in DMAPERID4*/
#define DMAPERID4_JEP106CCODE_MSK      (0xF << 0)
#define DMAPERID4_BLOCKCOUNT_MSK       (0xF << 4)

/* Reset Value for DMAPERID0*/
#define DMAPERID0_RVAL                 0x30 

/* Masks for bitfields in DMAPERID0*/
#define DMAPERID0_PARTNO0_MSK          (0xFF << 0)

/* Reset Value for DMAPERID1*/
#define DMAPERID1_RVAL                 0xB2 

/* Masks for bitfields in DMAPERID1*/
#define DMAPERID1_PARTNO1_MSK          (0xF << 0)
#define DMAPERID1_JEP106ID0_MSK        (0xF << 4)

/* Reset Value for DMAPERID2*/
#define DMAPERID2_RVAL                 0xB 
#define DMAPERID2_JEDECUSED_BBA        (*(volatile unsigned long *) 0x4221FD0C)

/* Masks for bitfields in DMAPERID2*/
#define DMAPERID2_JEP106ID1_MSK        (0x7 << 0)
#define DMAPERID2_JEDECUSED            (0x1 << 3)
#define DMAPERID2_REVISION_MSK         (0xF << 4)

/* Reset Value for DMAPERID3*/
#define DMAPERID3_RVAL                 0x0 

/* Masks for bitfields in DMAPERID3*/
#define DMAPERID3_MODNUM_MSK           (0xF << 0)

/* Reset Value for DMAPCELLID0*/
#define DMAPCELLID0_RVAL               0xD 

/* Masks for bitfields in DMAPCELLID0*/
#define DMAPCELLID0_PCELLID0_MSK       (0xFF << 0)

/* Reset Value for DMAPCELLID1*/
#define DMAPCELLID1_RVAL               0xF0 

/* Masks for bitfields in DMAPCELLID1*/
#define DMAPCELLID1_PCELLID1_MSK       (0xFF << 0)

/* Reset Value for DMAPCELLID2*/
#define DMAPCELLID2_RVAL               0x5 

/* Masks for bitfields in DMAPCELLID2*/
#define DMAPCELLID2_PCELLID2_MSK       (0xFF << 0)

/* Reset Value for DMAPCELLID3*/
#define DMAPCELLID3_RVAL               0xB1 

/* Masks for bitfields in DMAPCELLID3*/
#define DMAPCELLID3_PCELLID3_MSK       (0xFF << 0)

/* Masks for bitfields in INT0031*/
#define INT0031_T2                     (0x1 << 0)
#define INT0031_EXTINT0                (0x1 << 1)
#define INT0031_EXTINT1                (0x1 << 2)
#define INT0031_EXTINT2                (0x1 << 3)
#define INT0031_EXTINT3                (0x1 << 4)
#define INT0031_EXTINT4                (0x1 << 5)
#define INT0031_EXTINT5                (0x1 << 6)
#define INT0031_EXTINT6                (0x1 << 7)
#define INT0031_EXTINT7                (0x1 << 8)
#define INT0031_EXTINT8                (0x1 << 9)
#define INT0031_T3                     (0x1 << 10)
#define INT0031_T0                     (0x1 << 12)
#define INT0031_T1                     (0x1 << 13)
#define INT0031_ADC                    (0x1 << 14)
#define INT0031_FEE                    (0x1 << 15)
#define INT0031_UART                   (0x1 << 16)
#define INT0031_SPI0                   (0x1 << 17)
#define INT0031_SPI1                   (0x1 << 18)
#define INT0031_I2CS                   (0x1 << 19)
#define INT0031_I2CM                   (0x1 << 20)
#define INT0031_DMAERROR               (0x1 << 22)
#define INT0031_DMASPI1TX              (0x1 << 23)
#define INT0031_DMASPI1RX              (0x1 << 24)
#define INT0031_DMAUARTTX              (0x1 << 25)
#define INT0031_DMAUARTRX              (0x1 << 26)
#define INT0031_DMAI2CSTX              (0x1 << 27)
#define INT0031_DMAI2CSRX              (0x1 << 28)
#define INT0031_DMAI2CMTX              (0x1 << 29)
#define INT0031_DMAI2CMRX              (0x1 << 30)

/* Masks for bitfields in INT3263*/
#define INT3263_DMAADC                 (0x1 << 2)
#define INT3263_DMASPI0TX              (0x1 << 3)
#define INT3263_DMASPI0RX              (0x1 << 4)
#define INT3263_PWMTRIP                (0x1 << 5)
#define INT3263_PWM0                   (0x1 << 6)
#define INT3263_PWM1                   (0x1 << 7)
#define INT3263_PWM2                   (0x1 << 8)
#define INT3263_PWM3                   (0x1 << 9)

/* Masks for bitfields in INT0015*/
#define INT0015_T2                     (0x1 << 0)
#define INT0015_EXTINT0                (0x1 << 1)
#define INT0015_EXTINT1                (0x1 << 2)
#define INT0015_EXTINT2                (0x1 << 3)
#define INT0015_EXTINT3                (0x1 << 4)
#define INT0015_EXTINT4                (0x1 << 5)
#define INT0015_EXTINT5                (0x1 << 6)
#define INT0015_EXTINT6                (0x1 << 7)
#define INT0015_EXTINT7                (0x1 << 8)
#define INT0015_EXTINT8                (0x1 << 9)
#define INT0015_T3                     (0x1 << 10)
#define INT0015_T0                     (0x1 << 12)
#define INT0015_T1                     (0x1 << 13)
#define INT0015_ADC                    (0x1 << 14)
#define INT0015_FEE                    (0x1 << 15)

/* Masks for bitfields in INT1631*/
#define INT1631_UART                   (0x1 << 0)
#define INT1631_SPI0                   (0x1 << 1)
#define INT1631_SPI1                   (0x1 << 2)
#define INT1631_I2CS                   (0x1 << 3)
#define INT1631_I2CM                   (0x1 << 4)
#define INT1631_DMAERROR               (0x1 << 6)
#define INT1631_DMASPI1TX              (0x1 << 7)
#define INT1631_DMASPI1RX              (0x1 << 8)
#define INT1631_DMAUARTTX              (0x1 << 9)
#define INT1631_DMAUARTRX              (0x1 << 10)
#define INT1631_DMAI2CSTX              (0x1 << 11)
#define INT1631_DMAI2CSRX              (0x1 << 12)
#define INT1631_DMAI2CMTX              (0x1 << 13)
#define INT1631_DMAI2CMRX              (0x1 << 14)

/* Masks for bitfields in INT3247*/
#define INT3247_DMAADC                 (0x1 << 2)
#define INT3247_DMASPI0TX              (0x1 << 3)
#define INT3247_DMASPI0RX              (0x1 << 4)
#define INT3247_PWMTRIP                (0x1 << 5)
#define INT3247_PWM0                   (0x1 << 6)
#define INT3247_PWM1                   (0x1 << 7)
#define INT3247_PWM2                   (0x1 << 8)
#define INT3247_PWM3                   (0x1 << 9)


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* NVIC                                               Base Address 0xE000E000 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for ICTR*/
#define ICTR_RVAL                      0x1 

/* Masks for bitfields in ICTR*/
#define ICTR_INTLINESNUM_MSK           (0xF << 0)

/* Reset Value for STCSR*/
#define STCSR_RVAL                     0x0 

/* Masks for bitfields in STCSR*/
#define STCSR_ENABLE                   (0x1 << 0)
#define STCSR_TICKINT                  (0x1 << 1)
#define STCSR_CLKSOURCE                (0x1 << 2)
#define STCSR_COUNTFLAG                (0x1 << 16)

/* Reset Value for STRVR*/
#define STRVR_RVAL                     0x0 

/* Masks for bitfields in STRVR*/
#define STRVR_RELOAD_MSK               (0xFFFFFF << 0)

/* Reset Value for STCVR*/
#define STCVR_RVAL                     0x0 

/* Masks for bitfields in STCVR*/
#define STCVR_CURRENT_MSK              (0xFFFFFFFF << 0)

/* Reset Value for STCR*/
#define STCR_RVAL                      0x0 

/* Masks for bitfields in STCR*/
#define STCR_TENMS_MSK                 (0xFFFFFF << 0)
#define STCR_SKEW                      (0x1 << 30)
#define STCR_NOREF                     (0x1 << 31)

/* Reset Value for ISER0*/
#define ISER0_RVAL                     0x0 

/* Masks for bitfields in ISER0*/
#define ISER0_T2                       INT0031_T2
#define ISER0_EXTINT0                  INT0031_EXTINT0
#define ISER0_EXTINT1                  INT0031_EXTINT1
#define ISER0_EXTINT2                  INT0031_EXTINT2
#define ISER0_EXTINT3                  INT0031_EXTINT3
#define ISER0_EXTINT4                  INT0031_EXTINT4
#define ISER0_EXTINT5                  INT0031_EXTINT5
#define ISER0_EXTINT6                  INT0031_EXTINT6
#define ISER0_EXTINT7                  INT0031_EXTINT7
#define ISER0_EXTINT8                  INT0031_EXTINT8
#define ISER0_T3                       INT0031_T3
#define ISER0_T0                       INT0031_T0
#define ISER0_T1                       INT0031_T1
#define ISER0_ADC                      INT0031_ADC
#define ISER0_FEE                      INT0031_FEE
#define ISER0_UART                     INT0031_UART
#define ISER0_SPI0                     INT0031_SPI0
#define ISER0_SPI1                     INT0031_SPI1
#define ISER0_I2CS                     INT0031_I2CS
#define ISER0_I2CM                     INT0031_I2CM
#define ISER0_DMAERROR                 INT0031_DMAERROR
#define ISER0_DMASPI1TX                INT0031_DMASPI1TX
#define ISER0_DMASPI1RX                INT0031_DMASPI1RX
#define ISER0_DMAUARTTX                INT0031_DMAUARTTX
#define ISER0_DMAUARTRX                INT0031_DMAUARTRX
#define ISER0_DMAI2CSTX                INT0031_DMAI2CSTX
#define ISER0_DMAI2CSRX                INT0031_DMAI2CSRX
#define ISER0_DMAI2CMTX                INT0031_DMAI2CMTX
#define ISER0_DMAI2CMRX                INT0031_DMAI2CMRX

/* Reset Value for ISER1*/
#define ISER1_RVAL                     0x0 

/* Masks for bitfields in ISER1*/
#define ISER1_DMAADC                   INT3263_DMAADC
#define ISER1_DMASPI0TX                INT3263_DMASPI0TX
#define ISER1_DMASPI0RX                INT3263_DMASPI0RX
#define ISER1_PWMTRIP                  INT3263_PWMTRIP
#define ISER1_PWM0                     INT3263_PWM0
#define ISER1_PWM1                     INT3263_PWM1
#define ISER1_PWM2                     INT3263_PWM2
#define ISER1_PWM3                     INT3263_PWM3

/* Reset Value for ICER0*/
#define ICER0_RVAL                     0x0 

/* Masks for bitfields in ICER0*/
#define ICER0_T2                       INT0031_T2
#define ICER0_EXTINT0                  INT0031_EXTINT0
#define ICER0_EXTINT1                  INT0031_EXTINT1
#define ICER0_EXTINT2                  INT0031_EXTINT2
#define ICER0_EXTINT3                  INT0031_EXTINT3
#define ICER0_EXTINT4                  INT0031_EXTINT4
#define ICER0_EXTINT5                  INT0031_EXTINT5
#define ICER0_EXTINT6                  INT0031_EXTINT6
#define ICER0_EXTINT7                  INT0031_EXTINT7
#define ICER0_EXTINT8                  INT0031_EXTINT8
#define ICER0_T3                       INT0031_T3
#define ICER0_T0                       INT0031_T0
#define ICER0_T1                       INT0031_T1
#define ICER0_ADC                      INT0031_ADC
#define ICER0_FEE                      INT0031_FEE
#define ICER0_UART                     INT0031_UART
#define ICER0_SPI0                     INT0031_SPI0
#define ICER0_SPI1                     INT0031_SPI1
#define ICER0_I2CS                     INT0031_I2CS
#define ICER0_I2CM                     INT0031_I2CM
#define ICER0_DMAERROR                 INT0031_DMAERROR
#define ICER0_DMASPI1TX                INT0031_DMASPI1TX
#define ICER0_DMASPI1RX                INT0031_DMASPI1RX
#define ICER0_DMAUARTTX                INT0031_DMAUARTTX
#define ICER0_DMAUARTRX                INT0031_DMAUARTRX
#define ICER0_DMAI2CSTX                INT0031_DMAI2CSTX
#define ICER0_DMAI2CSRX                INT0031_DMAI2CSRX
#define ICER0_DMAI2CMTX                INT0031_DMAI2CMTX
#define ICER0_DMAI2CMRX                INT0031_DMAI2CMRX

/* Reset Value for ICER1*/
#define ICER1_RVAL                     0x0 

/* Masks for bitfields in ICER1*/
#define ICER1_DMAADC                   INT3263_DMAADC
#define ICER1_DMASPI0TX                INT3263_DMASPI0TX
#define ICER1_DMASPI0RX                INT3263_DMASPI0RX
#define ICER1_PWMTRIP                  INT3263_PWMTRIP
#define ICER1_PWM0                     INT3263_PWM0
#define ICER1_PWM1                     INT3263_PWM1
#define ICER1_PWM2                     INT3263_PWM2
#define ICER1_PWM3                     INT3263_PWM3

/* Reset Value for INTSETP0*/
#define INTSETP0_RVAL                  0x0 

/* Masks for bitfields in INTSETP0*/
#define INTSETP0_T2                    INT0031_T2
#define INTSETP0_EXTINT0               INT0031_EXTINT0
#define INTSETP0_EXTINT1               INT0031_EXTINT1
#define INTSETP0_EXTINT2               INT0031_EXTINT2
#define INTSETP0_EXTINT3               INT0031_EXTINT3
#define INTSETP0_EXTINT4               INT0031_EXTINT4
#define INTSETP0_EXTINT5               INT0031_EXTINT5
#define INTSETP0_EXTINT6               INT0031_EXTINT6
#define INTSETP0_EXTINT7               INT0031_EXTINT7
#define INTSETP0_EXTINT8               INT0031_EXTINT8
#define INTSETP0_T3                    INT0031_T3
#define INTSETP0_T0                    INT0031_T0
#define INTSETP0_T1                    INT0031_T1
#define INTSETP0_ADC                   INT0031_ADC
#define INTSETP0_FEE                   INT0031_FEE
#define INTSETP0_UART                  INT0031_UART
#define INTSETP0_SPI0                  INT0031_SPI0
#define INTSETP0_SPI1                  INT0031_SPI1
#define INTSETP0_I2CS                  INT0031_I2CS
#define INTSETP0_I2CM                  INT0031_I2CM
#define INTSETP0_DMAERROR              INT0031_DMAERROR
#define INTSETP0_DMASPI1TX             INT0031_DMASPI1TX
#define INTSETP0_DMASPI1RX             INT0031_DMASPI1RX
#define INTSETP0_DMAUARTTX             INT0031_DMAUARTTX
#define INTSETP0_DMAUARTRX             INT0031_DMAUARTRX
#define INTSETP0_DMAI2CSTX             INT0031_DMAI2CSTX
#define INTSETP0_DMAI2CSRX             INT0031_DMAI2CSRX
#define INTSETP0_DMAI2CMTX             INT0031_DMAI2CMTX
#define INTSETP0_DMAI2CMRX             INT0031_DMAI2CMRX

/* Reset Value for INTSETP1*/
#define INTSETP1_RVAL                  0x0 

/* Masks for bitfields in INTSETP1*/
#define INTSETP1_DMAADC                INT3263_DMAADC
#define INTSETP1_DMASPI0TX             INT3263_DMASPI0TX
#define INTSETP1_DMASPI0RX             INT3263_DMASPI0RX
#define INTSETP1_PWMTRIP               INT3263_PWMTRIP
#define INTSETP1_PWM0                  INT3263_PWM0
#define INTSETP1_PWM1                  INT3263_PWM1
#define INTSETP1_PWM2                  INT3263_PWM2
#define INTSETP1_PWM3                  INT3263_PWM3

/* Reset Value for ICPR0*/
#define ICPR0_RVAL                     0x0 

/* Masks for bitfields in ICPR0*/
#define ICPR0_T2                       INT0031_T2
#define ICPR0_EXTINT0                  INT0031_EXTINT0
#define ICPR0_EXTINT1                  INT0031_EXTINT1
#define ICPR0_EXTINT2                  INT0031_EXTINT2
#define ICPR0_EXTINT3                  INT0031_EXTINT3
#define ICPR0_EXTINT4                  INT0031_EXTINT4
#define ICPR0_EXTINT5                  INT0031_EXTINT5
#define ICPR0_EXTINT6                  INT0031_EXTINT6
#define ICPR0_EXTINT7                  INT0031_EXTINT7
#define ICPR0_EXTINT8                  INT0031_EXTINT8
#define ICPR0_T3                       INT0031_T3
#define ICPR0_T0                       INT0031_T0
#define ICPR0_T1                       INT0031_T1
#define ICPR0_ADC                      INT0031_ADC
#define ICPR0_FEE                      INT0031_FEE
#define ICPR0_UART                     INT0031_UART
#define ICPR0_SPI0                     INT0031_SPI0
#define ICPR0_SPI1                     INT0031_SPI1
#define ICPR0_I2CS                     INT0031_I2CS
#define ICPR0_I2CM                     INT0031_I2CM
#define ICPR0_DMAERROR                 INT0031_DMAERROR
#define ICPR0_DMASPI1TX                INT0031_DMASPI1TX
#define ICPR0_DMASPI1RX                INT0031_DMASPI1RX
#define ICPR0_DMAUARTTX                INT0031_DMAUARTTX
#define ICPR0_DMAUARTRX                INT0031_DMAUARTRX
#define ICPR0_DMAI2CSTX                INT0031_DMAI2CSTX
#define ICPR0_DMAI2CSRX                INT0031_DMAI2CSRX
#define ICPR0_DMAI2CMTX                INT0031_DMAI2CMTX
#define ICPR0_DMAI2CMRX                INT0031_DMAI2CMRX

/* Reset Value for ICPR1*/
#define ICPR1_RVAL                     0x0 

/* Masks for bitfields in ICPR1*/
#define ICPR1_DMAADC                   INT3263_DMAADC
#define ICPR1_DMASPI0TX                INT3263_DMASPI0TX
#define ICPR1_DMASPI0RX                INT3263_DMASPI0RX
#define ICPR1_PWMTRIP                  INT3263_PWMTRIP
#define ICPR1_PWM0                     INT3263_PWM0
#define ICPR1_PWM1                     INT3263_PWM1
#define ICPR1_PWM2                     INT3263_PWM2
#define ICPR1_PWM3                     INT3263_PWM3

/* Reset Value for IABR0*/
#define IABR0_RVAL                     0x0 

/* Masks for bitfields in IABR0*/
#define IABR0_T2                       INT0031_T2
#define IABR0_EXTINT0                  INT0031_EXTINT0
#define IABR0_EXTINT1                  INT0031_EXTINT1
#define IABR0_EXTINT2                  INT0031_EXTINT2
#define IABR0_EXTINT3                  INT0031_EXTINT3
#define IABR0_EXTINT4                  INT0031_EXTINT4
#define IABR0_EXTINT5                  INT0031_EXTINT5
#define IABR0_EXTINT6                  INT0031_EXTINT6
#define IABR0_EXTINT7                  INT0031_EXTINT7
#define IABR0_EXTINT8                  INT0031_EXTINT8
#define IABR0_T3                       INT0031_T3
#define IABR0_T0                       INT0031_T0
#define IABR0_T1                       INT0031_T1
#define IABR0_ADC                      INT0031_ADC
#define IABR0_FEE                      INT0031_FEE
#define IABR0_UART                     INT0031_UART
#define IABR0_SPI0                     INT0031_SPI0
#define IABR0_SPI1                     INT0031_SPI1
#define IABR0_I2CS                     INT0031_I2CS
#define IABR0_I2CM                     INT0031_I2CM
#define IABR0_DMAERROR                 INT0031_DMAERROR
#define IABR0_DMASPI1TX                INT0031_DMASPI1TX
#define IABR0_DMASPI1RX                INT0031_DMASPI1RX
#define IABR0_DMAUARTTX                INT0031_DMAUARTTX
#define IABR0_DMAUARTRX                INT0031_DMAUARTRX
#define IABR0_DMAI2CSTX                INT0031_DMAI2CSTX
#define IABR0_DMAI2CSRX                INT0031_DMAI2CSRX
#define IABR0_DMAI2CMTX                INT0031_DMAI2CMTX
#define IABR0_DMAI2CMRX                INT0031_DMAI2CMRX

/* Reset Value for IABR1*/
#define IABR1_RVAL                     0x0 

/* Masks for bitfields in IABR1*/
#define IABR1_DMAADC                   INT3263_DMAADC
#define IABR1_DMASPI0TX                INT3263_DMASPI0TX
#define IABR1_DMASPI0RX                INT3263_DMASPI0RX
#define IABR1_PWMTRIP                  INT3263_PWMTRIP
#define IABR1_PWM0                     INT3263_PWM0
#define IABR1_PWM1                     INT3263_PWM1
#define IABR1_PWM2                     INT3263_PWM2
#define IABR1_PWM3                     INT3263_PWM3

/* Reset Value for IPR0*/
#define IPR0_RVAL                      0x0 

/* Masks for bitfields in IPR0*/
#define IPR0_T2_MSK                    (0xFF << 0)
#define IPR0_EXTINT0_MSK               (0xFF << 8)
#define IPR0_EXTINT1_MSK               (0xFF << 16)
#define IPR0_EXTINT2_MSK               (0xFF << 24)

/* Reset Value for IPR1*/
#define IPR1_RVAL                      0x0 

/* Masks for bitfields in IPR1*/
#define IPR1_EXTINT3_MSK               (0xFF << 0)
#define IPR1_EXTINT4_MSK               (0xFF << 8)
#define IPR1_EXTINT5_MSK               (0xFF << 16)
#define IPR1_EXTINT6_MSK               (0xFF << 24)

/* Reset Value for IPR2*/
#define IPR2_RVAL                      0x0 

/* Masks for bitfields in IPR2*/
#define IPR2_EXTINT7_MSK               (0xFF << 0)
#define IPR2_EXTINT8_MSK               (0xFF << 8)
#define IPR2_T3_MSK                    (0xFF << 16)

/* Reset Value for IPR3*/
#define IPR3_RVAL                      0x0 

/* Masks for bitfields in IPR3*/
#define IPR3_T0_MSK                    (0xFF << 0)
#define IPR3_T1_MSK                    (0xFF << 8)
#define IPR3_ADC_MSK                   (0xFF << 16)
#define IPR3_FEE_MSK                   (0xFF << 24)

/* Reset Value for IPR4*/
#define IPR4_RVAL                      0x0 

/* Masks for bitfields in IPR4*/
#define IPR4_UART_MSK                  (0xFF << 0)
#define IPR4_SPI0_MSK                  (0xFF << 8)
#define IPR4_SPI1_MSK                  (0xFF << 16)
#define IPR4_I2CS_MSK                  (0xFF << 24)

/* Reset Value for IPR5*/
#define IPR5_RVAL                      0x0 

/* Masks for bitfields in IPR5*/
#define IPR5_I2CM_MSK                  (0xFF << 0)
#define IPR5_DMAERROR_MSK              (0xFF << 16)
#define IPR5_DMASPI1TX_MSK             (0xFF << 24)

/* Reset Value for IPR6*/
#define IPR6_RVAL                      0x0 

/* Masks for bitfields in IPR6*/
#define IPR6_DMASPI1RX_MSK             (0xFF << 0)
#define IPR6_DMAUARTTX_MSK             (0xFF << 8)
#define IPR6_DMAUARTRX_MSK             (0xFF << 16)
#define IPR6_DMAI2CSTX_MSK             (0xFF << 24)

/* Reset Value for IPR7*/
#define IPR7_RVAL                      0x0 

/* Masks for bitfields in IPR7*/
#define IPR7_DMAI2CSRX_MSK             (0xFF << 0)
#define IPR7_DMAI2CMTX_MSK             (0xFF << 8)
#define IPR7_DMAI2CMRX_MSK             (0xFF << 16)

/* Reset Value for IPR8*/
#define IPR8_RVAL                      0x0 

/* Masks for bitfields in IPR8*/
#define IPR8_DMAADC_MSK                (0xFF << 16)
#define IPR8_DMASPI0TX_MSK             (0xFF << 24)

/* Reset Value for IPR9*/
#define IPR9_RVAL                      0x0 

/* Masks for bitfields in IPR9*/
#define IPR9_DMASPI0RX_MSK             (0xFF << 0)
#define IPR9_PWMTRIP_MSK               (0xFF << 8)
#define IPR9_PWM0_MSK                  (0xFF << 16)
#define IPR9_PWM1_MSK                  (0xFF << 24)

/* Reset Value for IPR10*/
#define IPR10_RVAL                     0x0 

/* Masks for bitfields in IPR10*/
#define IPR10_PWM2_MSK                 (0xFF << 0)
#define IPR10_PWM3_MSK                 (0xFF << 8)

/* Reset Value for CPUID*/
#define CPUID_RVAL                     0x412FC230 

/* Masks for bitfields in CPUID*/
#define CPUID_REVISION_MSK             (0xF << 0)
#define CPUID_PARTNO_MSK               (0xFFF << 4)
#define CPUID_VARIANT_MSK              (0xF << 20)
#define CPUID_IMPLEMENTER_MSK          (0xFF << 24)

/* Reset Value for ICSR*/
#define ICSR_RVAL                      0x0 

/* Masks for bitfields in ICSR*/
#define ICSR_VECTACTIVE_MSK            (0x1FF << 0)
#define ICSR_RETTOBASE                 (0x1 << 11)
#define ICSR_VECTPENDING_MSK           (0x1FF << 12)
#define ICSR_ISRPENDING                (0x1 << 22)
#define ICSR_ISRPREEMPT                (0x1 << 23)
#define ICSR_PENDSTCLR                 (0x1 << 25)
#define ICSR_PENDSTSET                 (0x1 << 26)
#define ICSR_PENDSVCLR                 (0x1 << 27)
#define ICSR_PENDSVSET                 (0x1 << 28)
#define ICSR_NMIPENDSET                (0x1 << 31)

/* Reset Value for VTOR*/
#define VTOR_RVAL                      0x0 

/* Masks for bitfields in VTOR*/
#define VTOR_TBLOFF_MSK                (0x3FFFFF << 7)
#define VTOR_TBLBASE                   (0x1 << 29)

/* Reset Value for AIRCR*/
#define AIRCR_RVAL                     0xFA050000 

/* Masks for bitfields in AIRCR*/
#define AIRCR_VECTRESET                (0x1 << 0)
#define AIRCR_VECTCLRACTIVE            (0x1 << 1)
#define AIRCR_SYSRESETREQ              (0x1 << 2)
#define AIRCR_PRIGROUP_MSK             (0x7 << 8)
#define AIRCR_ENDIANESS                (0x1 << 15)
#define AIRCR_VECTKEYSTAT_MSK          (0xFFFF << 16)

/* Reset Value for SCR*/
#define SCR_RVAL                       0x0 

/* Masks for bitfields in SCR*/
#define SCR_SLEEPONEXIT                (0x1 << 1)
#define SCR_SLEEPDEEP                  (0x1 << 2)
#define SCR_SEVONPEND                  (0x1 << 4)

/* Reset Value for CCR*/
#define CCR_RVAL                       0x200 

/* Masks for bitfields in CCR*/
#define CCR_NONBASETHRDENA             (0x1 << 0)
#define CCR_USERSETMPEND               (0x1 << 1)
#define CCR_UNALIGNTRP                 (0x1 << 3)
#define CCR_DIV0TRP                    (0x1 << 4)
#define CCR_BFHFNMIGN                  (0x1 << 8)
#define CCR_STKALIGN                   (0x1 << 9)

/* Reset Value for SHPR1*/
#define SHPR1_RVAL                     0x0 

/* Masks for bitfields in SHPR1*/
#define SHPR1_PRI4_MSK                 (0xFF << 0)
#define SHPR1_PRI5_MSK                 (0xFF << 8)
#define SHPR1_PRI6_MSK                 (0xFF << 16)
#define SHPR1_PRI7_MSK                 (0xFF << 24)

/* Reset Value for SHPR2*/
#define SHPR2_RVAL                     0x0 

/* Masks for bitfields in SHPR2*/
#define SHPR2_PRI8_MSK                 (0xFF << 0)
#define SHPR2_PRI9_MSK                 (0xFF << 8)
#define SHPR2_PRI10_MSK                (0xFF << 16)
#define SHPR2_PRI11_MSK                (0xFF << 24)

/* Reset Value for SHPR3*/
#define SHPR3_RVAL                     0x0 

/* Masks for bitfields in SHPR3*/
#define SHPR3_PRI12_MSK                (0xFF << 0)
#define SHPR3_PRI13_MSK                (0xFF << 8)
#define SHPR3_PRI14_MSK                (0xFF << 16)
#define SHPR3_PRI15_MSK                (0xFF << 24)

/* Reset Value for SHCSR*/
#define SHCSR_RVAL                     0x0 

/* Masks for bitfields in SHCSR*/
#define SHCSR_MEMFAULTACT              (0x1 << 0)
#define SHCSR_BUSFAULTACT              (0x1 << 1)
#define SHCSR_USGFAULTACT              (0x1 << 3)
#define SHCSR_SVCALLACT                (0x1 << 7)
#define SHCSR_MONITORACT               (0x1 << 8)
#define SHCSR_PENDSVACT                (0x1 << 10)
#define SHCSR_SYSTICKACT               (0x1 << 11)
#define SHCSR_USGFAULTPENDED           (0x1 << 12)
#define SHCSR_MEMFAULTPENDED           (0x1 << 13)
#define SHCSR_BUSFAULTPENDED           (0x1 << 14)
#define SHCSR_SVCALLPENDED             (0x1 << 15)
#define SHCSR_MEMFAULTENA              (0x1 << 16)
#define SHCSR_BUSFAULTENA              (0x1 << 17)
#define SHCSR_USGFAULTENA              (0x1 << 18)

/* Reset Value for CFSR*/
#define CFSR_RVAL                      0x0 

/* Masks for bitfields in CFSR*/
#define CFSR_IACCVIOL                  (0x1 << 0)
#define CFSR_DACCVIOL                  (0x1 << 1)
#define CFSR_MUNSTKERR                 (0x1 << 3)
#define CFSR_MSTKERR                   (0x1 << 4)
#define CFSR_MMARVALID                 (0x1 << 7)
#define CFSR_IBUSERR                   (0x1 << 8)
#define CFSR_PRECISERR                 (0x1 << 9)
#define CFSR_IMPRECISERR               (0x1 << 10)
#define CFSR_UNSTKERR                  (0x1 << 11)
#define CFSR_STKERR                    (0x1 << 12)
#define CFSR_BFARVALID                 (0x1 << 15)
#define CFSR_UNDEFINSTR                (0x1 << 16)
#define CFSR_INVSTATE                  (0x1 << 17)
#define CFSR_INVPC                     (0x1 << 18)
#define CFSR_NOCP                      (0x1 << 19)
#define CFSR_UNALIGNED                 (0x1 << 24)
#define CFSR_DIVBYZERO                 (0x1 << 25)

/* Reset Value for HFSR*/
#define HFSR_RVAL                      0x0 

/* Masks for bitfields in HFSR*/
#define HFSR_VECTTBL                   (0x1 << 1)
#define HFSR_FORCED                    (0x1 << 30)
#define HFSR_DEBUGEVT                  (0x1 << 31)

/* Reset Value for MMFAR*/
#define MMFAR_RVAL                     0x0 

/* Masks for bitfields in MMFAR*/
#define MMFAR_ADDRESS_MSK              (0xFFFFFFFF << 0)

/* Reset Value for BFAR*/
#define BFAR_RVAL                      0x0 

/* Masks for bitfields in BFAR*/
#define BFAR_ADDRESS_MSK               (0xFFFFFFFF << 0)

/* Reset Value for STIR*/
#define STIR_RVAL                      0x0 

/* Masks for bitfields in STIR*/
#define STIR_INTID_MSK                 (0x3FF << 0)


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* SAR ADC                                            Base Address 0x40050000 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for ADCCFG*/
#define ADCCFG_RVAL                    0xA00 
#define ADCCFG_LVDDREF_BBA             (*(volatile unsigned long *) 0x42A00034)

/* Masks for bitfields in ADCCFG*/
#define ADCCFG_CHSEL_MSK               (0xF << 0)
#define ADCCFG_ACQ_MSK                 (0x3 << 8)
#define ADCCFG_CLK_MSK                 (0x7 << 10)
#define ADCCFG_LVDDREF                 (0x1 << 13)

/* Channel select  */
#define ADCCFG_CHSEL_ADC0              (0 << 0)
#define ADCCFG_CHSEL_ADC1              (1 << 0)
#define ADCCFG_CHSEL_ADC2              (2 << 0)
#define ADCCFG_CHSEL_ADC3              (3 << 0)
#define ADCCFG_CHSEL_ADC4              (4 << 0)
#define ADCCFG_CHSEL_ADC5              (5 << 0)
#define ADCCFG_CHSEL_VBATDIV4          (6 << 0)
#define ADCCFG_CHSEL_TEMP              (9 << 0)
#define ADCCFG_CHSEL_AGND              (10 << 0)
#define ADCCFG_CHSEL_VREF              (11 << 0)
#define ADCCFG_CHSEL_LDDDIV2           (12 << 0)
/* Acquisition clocks  */
#define ADCCFG_ACQ_2                   (0 << 8)
#define ADCCFG_ACQ_4                   (1 << 8)
#define ADCCFG_ACQ_8                   (2 << 8)
#define ADCCFG_ACQ_16                  (3 << 8)
/* ADC clock frequency  */
#define ADCCFG_CLK_FCORE               (0 << 10)
#define ADCCFG_CLK_FCOREDIV2           (1 << 10)
#define ADCCFG_CLK_FCOREDIV4           (2 << 10)
#define ADCCFG_CLK_FCOREDIV8           (3 << 10)
#define ADCCFG_CLK_FCOREDIV16          (4 << 10)
#define ADCCFG_CLK_FCOREDIV32          (5 << 10)
/* Reference select  */
#define ADCCFG_LVDDREF_LVDD            (1 << 13)
#define ADCCFG_LVDDREF_INTERNAL125V    (0 << 13)
/* Reset Value for ADCCON*/
#define ADCCON_RVAL                    0x90 
#define ADCCON_START_BBA               (*(volatile unsigned long *) 0x42A00080)
#define ADCCON_PD_BBA                  (*(volatile unsigned long *) 0x42A00090)
#define ADCCON_IRQ_BBA                 (*(volatile unsigned long *) 0x42A00094)
#define ADCCON_DMA_BBA                 (*(volatile unsigned long *) 0x42A00098)
#define ADCCON_REF_BBA                 (*(volatile unsigned long *) 0x42A0009C)

/* Masks for bitfields in ADCCON*/
#define ADCCON_START                   (0x1 << 0)
#define ADCCON_MOD_MSK                 (0x7 << 1)
#define ADCCON_PD                      (0x1 << 4)
#define ADCCON_IRQ                     (0x1 << 5)
#define ADCCON_DMA                     (0x1 << 6)
#define ADCCON_REF                     (0x1 << 7)

/* Conversion Mode  */
#define ADCCON_MOD_SOFT                (0 << 1)
#define ADCCON_MOD_CONT                (1 << 1)
#define ADCCON_MOD_T0OVF               (3 << 1)
#define ADCCON_MOD_T1OVF               (4 << 1)
#define ADCCON_MOD_GPIO                (5 << 1)
/* Internal reference enable  */
#define ADCCON_REF_DIS                 (1 << 7)
#define ADCCON_REF_EN                  (0 << 7)
/* Reset Value for ADCSTA*/
#define ADCSTA_RVAL                    0x0 
#define ADCSTA_READY_BBA               (*(volatile unsigned long *) 0x42A00100)

/* Masks for bitfields in ADCSTA*/
#define ADCSTA_READY                   (0x1 << 0)

/* Reset Value for ADCDAT*/
#define ADCDAT_RVAL                    0x0 

/* Masks for bitfields in ADCDAT*/
#define ADCDAT_VALUE_MSK               (0xFFF << 2)

/* Reset Value for ADCGN*/
#define ADCGN_RVAL                     0x0 

/* Masks for bitfields in ADCGN*/
#define ADCGN_VALUE_MSK                (0xFFFF << 0)

/* Reset Value for ADCOF*/
#define ADCOF_RVAL                     0x0 

/* Masks for bitfields in ADCOF*/
#define ADCOF_VALUE_MSK                (0xFFFF << 0)


/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* High Frequency Oscillator Trim (Rev C Only)        Base Address 0x40009C00 */
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
/* Reset Value for HFTSTA*/
#define HFTSTA_RVAL                    0x0 
#define HFTSTA_END_BBA                 (*(volatile unsigned long *) 0x42138000)
#define HFTSTA_OF_BBA                  (*(volatile unsigned long *) 0x42138004)
#define HFTSTA_MAX_BBA                 (*(volatile unsigned long *) 0x42138008)
#define HFTSTA_MIN_BBA                 (*(volatile unsigned long *) 0x4213800C)
#define HFTSTA_INC_BBA                 (*(volatile unsigned long *) 0x42138010)
#define HFTSTA_DEC_BBA                 (*(volatile unsigned long *) 0x42138014)

/* Masks for bitfields in HFTSTA*/
#define HFTSTA_END                     (0x1 << 0)
#define HFTSTA_OF                      (0x1 << 1)
#define HFTSTA_MAX                     (0x1 << 2)
#define HFTSTA_MIN                     (0x1 << 3)
#define HFTSTA_INC                     (0x1 << 4)
#define HFTSTA_DEC                     (0x1 << 5)

/* Reset Value for HFTCON*/
#define HFTCON_RVAL                    0x0 
#define HFTCON_ENDIEN_BBA              (*(volatile unsigned long *) 0x42138080)
#define HFTCON_OFIEN_BBA               (*(volatile unsigned long *) 0x42138084)
#define HFTCON_MAXIEN_BBA              (*(volatile unsigned long *) 0x42138088)
#define HFTCON_MINIEN_BBA              (*(volatile unsigned long *) 0x4213808C)
#define HFTCON_ENABLE_BBA              (*(volatile unsigned long *) 0x42138090)
#define HFTCON_TOL_BBA                 (*(volatile unsigned long *) 0x42138094)
#define HFTCON_STICK_BBA               (*(volatile unsigned long *) 0x42138098)
#define HFTCON_CLR_BBA                 (*(volatile unsigned long *) 0x4213809C)

/* Masks for bitfields in HFTCON*/
#define HFTCON_ENDIEN                  (0x1 << 0)
#define HFTCON_OFIEN                   (0x1 << 1)
#define HFTCON_MAXIEN                  (0x1 << 2)
#define HFTCON_MINIEN                  (0x1 << 3)
#define HFTCON_ENABLE                  (0x1 << 4)
#define HFTCON_TOL                     (0x1 << 5)
#define HFTCON_STICK                   (0x1 << 6)
#define HFTCON_CLR                     (0x1 << 7)

/* Reset Value for HFTMAX*/
#define HFTMAX_RVAL                    0x0 

/* Masks for bitfields in HFTMAX*/
#define HFTMAX_MAX_MSK                 (0xFF << 0)

/* Reset Value for HFTMIN*/
#define HFTMIN_RVAL                    0x0 

/* Masks for bitfields in HFTMIN*/
#define HFTMIN_MIN_MSK                 (0xFF << 0)

/* Reset Value for HFTTRM*/
#define HFTTRM_RVAL                    0x0 

/* Masks for bitfields in HFTTRM*/
#define HFTTRM_TRM_MSK                 (0xFF << 0)

/* Reset Value for HFTXMAX*/
#define HFTXMAX_RVAL                   0x0 

/* Masks for bitfields in HFTXMAX*/
#define HFTXMAX_XMAX_MSK               (0xFF << 0)

/* Reset Value for HFTXVAL*/
#define HFTXVAL_RVAL                   0x0 

/* Masks for bitfields in HFTXVAL*/
#define HFTXVAL_XVAL_MSK               (0xFF << 0)

/* Reset Value for HFTUMAX*/
#define HFTUMAX_RVAL                   0x0 

/* Masks for bitfields in HFTUMAX*/
#define HFTUMAX_UMAX_MSK               (0x1FFF << 0)

/* Reset Value for HFTUVAL*/
#define HFTUVAL_RVAL                   0x0 

/* Masks for bitfields in HFTUVAL*/
#define HFTUVAL_UVAL_MSK               (0x1FFF << 0)


#endif /* __MACROS_ADUCRF101_H__ */
